/*
 *
 *  OS/2 to Windows resource conversion utility include file
 *
 */

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>

#define HFILE HANDLE
#define FALSE  0
#define TRUE   1
#define _fstrlen strlen
#define _fstrncpy strncpy
#define _fstrchr strchr
#define _fmalloc malloc
#define _ffree   free


/*  Additional constants */

#define not         !
#define cant        !
#define no          !
#define forever     for ( ; ; )

/*  Define NULL appropriately */

#if defined (NULL)
#undef  NULL
#endif
#define NULL 0L

/*  Additional types */

#define ptr FAR *

typedef unsigned char  uchar;
typedef unsigned short uint;
typedef unsigned short ushort;
typedef unsigned long  ulong;
typedef unsigned short flag;

/*  Maximum file name size */

#define MaxFile 260

/*  Miscellaneous macro functions */

#define ucharsizeof(x)  ((sizeof (x) + sizeof (uchar)  - 1) / sizeof (uchar))
#define MAX(a, b)  ((a) > (b) ? (a) : (b))
#define MIN(a, b)  ((a) < (b) ? (a) : (b))

/*  Useful defines. */

#define max_buffer_bytes            8192
#define max_string_size             512
#define max_comment_size            2048
#define max_identifier_size         32

/*  These literals are returned by the get_char_case procedure. */

#define char_case_none              0
#define char_case_lower             1
#define char_case_upper             2

/*  Defines for special characters. */

#define char_quote_double           '"'
#define char_minus                  '-'
#define char_plus                   '+'
#define char_slash                  '/'
#define char_back_slash             '\\'
#define char_dot                    '.'
#define char_star                   '*'
#define char_comma                  ','
#define char_pipe                   '|'
#define char_space                  ' '
#define char_bracket_begin          '{'
#define char_bracket_end            '}'
#define char_underscore             '_'
#define char_less_than              '<'
#define char_greater_than           '>'
#define char_pound_sign             '#'
#define char_eof                    0xFF
#define char_tab                    0x09
#define char_lf                     0x0A
#define char_cr                     0x0D

/*  Token type defines. */

#define tok_undefined                0
#define tok_numeric                  1
#define tok_string                   2
#define tok_keyword                  3
#define tok_constant                 4
#define tok_filename                 5
#define tok_comma                    6
#define tok_bitor                    7
#define tok_plus                     8
#define tok_pound_sign               9
#define tok_eof                     10

/*  Defines for keywords. */

#define tok_acceltable              20
#define tok_alt                     21
#define tok_begin                   22
#define tok_bitmap                  23
#define tok_bs_autocheckbox         24
#define tok_bs_autoradiobutton      25
#define tok_bs_checkbox             26
#define tok_bs_default              27
#define tok_bs_help                 28
#define tok_bs_nopointerfocus       29
#define tok_bs_pushbutton           30
#define tok_bs_radiobutton          31
#define tok_cbs_dropdown            32
#define tok_cbs_dropdownlist        33
#define tok_cbs_simple              34
#define tok_char                    35
#define tok_control                 36
#define tok_dialog                  37
#define tok_discardable             38
#define tok_dlgtemplate             39
#define tok_dt_bottom               40
#define tok_dt_center               41
#define tok_dt_left                 42
#define tok_dt_mnemonic             43
#define tok_dt_right                44
#define tok_dt_top                  45
#define tok_dt_vcenter              46
#define tok_dt_wordbreak            47
#define tok_end                     48
#define tok_es_autoscroll           49
#define tok_es_center               50
#define tok_es_left                 51
#define tok_es_margin               52
#define tok_es_right                53
#define tok_fcf_sysmenu             54
#define tok_fcf_titlebar            55
#define tok_fixed                   56
#define tok_frame                   57
#define tok_fs_border               58
#define tok_fs_dlgborder            59
#define tok_fs_mousealign           60
#define tok_fs_nobytealign          61
#define tok_icon                    62
#define tok_include                 63
#define tok_loadoncall              64
#define tok_ls_horzscroll           65
#define tok_ls_multiplesel          66
#define tok_menu                    67
#define tok_menuitem                68
#define tok_mia_disabled            69
#define tok_mis_bitmap              70
#define tok_mis_break               71
#define tok_mis_ownerdraw           72
#define tok_mis_text                73
#define tok_moveable                74
#define tok_pointer                 75
#define tok_preload                 76
#define tok_rcinclude               77
#define tok_resource                78
#define tok_sbs_horz                79
#define tok_sbs_vert                80
#define tok_separator               81
#define tok_shift                   82
#define tok_stringtable             83
#define tok_ss_fgndframe            84
#define tok_ss_groupbox             85
#define tok_ss_halftoneframe        86
#define tok_ss_text                 87
#define tok_submenu                 88
#define tok_virtualkey              89
#define wc_button                   90
#define wc_combobox                 91
#define wc_entryfield               92
#define wc_listbox                  93
#define wc_scrollbar                94
#define wc_static                   95
#define tok_ws_clipsiblings         96
#define tok_ws_group                97
#define tok_ws_savebits             98
#define tok_ws_tabstop              99
#define tok_ws_visible              100
#define tok_dt_halftone 	    101
#define tok_fcf_nobytealign	    102
#define tok_dlginclude		    103
#define tok_ls_ownerdraw	    104
#define wc_mle			    105
#define tok_mls_vscroll 	    106
#define tok_mls_wordwrap	    107
#define tok_helptable		    108
#define tok_helpsubtable	    109
#define tok_mls_border		    110
#define tok_syscommand		    111
#define tok_mis_syscommand	    112
#define tok_mis_submenu 	    113
#define tok_ss_icon		    114
#define tok_did_ok		    115
#define tok_did_cancel		    116
#define tok_fs_icon		    117
#define tok_mia_checked 	    118
#define tok_fcf_dlgborder	    119
#define tok_mis_separator	    120
#define tok_ltext		    121
#define tok_rtext		    122
#define tok_ctext		    123
#define tok_radiobutton 	    125
#define tok_autoradiobutton	    126
#define tok_checkbox		    127
#define tok_autocheckbox	    128
#define tok_pushbutton		    129
#define tok_defpushbutton	    130
#define tok_listbox		    131
#define tok_groupbox		    132
#define tok_entryfield		    133
#define tok_fcf_minbutton	    134
#define tok_fcf_icon		    135
#define tok_mis_breakseparator	    136
#define tok_mis_buttonseparator    137

/*  Defines for different error messages. */

#define err_undefined                0
#define err_full_put_char_buffer     1
#define err_full_put_token_buffer    2
#define err_no_source_file           3
#define err_unexpected_comment_char  4
#define err_unexpected_eof           5
#define err_string_too_long          6
#define err_identifier_too_long      7
#define err_value_too_big            8
#define err_invalid_syntax           9
#define err_invalid_character       10
#define err_bad_menu_option         11
#define err_bad_load_option         12
#define err_bad_dialog_option       13
#define err_bad_control_class       14
#define err_bad_accel_option        15
#define err_convert_resources       16


// John Hall additions
extern int is_debug_on;
