/*

Copyright (c) 1991-1993  Microsoft Corporation

Module Name:

    alert.h

Abstract:

    This file contains structures for communication with the Alerter
    service.

Notes:

    You must include LmCons.H before this file, since this file depends
    on values defined in LmCons.H.

    ALERT.H includes ALERTMSG.H which defines the alert message numbers

--*/


#ifndef _ALERT_
#define _ALERT_


//
// Function Prototypes
//

NET_API_STATUS NET_API_FUNCTION
NetAlertRaise(
    IN LPTSTR AlertEventName,
    IN LPVOID Buffer,
    IN DWORD BufferSize
    );

NET_API_STATUS NET_API_FUNCTION
NetAlertRaiseEx(
    IN LPTSTR AlertEventName,
    IN LPVOID VariableInfo,
    IN DWORD VariableInfoSize,
    IN LPTSTR ServiceName
    );


//
//  Data Structures
//

typedef struct _STD_ALERT {
    DWORD  alrt_timestamp;
    TCHAR  alrt_eventname[EVLEN + 1];
    TCHAR  alrt_servicename[SNLEN + 1];
}STD_ALERT, *PSTD_ALERT, *LPSTD_ALERT;

typedef struct _ADMIN_OTHER_INFO {
    DWORD  alrtad_errcode;
    DWORD  alrtad_numstrings;
}ADMIN_OTHER_INFO, *PADMIN_OTHER_INFO, *LPADMIN_OTHER_INFO;

typedef struct _ERRLOG_OTHER_INFO {
    DWORD  alrter_errcode;
    DWORD  alrter_offset;
}ERRLOG_OTHER_INFO, *PERRLOG_OTHER_INFO, *LPERRLOG_OTHER_INFO;

typedef struct _PRINT_OTHER_INFO {
    DWORD  alrtpr_jobid;
    DWORD  alrtpr_status;
    DWORD  alrtpr_submitted;
    DWORD  alrtpr_size;
}PRINT_OTHER_INFO, *PPRINT_OTHER_INFO, *LPPRINT_OTHER_INFO;

typedef struct _USER_OTHER_INFO {
    DWORD  alrtus_errcode;
    DWORD  alrtus_numstrings;
}USER_OTHER_INFO, *PUSER_OTHER_INFO, *LPUSER_OTHER_INFO;

//
// Special Values and Constants
//

//
// Name of mailslot to send alert notifications
//
#define ALERTER_MAILSLOT          TEXT("\\\\.\\MAILSLOT\\Alerter")

//
// The following macro gives a pointer to the other_info data.
// It takes an alert structure and returns a pointer to structure
// beyond the standard portion.
//

#define ALERT_OTHER_INFO(x)    ((LPBYTE)(x) + sizeof(STD_ALERT))

//
// The following macro gives a pointer to the variable-length data.
// It takes a pointer to one of the other-info structs and returns a
// pointer to the variable data portion.
//

#define ALERT_VAR_DATA(p)      ((LPBYTE)(p) + sizeof(*p))

//
//      Names of standard Microsoft-defined alert events.
//

#define ALERT_PRINT_EVENT           TEXT("PRINTING")
#define ALERT_MESSAGE_EVENT         TEXT("MESSAGE")
#define ALERT_ERRORLOG_EVENT        TEXT("ERRORLOG")
#define ALERT_ADMIN_EVENT           TEXT("ADMIN")
#define ALERT_USER_EVENT            TEXT("USER")

#endif // _ALERT_

