/*
 * OLEINS.C
 *
 * Functions to handle the Insert Object command as well as the
 * Insert Object dialog.  Calls functions in REGISTER.C to query
 * the registration database for object classnames.
 *
 * Also contains the FObjectsFromDropFiles function to create embedded
 * Packager objects from files dropped from File Manager.
 *
 * Copyright(c) Microsoft Corp. 1992 All Rights Reserved
 */

#include <windows.h>
#include <ole.h>
#include "register.h"
#include "oclient.h"



/*
 * PObjectInsertDialog
 *
 * Purpose:
 *  Displays the Insert Object dialog and creates an object of the
 *  selected name.  The caller must provide the name of the object
 *  to create.  NOTE:  Uses pDoc->pszData1.
 *
 * Parameters:
 *  hWnd            HWND parent of the dialog box.
 *  hInst           HANDLE of the application instance.
 *  pDoc            LPDOCUMENT identifying OLE data.
 *  pszObject       LPSTR to the name for a new object.
 *
 * Return Value:
 *  LPOBJECT        Pointer to a new OBJECT if the function succeeds.
 *                  NULL otherwise or if the user pressed Cancel.
 */

LPOBJECT FAR PASCAL PObjectInsertDialog(HWND hWnd, HANDLE hInst,
                                        LPDOCUMENT pDoc, LPSTR pszObject)
    {
    FARPROC         lpfn;
    WORD            wTemp;
    BOOL            fTemp;
    LPOBJECT        pObj;
    OLESTATUS       os;

    if (NULL==pszObject)
        return NULL;

    /*
     * Pass a string pointer to the dialog in which the it will return
     * the object class name.
     */

    lpfn=MakeProcInstance(InsertObjectProc, hInst);
    wTemp=DialogBoxParam(hInst, MAKEINTRESOURCE(IDD_INSERTOBJECT), hWnd,
                         lpfn, (LONG)pDoc->pszData1);
    FreeProcInstance(lpfn);

    //Out of memory==-1, User pressed cancel==0
    if (1!=wTemp)
        return NULL;

    pObj=PObjectAllocate(&fTemp, pDoc);

    if (!fTemp)
        {
        PObjectFree(pDoc, pObj);
        return NULL;
        }

    //Attempt to launch the server to give us the object.
    os=OleCreate(PSZOLE(IDS_STDFILEEDITING), (LPOLECLIENT)pObj, pDoc->pszData1,
                 pDoc->lh, pszObject, &pObj->pObj, olerender_draw, 0);

    if (OLE_OK!=OsError(os, pDoc, pObj, TRUE))
        {
        MessageBox(hWnd, PSZOLE(IDS_NOINSERT), PSZOLE(IDS_INSERTTITLE),
                   MB_OK | MB_ICONEXCLAMATION);

        PObjectFree(pDoc, pObj);
        return NULL;
        }
    else
        {
        //Mark this guy as open.
        pObj->fOpen=TRUE;
        }

    return pObj;
    }





/*
 * InsertObjectProc
 *
 * Purpose:
 *  Dialog procedure for the Insert Object dialog.
 *
 * Parameters:
 *  The standard.
 *
 * Return Value:
 *  The value to be returned through the DialogBox call that
 *  created the dialog.
 *
 */

BOOL FAR PASCAL InsertObjectProc(HWND hDlg, WORD iMsg, WORD wParam, LONG lParam)
    {
    static LPSTR    pszObject;
    WORD            i;
    WORD            cb;
    HWND            hList;
    char            szTemp[256];

    switch (iMsg)
        {
        case WM_INITDIALOG:
            pszObject=(LPSTR)lParam;

            //Go fill the listbox with names from the registration database.
            hList=GetDlgItem(hDlg, ID_OBJECTLIST);
            WFillClassList(hList);
            return TRUE;


        case WM_COMMAND:
            switch (wParam)
                {
                case IDCANCEL:
                    EndDialog(hDlg, FALSE);
                    break;

                //Double-clicking is the same as hitting OK.
                case ID_OBJECTLIST:
                    if (LBN_DBLCLK!=HIWORD(lParam))
                        break;

                    //FALL THROUGH.

                case IDOK:
                    hList=GetDlgItem(hDlg, ID_OBJECTLIST);
                    i=(WORD)SendMessage(hList, LB_GETCURSEL, 0, 0L);

                    //Convert the descriptive name to a real classname.
                    SendMessage(hList, LB_GETTEXT, i, (LONG)(LPSTR)szTemp);
                    cb=WClassFromDescription(szTemp, pszObject, 256);

                    EndDialog(hDlg, TRUE);
                    break;
                }
            break;
        }
    return FALSE;
    }
