/*
 * PATRON.H
 *
 * Definitions and function prototypes for Patron.  OLE only affects
 * a few minor parts of this file which are marked with a comments like
 * "//OLE"
 *
 * Copyright(c) Microsoft Corp. 1992 All Rights Reserved
 */

//Resource identifiers.
#define IDR_MENU                1
#define IDR_ACCELERATORS        1
#define IDD_ABOUT               1
#define ID_NULL                 -1      //Static controls


//Menu command identifiers.
#define IDM_FILENEW             100
#define IDM_FILEOPEN            101
#define IDM_FILESAVE            102
#define IDM_FILESAVEAS          103
#define IDM_FILEEXIT            104

#define IDM_EDITCUT             200
#define IDM_EDITCOPY            201
#define IDM_EDITPASTE           202
#define IDM_EDITPASTELINK       203   //OLE
#define IDM_EDITLINKS           204   //OLE
#define IDM_EDITINSERTOBJECT    205   //OLE
#define IDM_EDITCONVERTTOSTATIC 206   //OLE
#define IDM_EDITCLEAR           207
#define IDM_EDITCLEARALL        208


#define IVERBMENU                12   //OLE: Menu position of the 'Object' item.
#define IDM_EDITVERBMIN         250   //OLE: Values IDM_EDITVERBMIN+n specify a
#define IDM_EDITVERBMAX         299   //OLE: verb from 0-n was selected

#define IDM_HELPABOUT           400



//String ID values.  Keep in SEQUENTIAL order and use 0-n
#define IDS_FIRST               0
#define IDS_CAPTION             IDS_FIRST+0
#define IDS_CLASSPATRON         IDS_FIRST+1
#define IDS_CLASSBLACKBOX       IDS_FIRST+2
#define IDS_FILEDIRTY           IDS_FIRST+3
#define IDS_DEFEXT              IDS_FIRST+4
#define IDS_FILEOPENFILTER      IDS_FIRST+5
#define IDS_FILEOPEN            IDS_FIRST+6
#define IDS_FILESAVEAS          IDS_FIRST+7
#define IDS_UNTITLED            IDS_FIRST+8
#define IDS_LAST                IDS_FIRST+9


/*
 * CSTRINGS is number of strings to load from the stringtable.
 * CCHSTRINGMAX is the maximum length that any string is allowed.
 */

#define CSTRINGS                (IDS_LAST-IDS_FIRST)
#define CCHSTRINGMAX            80



/*
 * Structure holding the "global" variables.  Creating a structure with
 * has several advantages over separately declaring each field as a
 * global:
 *  1.  Keep source files clean.
 *  2.  Eliminates need for many "extern" declarations.
 *  3.  A single pointer to this structure can be passed throughout
 *      the application, hiding the fact that it's global.
 *  4.  Allows the variables to be allocated dynamically or from
 *      different memory than the application's stack.
 *  5.  Any reference to these variables will have a pointer or
 *      structure dereference, which points to where the variable
 *      actually is defined.  Separate globals are not distinguishable
 *      from locals, making code harder to read.
 */

typedef struct
    {
    HWND        hWnd;               //Top-level application window.
    HANDLE      hInst;              //Application instance handle.
    LPSTR       pszCmdLine;         //Command line passed to WinMain.
    HANDLE      hMemStrings;        //Stringtable memory.
    HANDLE      hAccel;             //Application accelerators.
    BOOL        fDirty;             //Is file dirty?
    BOOL        fOpenFile;          //FALSE if File/New used until saved.
    char        szFile[CCHPATHMAX]; //Filename for Save command.
    HWND        hWndLastActive;     //Handle to most recently active BlackBox
    } GLOBALS;

typedef GLOBALS FAR * LPGLOBALS;


//External:
extern char NEAR *rgpsz[CSTRINGS];
extern LPGLOBALS pGlob;
extern LPDOCUMENT  pDoc;  //OLE:  Our handle into the OLE world.


//Versioning.
#define VERSIONMAJOR            1
#define VERSIONMINOR            0



/*
 * PATRON is the file header structure.  Files are an array of FILEOBJECT
 * structures defined in BLACKBOX.H.
 *
 * Any OLE data is stored after it with OleSaveToStream.
 */

typedef struct
    {
    WORD        wVerMajor;      //Version number
    WORD        wVerMinor;
    RECT        rc;             //Rectangle
    DWORD       dwState;        //Initial state
    DWORD       cObjects;       //Number of FILEOBJECT structures.
    } PATRON;

typedef PATRON FAR *LPPATRON;
#define CBPATRON sizeof(PATRON)



/*
 * Function prototypes, organized by source file.  Any small definition
 * required by only one source file is also included here under the
 * same heading.
 */

//CLIP.C
void     FAR PASCAL MenuClipboardEnable(HMENU, LPGLOBALS);
BOOL     FAR PASCAL FEditCut(LPGLOBALS);
BOOL     FAR PASCAL FEditCopy(LPGLOBALS, BOOL);
BOOL     FAR PASCAL FEditPaste(LPGLOBALS, BOOL, LPDOCUMENT);
BOOL     FAR PASCAL FEditConvertToStatic(LPGLOBALS, LPDOCUMENT);


//INSDROP.C
BOOL     FAR PASCAL FEditInsertObject(HWND, HANDLE, LPDOCUMENT);
BOOL     FAR PASCAL FCreateFromDropFiles(HWND, HANDLE, LPDOCUMENT);


//EXIT.C
BOOL     FAR PASCAL FApplicationExit(LPGLOBALS);


//FILE.C
void     FAR PASCAL WindowTitleSet(LPGLOBALS);
BOOL     FAR PASCAL FDirtySet(BOOL);
BOOL     FAR PASCAL FCleanVerify(LPGLOBALS, LPDOCUMENT);
BOOL     FAR PASCAL FFileNew(LPGLOBALS, LPDOCUMENT);
BOOL     FAR PASCAL FFileOpen(LPGLOBALS, LPDOCUMENT, BOOL);
BOOL     FAR PASCAL FFileSave(LPGLOBALS, LPDOCUMENT, BOOL);
BOOL     FAR PASCAL FFileSaveAs(LPGLOBALS, LPDOCUMENT);
BOOL     FAR PASCAL FFileExit(LPGLOBALS, LPDOCUMENT);
BOOL     FAR PASCAL FFileClose(LPGLOBALS, LPDOCUMENT);
BOOL     FAR PASCAL FEnumClose(LPDOCUMENT, LPOBJECT, DWORD);


//FILEIO.C
BOOL     FAR PASCAL FPtnFileRead(LPSTR, LPPATRON, HWND, LPDOCUMENT);
BOOL     FAR PASCAL FPtnFileWrite(LPSTR, LPPATRON, LPDOCUMENT);
BOOL     FAR PASCAL FEnumFileWrite(LPDOCUMENT, LPOBJECT, DWORD);


//INIT.C
BOOL     FAR PASCAL FApplicationInit(LPGLOBALS, HANDLE);
BOOL     FAR PASCAL FClassRegister(LPGLOBALS, HANDLE);
HWND     FAR PASCAL HPolylineWindowCreate(HWND, HANDLE);
HANDLE   FAR PASCAL HLoadAppStrings(HANDLE);


//PATRON.C
BOOL     FAR PASCAL FMessageProcess(LPMSG);
LONG     FAR PASCAL PatronWndProc(HWND, UINT, UINT, LONG);
BOOL     FAR PASCAL FEnumClearAll(LPDOCUMENT, LPOBJECT, DWORD);
void     FAR PASCAL WindowDelete(HWND, HWND);
BOOL     FAR PASCAL AboutProc(HWND, UINT, UINT, LONG);
int      FAR PASCAL ClientCallback(LPOBJECT, OLE_NOTIFICATION, LPOLEOBJECT);
