/*
 * OLEGLOBL.H
 *
 * Definitions an other globals specific to the OLE code.
 *
 */

#ifdef MAKEOLESERVER

#ifndef CCHPATHMAX
#define CCHPATHMAX          256
#endif

#ifndef CCHFILENAME
#define CCHFILENAMEMAX      15
#endif


typedef LPOLESERVER    FAR *LPLPOLESERVER;
typedef LPOLESERVERDOC FAR *LPLPOLESERVERDOC;
typedef LPOLEOBJECT    FAR *LPLPOLEOBJECT;

typedef LPVOID (FAR PASCAL *LPVOIDPROC) (LPOLEOBJECT, LPSTR);


typedef struct
    {
    LPOLEOBJECTVTBL     pvtbl;          //Standard
    BOOL                fRelease;       //Flag to watch if we need to wait
    LPOLECLIENT         pClient;        //Necessary for notifications
    HANDLE              hMem;           //Memory handle to this structure
    } SCHMOOOBJECT;


typedef SCHMOOOBJECT FAR *LPSCHMOOOBJECT;
#define CBSCHMOOOBJECT sizeof(SCHMOOOBJECT)


typedef struct
    {
    LPOLESERVERDOCVTBL  pvtbl;          //Standard
    LHSERVERDOC         lh;             //Required by OleRegisterServerDoc
    BOOL                fRelease;       //Flag to watch if we need to wait
    ATOM                aObject;        //Name of the document's object
    ATOM                aClient;        //Name of the connected client
    HANDLE              hMem;           //Memory handle to this structure
    LPSCHMOOOBJECT      pObj;           //Last object we allocated
    } SCHMOODOC;


typedef SCHMOODOC FAR *LPSCHMOODOC;
#define CBSCHMOODOC sizeof(SCHMOODOC)


typedef struct
    {
    LPOLESERVERVTBL     pvtbl;          //Standard
    LHSERVER            lh;             //Required by OleRegisterServer
    BOOL                fRelease;       //Flag to watch if we need to wait
    BOOL                fEmbed;         //TRUE if we're embedding only
    BOOL                fLink;          //TRUE if we're linking only
    WORD                wCmdShow;       //OLE-modified window show command
    HWND                hWnd;           //Main application window
    HANDLE              hMem;           //Memory handle to this structure
    LPSCHMOODOC         pDoc;           //Last document we allocated
    } SCHMOOSERVER;

typedef SCHMOOSERVER FAR *LPSCHMOOSERVER;
#define CBSCHMOOSERVER sizeof(SCHMOOSERVER)


/*
 * Single data structure holding any OLE-specific global variables.
 */

typedef struct
    {
    LPSCHMOOSERVER      pSvr;

    OLESERVERVTBL       vtblSvr;
    OLESERVERDOCVTBL    vtblDoc;
    OLEOBJECTVTBL       vtblObj;

    WORD                cfNative;
    WORD                cfOwnerLink;
    WORD                cfObjectLink;
    } XOLEGLOBALS;

typedef XOLEGLOBALS FAR *LPXOLEGLOBALS;
#define CBXOLEGLOBALS sizeof(XOLEGLOBALS)


//The single global
extern LPXOLEGLOBALS pOLE;


/*
 * STDTARGETDEVICE structure for ObjSetTargetDevice.
 */


typedef struct
    {
    //Offsets are pointers into the data field.
    WORD    deviceNameOffset;   //szDeviceName
    WORD    driverNameOffset;   //szDriverName
    WORD    portNameOffset;     //szPortName
    WORD    extDevModeOffset;   //DEVMODE structure
    WORD    extDevModeSize;     //Size of the DEVMOCE struct, for versioning.
    WORD    environmentOffset;  //Current MS-DOS environment, in a string
    WORD    environmentSize;    //Length of environment string.
    BYTE    data[];
    } STDTARGETDEVICE;

typedef STDTARGETDEVICE FAR * LPSTDTARGETDEVICE;
#define CBSTDTARGETDEVICE sizeof(STDTARGETDEVICE)






/*
 * Function prototypes for OLE-Specific functions.
 */



//OLECLIP.C
BOOL      FAR PASCAL FOLECopyNative(LPXOLEGLOBALS);
BOOL      FAR PASCAL FOLECopyLink(LPXOLEGLOBALS, BOOL, LPSTR);
HANDLE    FAR PASCAL HLinkConstruct(LPSTR, LPSTR, LPSTR);


//OLEDOC.C
LPSCHMOODOC FAR PASCAL PDocumentAllocate(LPOLESERVERDOCVTBL);   //Helper
void        FAR PASCAL DocumentClean(LPSCHMOODOC);              //Helper

OLESTATUS FAR PASCAL DocClose(LPSCHMOODOC);
OLESTATUS FAR PASCAL DocGetObject(LPSCHMOODOC, LPSTR, LPLPOLEOBJECT, LPOLECLIENT);
OLESTATUS FAR PASCAL DocExecute(LPSCHMOODOC, HANDLE);
OLESTATUS FAR PASCAL DocRelease(LPSCHMOODOC);
OLESTATUS FAR PASCAL DocSave(LPSCHMOODOC);
OLESTATUS FAR PASCAL DocSetColorScheme(LPSCHMOODOC, LPLOGPALETTE);
OLESTATUS FAR PASCAL DocSetDocDimensions(LPSCHMOODOC, LPRECT);
OLESTATUS FAR PASCAL DocSetHostNames(LPSCHMOODOC, LPSTR, LPSTR);



//OLEEXIT.C
BOOL FAR PASCAL FOLEExit(LPXOLEGLOBALS);


//OLEFILE.C
LPSCHMOODOC FAR PASCAL PDocRevokeAndCreate(LPXOLEGLOBALS);


//OLEINIT.C
BOOL      FAR PASCAL FOLEInstanceInit(LPXOLEGLOBALS ,HANDLE, LPSTR, LPSTR FAR *, WORD);


//OLEMISC.C
void      FAR PASCAL MenuEmbeddingSet(HWND, LPSTR, BOOL);
void      FAR PASCAL OLEClientNotify(LPSCHMOOOBJECT, WORD);
BOOL      FAR PASCAL FOLEReleaseWait(BOOL FAR *, LONG);



//OLEOBJ.C
LPSCHMOOOBJECT FAR PASCAL PObjectAllocate(LPOLEOBJECTVTBL);

OLESTATUS     FAR PASCAL ObjDoVerb(LPSCHMOOOBJECT, WORD, BOOL, BOOL);
OLECLIPFORMAT FAR PASCAL ObjEnumFormats(LPSCHMOOOBJECT, WORD);
OLESTATUS     FAR PASCAL ObjGetData(LPSCHMOOOBJECT, WORD, LPHANDLE);
LPVOID        FAR PASCAL ObjQueryProtocol(LPSCHMOOOBJECT, LPSTR);
OLESTATUS     FAR PASCAL ObjRelease(LPSCHMOOOBJECT);
OLESTATUS     FAR PASCAL ObjSetBounds(LPSCHMOOOBJECT, LPRECT);
OLESTATUS     FAR PASCAL ObjSetColorScheme(LPSCHMOOOBJECT, LPLOGPALETTE);
OLESTATUS     FAR PASCAL ObjSetData(LPSCHMOOOBJECT, WORD, HANDLE);
OLESTATUS     FAR PASCAL ObjSetTargetDevice(LPSCHMOOOBJECT, HANDLE);
OLESTATUS     FAR PASCAL ObjShow(LPSCHMOOOBJECT, BOOL);



//OLESVR.C
LPSCHMOOSERVER FAR PASCAL PServerAllocate(LPOLESERVERVTBL);

OLESTATUS FAR PASCAL ServerCreate(LPSCHMOOSERVER, LHSERVERDOC, LPSTR, LPSTR, LPLPOLESERVERDOC);
OLESTATUS FAR PASCAL ServerCreateFromTemplate(LPSCHMOOSERVER, LHSERVERDOC, LPSTR, LPSTR, LPSTR, LPLPOLESERVERDOC);
OLESTATUS FAR PASCAL ServerEdit(LPSCHMOOSERVER, LHSERVERDOC, LPSTR, LPSTR, LPLPOLESERVERDOC);
OLESTATUS FAR PASCAL ServerExecute(LPSCHMOOSERVER, HANDLE);
OLESTATUS FAR PASCAL ServerExit(LPSCHMOOSERVER);
OLESTATUS FAR PASCAL ServerOpen(LPSCHMOOSERVER, LHSERVERDOC, LPSTR, LPLPOLESERVERDOC);
OLESTATUS FAR PASCAL ServerRelease(LPSCHMOOSERVER);



//OLEVTBL.C
BOOL      FAR PASCAL FOLEVtblInitServer(HANDLE, LPOLESERVERVTBL);
BOOL      FAR PASCAL FOLEVtblInitDocument(HANDLE, LPOLESERVERDOCVTBL);
BOOL      FAR PASCAL FOLEVtblInitObject(HANDLE, LPOLEOBJECTVTBL);

void      FAR PASCAL OLEVtblFreeServer(LPOLESERVERVTBL);
void      FAR PASCAL OLEVtblFreeDocument(LPOLESERVERDOCVTBL);
void      FAR PASCAL OLEVtblFreeObject(LPOLEOBJECTVTBL);







#endif //MAKEOLESERVER
