/*
 * POLYLINE.H
 *
 * Definitions and function prototypes for the PolyLine window class.
 *
 * Copyright(c) Microsoft Corp. 1992 All Rights Reserved
 */


//Messages
#define PLM_RECTSET         WM_USER
#define PLM_POLYLINESET     WM_USER+1
#define PLM_POLYLINEGET     WM_USER+2
#define PLM_POLYLINENEW     WM_USER+3
#define PLM_BITMAPGET       WM_USER+4
#define PLM_METAFILEGET     WM_USER+5
#define PLM_METAFILEPICTGET WM_USER+6
#define PLM_BACKUPUNDO      WM_USER+7

//Notifications
#define PLN_POINTCHANGE     1
#define PLN_SIZECHANGE      2

//Definitions and structures.
#define CPOLYLINEPOINTS     20
#define CBPOLYLINEWNDEXTRA  sizeof(HANDLE)

typedef struct
    {
    WORD        wVerMaj;                //Major version number.
    WORD        wVerMin;                //Minor version number.
    WORD        cPoints;                //Number of points.
    BOOL        fDrawEntire;            //Flag to draw entire figure.
    RECT        rc;
    POINT       rgpt[CPOLYLINEPOINTS];  //Array of points.
    } POLYLINE;

typedef POLYLINE FAR *LPPOLYLINE;
#define CBPOLYLINE sizeof(POLYLINE)


//Function prototypes.
HWND     FAR PASCAL HPolylineWindowCreate(HWND, HANDLE);
LONG     FAR PASCAL PolylineWndProc(HWND, UINT, UINT, LONG);
DWORD        PASCAL LPolylineUserMessage(HWND, WORD, WORD, LONG, LPPOLYLINE);
void         PASCAL PolylineDraw(HWND, HDC, LPPOLYLINE);
