// editfram.cpp

#include <owl.h>
#include <filewnd.h>
#include <alloc.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include "editfram.h"
#include "mfilewnd.h"

static char DskFile[MAXPATH];

char DefaultMenuName[] = "InitMenu";
char MainMenuName[] = "MainMenu";

TMDIEditFrame::TMDIEditFrame(LPSTR ATitle, LPSTR AMenu, PTModule AModule)
	: TMDIFrame(ATitle, AMenu, AModule),
	WindowMenuPosition(DEFAULTWINDOWMENUPOS) {
	MDISetMenu(DefaultMenuName, INITMENUPOS);

	GetModuleFileName(GetApplication()->hInstance, DskFile, MAXPATH);
	char *index = strrchr(DskFile, '\\');
	*(index + 1) = '\0';
	strcat(DskFile, "MDIEDIT.DTP");
	}

void TMDIEditFrame::SetupWindow(void) {
	TMDIFrame::SetupWindow();

	ffblk findfirstblock;
	if(!findfirst(DskFile, &findfirstblock, FA_NORMAL))
		SendMessage(HWindow, WM_COMMAND, CM_RESTORESTATE, 0L);
	}

void TMDIEditFrame::WMClose(RTMessage Msg) {
	int response = MessageBox(HWindow,
		"Do you wish to save the desktop?",
		"MDI Edit",
		MB_YESNOCANCEL | MB_ICONINFORMATION);
	if(response == IDYES)
		SendMessage(HWindow, WM_COMMAND, CM_SAVESTATE, 0L);
	else if(response == IDCANCEL)
		return;
	TMDIFrame::WMClose(Msg);
	}

void TMDIEditFrame::OpenFile(RTMessage) {
	char FileName[MAXPATH];

	if(GetApplication()->ExecDialog(
		new TFileDialog(this,
			SD_FILEOPEN,
			strcpy(FileName, "*.*")))
		    == IDOK) {
		GetApplication()->MakeWindow(
			new TMyFileWindow(this, "", FileName, MainMenuName,
		MAINMENUPOS));
		}
	}

void TMDIEditFrame::NewFile(RTMessage) {
	GetApplication()->MakeWindow(new TMyFileWindow(this, "", "",
		MainMenuName, MAINMENUPOS));
	}

static void SaveChild(void *AChild, void *) {
	TMyFileWindow *pWindow = (TMyFileWindow *) AChild;

	if(pWindow->IsFlagSet(WB_MDICHILD))
		SendMessage(pWindow->HWindow, WM_COMMAND, CM_FILESAVE, 0L);
	}

void TMDIEditFrame::CMSaveAll(RTMessage) {
	ForEach(SaveChild, NULL);
	}

void TMDIEditFrame::CMDOSShell(RTMessage) {
	if(WinExec("COMMAND.COM", SW_SHOWNORMAL) <= 32)
		MessageBox(HWindow, "DOS Shell could not be created.",
			"Error:", MB_OK);
	}

void TMDIEditFrame::CMExit(RTMessage Msg) {
		TMDIEditFrame::WMClose(Msg);
	}

void TMDIEditFrame::CMShowClipboard(RTMessage) {
	if(WinExec("CLIPBRD.EXE", SW_SHOWNORMAL) <= 32)
		MessageBox(HWindow,
	    "Cannot find CLIPBRD.EXE to open the Windows Clipboard.",
			"Error:", MB_OK);
	}

BOOL TMDIEditFrame::CloseChildren(void) {
	int ReturnValue = TMDIFrame::CloseChildren();
	if( (ReturnValue) && (!GetLastChild()) ) {
		MDISetMenu(0,DEFAULTWINDOWMENUPOS);	// Set the menu to the default.
		}
	return ReturnValue;
	}

void TMDIEditFrame::SaveState(RTMessage) {
	ofpstream os(DskFile);

	PutChildren(os);

	os.close();
	if(os.bad())	{
		unlink(DskFile);
		MessageBox(HWindow, "Unable to write desktop file.",
			"Disk error",
			MB_OK | MB_ICONEXCLAMATION);
		}
	}

static void _FAR DoCreateChild(Pvoid P, Pvoid) {
	PTWindowsObject p = (PTWindowsObject) P;
	if(p->IsFlagSet(WB_AUTOCREATE))
		p->GetApplication()->MakeWindow(p);
	}

void TMDIEditFrame::RestoreState(RTMessage) {
	LPSTR ErrorMsg = NULL;

	ifpstream is(DskFile);
	if(is.bad())
		ErrorMsg = _fstrdup("Unable to open desktop file.");
	else 	{
		if ( CloseChildren() ) {
			GetChildren(is);

			is.close();
			if(is.bad())
				ErrorMsg = _fstrdup("Error reading desktop file.");
			else if(GetApplication()->LowMemory()) {
				CloseChildren();
				ErrorMsg = _fstrdup("Not enough memory to open file.");
				}
			else 		{
				ForEach(DoCreateChild, NULL);
				MDISetMenu(Attr.Menu,WindowMenuPosition);
				}
			}
		}
	if(ErrorMsg)
		MessageBox(HWindow, ErrorMsg, "Disk error",
			MB_OK | MB_ICONEXCLAMATION);
	}

void TMDIEditFrame::CMAbout(RTMessage) {
	GetApplication()->ExecDialog(new TDialog(this, "About"));
	}

BOOL TMDIEditFrame::AssignMenu(LPSTR MenuName) {
	BOOL ReturnVal = TRUE;
	HMENU NewHMenu;
	HMENU OldHMenu;
	HMENU PopupSubMenu;
	LPSTR TempMenuName = NULL;  // handle case where (MenuName == Attr.Menu)

	if ( HIWORD(Attr.Menu) )
		TempMenuName = Attr.Menu;

	if ( WindowMenuPosition == DEFAULTWINDOWMENUPOS ) {
		// Use default menu
		Attr.Menu = _fstrdup(DefaultMenuName);
		WindowMenuPosition = INITMENUPOS;
	}
	else if (HIWORD(MenuName))   // Not NULL and not an int in disguise
		Attr.Menu = _fstrdup(MenuName);
	else
		Attr.Menu = MenuName;

	if (TempMenuName)
		farfree(TempMenuName);

	if (HWindow)
	{
		NewHMenu = LoadMenu(GetModule()->hInstance, Attr.Menu);
		PopupSubMenu = GetSubMenu(NewHMenu, WindowMenuPosition);
		// SendMessage returns with handle of frame window menu
		// that was replaced.
		OldHMenu = (HMENU)
			SendMessage(ClientWnd->HWindow, WM_MDISETMENU, 0,
				MAKELONG(NewHMenu, PopupSubMenu));
		ReturnVal = (BOOL) OldHMenu;
		DrawMenuBar(HWindow);
		if ( OldHMenu )
			DestroyMenu(OldHMenu);
	}
	return ReturnVal;
	}


void TMDIEditFrame::MDISetMenu(LPSTR MenuName, int WindowMenuPos) {
	WindowMenuPosition = WindowMenuPos;
	AssignMenu(MenuName);
	}

