// editfram.h

#ifndef __EDITFRAM_H
#define __EDITFRAM_H

#ifndef __OWL_H
#include <owl.h>
#endif

#ifndef __MDI_H
#include <mdi.h>
#endif

#ifndef __MENUS_H
#include "menus.h"
#endif

const int DEFAULTWINDOWMENUPOS = -1;

// The MDI application's frame window is also its main window.

_CLASSDEF(TMDIEditFrame)

class _EXPORT TMDIEditFrame : public TMDIFrame {
protected:
	int WindowMenuPosition;

public:
	TMDIEditFrame(LPSTR ATitle, LPSTR AMenu, PTModule AModule = NULL);
	virtual void SetupWindow(void);
	virtual void WMClose(RTMessage Msg)
		= [WM_FIRST + WM_CLOSE];

	virtual void GetWindowClass(WNDCLASS _FAR & AWndClass) {
		TMDIFrame::GetWindowClass(AWndClass);
		AWndClass.hIcon	= LoadIcon(GetApplication()->hInstance,
			"MDIEdit");
		}

	virtual void OpenFile(RTMessage Msg) = [CM_FIRST+CM_MDIFILEOPEN];
	virtual void NewFile(RTMessage Msg) = [CM_FIRST+CM_MDIFILENEW];
	virtual void CMSaveAll(RTMessage Msg) = [CM_FIRST+CM_FILESAVEALL];
	virtual void CMDOSShell(RTMessage Msg) = [CM_FIRST+CM_DOSSHELL];
	virtual void CMExit(RTMessage Msg) = [CM_FIRST+CM_EXIT];
	virtual void CMShowClipboard(RTMessage Msg)
	= [CM_FIRST+CM_SHOWCLIPBOARD];
	virtual void SaveState(RTMessage Msg) = [CM_FIRST+CM_SAVESTATE];
	virtual void RestoreState(RTMessage Msg) = [CM_FIRST+CM_RESTORESTATE];
	virtual BOOL CloseChildren(void);
	virtual void CMAbout(RTMessage Msg) = [CM_FIRST+CM_ABOUT];

	virtual BOOL AssignMenu(LPSTR MenuName);
	// Set second argument to DEFAULTWINDOWMENUPOS to use default menu.
	virtual void MDISetMenu(LPSTR MenuName,
		int WindowMenuPosition = DEFAULTWINDOWMENUPOS);
	};


#endif // ifdef __EDITFRAM_H
