// mdiedit.cpp

#include <owl.h>
#include <bwcc.h>
#include "menus.h"
#include "editfram.h"
#include <stdlib.h>

class TMDIEditApp : public TApplication {
public:
	TMDIEditApp(LPSTR name, HANDLE MyHInstance,
		HANDLE MyHPrevInstance,	LPSTR MyCmdLine, int MyNCmdShow)
		: TApplication(name, MyHInstance, MyHPrevInstance,
			MyCmdLine, MyNCmdShow) {}
protected:
	virtual void InitMainWindow(void);
	virtual void InitApplication(void);
	virtual void InitInstance(void);
	};

void TMDIEditApp::InitMainWindow(void) {
	MainWindow = new TMDIEditFrame("MDI Editor", NULL);
	}

void TMDIEditApp::InitApplication(void) {
	if(hPrevInstance) {
		MessageBox(0, "MDIEdit is already running.",
			"MDI Edit",
			MB_ICONSTOP | MB_OK);
		exit(1);
		}
	BWCCGetVersion();    // Make sure BWCC gets initialized.
	TApplication::InitApplication();
	}

void TMDIEditApp::InitInstance(void) {
	TApplication::InitInstance();
	if(Status == 0) {
		HAccTable = LoadAccelerators(hInstance,
			"FileCommands");
		if(HAccTable == 0)
			Status = EM_INVALIDWINDOW;
		}
	}

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
		   LPSTR lpCmd, int nCmdShow)
{
	TMDIEditApp MDIEditApp("MDIEditApp", hInstance, hPrevInstance,
		lpCmd, nCmdShow);
	MDIEditApp.Run();
	return (MDIEditApp.Status);
	}
