// mfilewnd.cpp

#include <owl.h>
#include <inputdia.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mfilewnd.h"
#include "editfram.h"

void TMyFileWindow::GetWindowClass(WNDCLASS &AWndClass) {
	TFileWindow::GetWindowClass(AWndClass);
	AWndClass.hIcon	= LoadIcon(GetApplication()->hInstance,
		"MDIWin");
	}

static int max(int a, int b) {
	if(a > b)
		return a;
	else
		return b;
	}

static int min(int a, int b) {
	if(a < b)
		return a;
	else
		return b;
	}

void TMyFileWindow::CMGotoLine(RTMessage) {
	char InputText[6];
	static int LineNum = 0;

	sprintf(InputText, "%d", LineNum);
	if(GetApplication()->ExecDialog(new TInputDialog(this,
		"Go to Line Number",
		"&Enter New Line Number:",
		    InputText,
		sizeof (InputText)))
		== IDOK) {
		int Start, End;
		int CurrentLine;
		int NewSelection;

		LineNum = atoi(InputText);
		Editor->GetSelection(Start, End);
		CurrentLine = Editor->GetLineFromPos(End);
		LineNum = max(0, LineNum);
		LineNum = min(LineNum, Editor->GetNumLines());
		Editor->Scroll(0, LineNum - CurrentLine);
		NewSelection = Editor->GetLineIndex(LineNum);
		Editor->SetSelection(NewSelection, NewSelection);
		}
	}

void TMyFileWindow::WMMDIActivate(RTMessage Msg) {
	TMDIEditFrame *Parent = (TMDIEditFrame *) (this->Parent);

	if(Msg.WParam == TRUE)
		Parent->MDISetMenu(MenuName, WindowMenuPosition);
	else
		// If window is deactivated, set the menu to the default.
		Parent->MDISetMenu(0,DEFAULTWINDOWMENUPOS);
	TFileWindow::WMMDIActivate(Msg);
	}


void *TMyFileWindow::read(ipstream& is) {
	TFileWindow::read(is);

	BOOL NameIsNumeric;
	is >> NameIsNumeric;
	if ( NameIsNumeric )
		is >> (long)(MenuName);
	else
		MenuName = is.freadString();
	is >> WindowMenuPosition;

	return this;
	}

void TMyFileWindow::write(opstream& os) {
	if(FileName == NULL)
		FileName = _fstrdup("");
	TFileWindow::write(os);

	BOOL NameIsNumeric = (HIWORD(MenuName) == NULL);
	os << NameIsNumeric;
	if ( NameIsNumeric )
		os << (long)(MenuName);
	else
		os.fwriteString(MenuName);
	os << WindowMenuPosition;
	}

TStreamable *TMyFileWindow::build(void) {
	return new TMyFileWindow(streamableInit);
	}

TStreamableClass RegMyFileWindow("TMyFileWindow", TMyFileWindow::build,
	__DELTA(TMyFileWindow));
