// genapp.cpp
#include "genapp.h"
#include <string.h>
#include <strStrea.h>
#include <process.h>
TEditWindow *TGenApp::clipWindow;

TGenApp::TGenApp() :
    TProgInit( &TGenApp::initStatusLine, &TGenApp::initMenuBar, 
    &TGenApp::initDeskTop)
    {
    TCommandSet ts;
    ts.enableCmd( cmSave );
    ts.enableCmd( cmSaveAs );
    ts.enableCmd( cmCut );
    ts.enableCmd( cmCopy );
    ts.enableCmd( cmPaste );
    ts.enableCmd( cmClear );
    ts.enableCmd( cmUndo );
    ts.enableCmd( cmFind );
    ts.enableCmd( cmReplace );
    ts.enableCmd( cmSearchAgain );
    disableCommands( ts );
    clipWindow = NULL;
    }

void TGenApp::handleEvent(TEvent& Event)
    {
    TApplication::handleEvent(Event);
    switch(Event.what)
        {
        case evCommand:
            switch(Event.message.command)
                {
                case cmChangeDir:
                    changeDir();
                    break;
                case cmDosShell:
                    dosShell();
                    break;
                case cmShowClip:
                    showClip();
                    break;
                case cmTile:
                    tile();
                    break;
                case cmCascade:
                    cascade();
                    break;
                default:
                    return;
                }
        default:
            return;
        }
    clearEvent(Event);
    }

void TGenApp::initClipWindow()
    {
    getClipWindow();
    if (clipWindow)
      deskTop->insert(clipWindow);
    }

void TGenApp::getClipWindow()
    {
    }

void TGenApp::outOfMemory()
    {
    messageBox("Not enough memory for this operation", mfError & mfOKButton);
    }

PathStr TGenApp::fileOpenDialog(PathStr FileMask)
    {
    static char FileName[129];

    strcpy(FileName, FileMask);

    if (execDialog(new TFileDialog("*.*", "OpenFile",
        "Name", fdOpenButton, 100), FileName) != cmCancel)
        return FileName;
    else
        return NULL;
    }

void TGenApp::changeDir()
    {
    execDialog(new TChDirDialog(cdNormal, 0), NULL);
    }

void TGenApp::dosShell()
    {
    TEventQueue::suspend();
    TMouse::suspend();
    TSystemError::suspend();
    TScreen::suspend();
    cout << dosShellMessage();
    system("");
    TScreen::resume();
    TSystemError::resume();
    TMouse::resume();
    TEventQueue::resume();
    redraw();
    }

char *TGenApp::dosShellMessage()
    {
    return "Type Exit to return to program";
    }

void TGenApp::showClip()
    {
    if (clipWindow)
        {
        clipWindow->select();
        clipWindow->show();
        }
    }

void TGenApp::tile()
    {
    deskTop->tile(deskTop->getExtent());
    }

void TGenApp::cascade()
    {
    deskTop->cascade(deskTop->getExtent());
    }

TSubMenu &TGenApp::fileMenu()
    {
    return *new TSubMenu("~F~ile", hcFileMenu) +
        *new TMenuItem("~O~pen...", cmOpenFile, kbF3, hcFileMenu+1,"F3") +
        *new TMenuItem("~N~ew", cmNewFile, kbNoKey, hcFileMenu+2) +
        *new TMenuItem("~S~ave", cmSave, kbF2, hcFileMenu+3, "F2") +
        *new TMenuItem("S~a~ve as...", cmSaveAs, kbNoKey, hcFileMenu+4)+
        newLine() +
        *new TMenuItem("~C~hange dir...", cmChangeDir, kbNoKey,hcFileMenu+5) +
        *new TMenuItem("~D~OS shell", cmDosShell, kbNoKey, hcFileMenu+6)+
        *new TMenuItem("~Q~uit", cmQuit, kbAltX, hcFileMenu+7, "Alt-X");
    }

TSubMenu &TGenApp::editMenu()
    {
    return *new TSubMenu("~E~dit", hcEditMenu) +
        *new TMenuItem("~U~ndo", cmUndo, kbNoKey, hcEditMenu+1,"Alt-Bsp") +
        newLine() +
        *new TMenuItem("Cu~t~", cmCut, kbShiftDel,hcEditMenu+2,"Shift-Del") +
        *new TMenuItem("~C~opy", cmCopy, kbCtrlIns, hcEditMenu+3,"Ctrl-Ins") +
        *new TMenuItem("~P~aste", cmPaste, kbShiftIns, hcEditMenu+4,"Shift-Ins") +
        *new TMenuItem("~S~how clipboard", cmShowClip, hcEditMenu+5)+newLine() +
        *new TMenuItem("C~l~ear", cmClear, kbCtrlDel, hcEditMenu+6,"Ctrl-Del");
    }

TSubMenu &TGenApp::searchMenu()
    {
    return *new TSubMenu("~S~earch", hcSearchMenu) +
        *new TMenuItem("~F~ind...", cmFind, hcSearchMenu+1) +
        *new TMenuItem("~R~eplace...", cmReplace, hcSearchMenu+2) +
        *new TMenuItem("~S~earch again", cmSearchAgain, hcSearchMenu+3);
    }

TSubMenu &TGenApp::windowsMenu()
    {
    return *new TSubMenu("~W~indows", hcWindowsMenu) +
        *new TMenuItem("~S~ize/move", cmResize, kbCtrlF5, hcWindowsMenu+1,"Ctrl-F5") +
        *new TMenuItem("~Z~oom", cmZoom, kbF5, hcWindowsMenu+2, "F5") +
        *new TMenuItem("~T~ile", cmTile, hcWindowsMenu+3) +
        *new TMenuItem("~C~ascade", cmCascade, hcWindowsMenu+4) +
        *new TMenuItem("~N~ext", cmNext, kbF6, hcWindowsMenu+5, "F6") +
        *new TMenuItem("~P~revious", cmPrev, kbShiftF6, hcWindowsMenu+6,"Shift-F6") +
        *new TMenuItem("C~l~ose", cmClose, kbAltF3, hcWindowsMenu+7,"Alt-F3");
    }

TStatusItem* TGenApp::genStatusLine()
    {
    return new TStatusItem("~Alt-X~ Exit", kbAltX, cmQuit,
        new TStatusItem("~F2~ Save", kbF2, cmSave,
        new TStatusItem("~F3~ Open", kbF3, cmOpenFile,
        new TStatusItem("~Alt-F3~ Close", kbAltF3, cmClose,
        new TStatusItem("~F5~ Zoom", kbF5, cmZoom,
        new TStatusItem("~F6~ Next", kbF6, cmNext,
        new TStatusItem("~F10~ Menu", kbF10, cmMenu
// remove these compilation controls when the bug in TV is fixed
#define TVEDITBUGFIXED
#if !defined(TVEDITBUGFIXED)
,
     new TStatusItem(NULL, kbCtrlF5, cmResize)
#endif
        )))))));
    }

typedef char *_charPtr;
typedef TPoint *PPoint;

ushort TGenApp::genEditDialog( int dialog, ... )
    {
    va_list arg;

    char buf[80];
    ostrstream os( buf, sizeof( buf ) );
    switch( dialog )
        {
        case edOutOfMemory:
            return messageBox( "Not enough memory for this operation",
                mfError | mfOKButton );

        case edReadError:
            {
            va_start( arg, dialog );
            os << "Error reading file " << va_arg( arg, _charPtr ) << "." << ends;
            va_end( arg );
            return messageBox( buf, mfError | mfOKButton );
            }

        case edWriteError:
            {
            va_start( arg, dialog );
            os << "Error writing file " << va_arg( arg,_charPtr ) << "." << ends;
            va_end( arg );
            return messageBox( buf, mfError | mfOKButton );
            }

        case edCreateError:
            {
            va_start( arg, dialog );
            os << "Error creating file " << va_arg( arg, _charPtr ) << "." << ends;
            va_end( arg );
            return messageBox( buf, mfError | mfOKButton );
            }

        case edSaveModify:
            {
            va_start( arg, dialog );
            os << va_arg( arg, _charPtr ) << " has been modified. Save?" << ends;
            va_end( arg );
            return messageBox( buf, mfInformation | mfYesNoCancel );
            }

        case edSaveUntitled:
            return messageBox( "Save untitled file?", mfInformation | mfYesNoCancel );

        case edSaveAs:
            {
            va_start( arg, dialog );
            return execDialog( 
                new TFileDialog( "*.*", "Save file as", "~N~ame", fdOKButton, 101 ), 
                va_arg( arg, _charPtr ));
            va_end( arg );
            }

        case edFind:
            {
            va_start( arg, dialog );
            return execDialog( createFindDialog(), va_arg( arg, _charPtr ) );
            va_end( arg );
            }

        case edSearchFailed:
            return messageBox( "Search string not found.", mfError | mfOKButton );

        case edReplace:
            {
            va_start( arg, dialog );
            return execDialog( createReplaceDialog(), va_arg( arg, _charPtr ) );
            va_end( arg );
            }

        case edReplacePrompt:
            //  Avoid placing the dialog on the same line as the cursor
            TRect r( 0, 1, 40, 8 );
            r.move( (TProgram::deskTop->size.x-r.b.x)/2, 0 );
            TPoint t = TProgram::deskTop->makeGlobal( r.b );
            t.y++;
            va_start( arg, dialog );
            TPoint *pt = va_arg( arg, PPoint );
            if( pt->y <= t.y )
            r.move( 0, TProgram::deskTop->size.y - r.b.y - 2 );
            va_end( arg );
            return messageBoxRect( r, "Replace this occurence?",
                    mfYesNoCancel | mfInformation );
        }
    }

int execDialog(TDialog *P, void *Data)
    {
    int Result;
    Result = cmCancel;

    if(TProgram::application->validView(P))
        {
        if (Data)
            P->setData(Data);
        Result = TProgram::deskTop->execView(P);
        if ((Result != cmCancel) && (Data))
            P->getData(Data);
        }
    return Result;
    }


TDialog *TGenApp::createFindDialog()
    {
    TDialog *d = new TDialog(TRect(0, 0, 38, 12), "Find");
    TView *control = new TInputLine(TRect(3, 3, 32, 4), 80);

    d->options = d->options | ofCentered;
    d->insert(control);

    d->insert(new TLabel(TRect(2, 2, 15, 3), "Text to find", control));
    d->insert(new THistory(TRect(32, 3, 35, 4), (TInputLine *)control, 10));

    d->insert(new TCheckBoxes(TRect( 3, 5, 35, 7),
        new TSItem("Case sensitive",
        new TSItem("Whole words only",
        NULL))));

    d->insert(new TButton(TRect(14, 9, 24, 11), "OK", cmOk, bfDefault));
    d->insert(new TButton(TRect(14+12, 9, 24+12, 11), "Cancel", cmCancel, bfNormal));

    d->selectNext(Boolean(0));
    return d;
    }

TDialog *TGenApp::createReplaceDialog()
    {
    TDialog *d = new TDialog(TRect(0, 0, 40, 16), "Replace");
    TView *control = new TInputLine(TRect(3, 3, 34, 4), 80);

    d->options = d->options | ofCentered;
    d->insert(control);
    d->insert(new TLabel(TRect(2, 2, 15, 3), "Text to find", control));
    d->insert(new THistory(TRect(34, 3, 37, 4), (TInputLine *)control, 10));

    control = new TInputLine(TRect(3, 6, 34, 7), 80);
    d->insert(control);
    d->insert(new TLabel(TRect(2, 5, 12, 6), "New text", control));
    d->insert(new THistory(TRect(34, 6, 37, 7), (TInputLine *) control,11));

    d->insert(new TCheckBoxes(TRect(3, 8, 37, 12),
        new TSItem("Case sensitive",
        new TSItem("Whole words only",
        new TSItem("Prompt on replace",
        new TSItem("Replace all", NULL))))));

    d->insert(new TButton(TRect(17, 13, 27, 15), "OK", cmOk, bfDefault));
    d->insert(new TButton(TRect(28, 13, 38, 15), "Cancel", cmCancel, bfNormal));
    d->selectNext(Boolean(0));
    return d;
    }

