//*********************************************************
//* 
//* wndproc.c: the main windows processing function
//*
//*********************************************************

#define	NOCOMM
#define	_WINDOWS

#include	<windows.h>
#include <stdio.h>
#include	"rodsapp.h"
#include "dlls.h"

LONG FAR PASCAL MainWndProc(HWND hWnd, unsigned message, WORD wParam,
									LONG lParam)
{
	/* local variables */
	char	tmpBuffer[40];

	static HANDLE	hInstance;
	static FARPROC	lpProcAbout;

	switch(message) {

		case WM_CREATE:

			hInstance= GetWindowWord(hWnd, GWW_HINSTANCE);
			return(0);

		case WM_COMMAND:
		
			switch(wParam) {

				case IDM_STEPONE:

					/* initialize global variables */
					variableA= 10;
					variableB= 20;
					variableC= 100;

					sprintf(tmpBuffer, "BEFORE DLL: varA= %d varB= %d varC= %d",
						variableA, variableB, variableC);
					MessageBox(hWnd, tmpBuffer, "Testing!", MB_OK);

					/* go to the DLL */
					StepOne(hWnd);

					sprintf(tmpBuffer, "AFTER DLL: varA= %d varB= %d varC= %d",
						variableA, variableB, variableC);
					MessageBox(hWnd, tmpBuffer, "Testing!", MB_OK);

					break;

				case IDM_ABOUT:

					lpProcAbout= MakeProcInstance(About, hInstance);

					if((DialogBox(hInstance,
						MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, lpProcAbout)) == -1) {

						MessageBeep(0);
						MessageBox(hWnd, "Could not create dialog box!", "WARNING", MB_OK);

					}

					/* free dialog instance */
					FreeProcInstance(lpProcAbout);

					break;

				default:
					return(DefWindowProc(hWnd, message, wParam, lParam));

			}

			return(0);

		case WM_DESTROY:

			PostQuitMessage(0);
			return(0);

		default:
			return(DefWindowProc(hWnd, message, wParam, lParam));

	}

	return(0L);

} /* MainWndProc */
