// ***************************************************************************
//    File Name: multapp.c
//
//    Source file for MULTAPP, application that demonstrates how to use
//    the MULTINST DLL sample.      
//    Description of sample:
//
//    Application that uses the MULTINST multi instance DLL sample.  
//       Stores the string in the edit control in the DLL
//       Fills the DLL's local heap.   
//
//    Description of functions:
//        WinMain() - calls initialization function, processes message loop
//        InitApplication() - initializes window data and registers window
//        InitInstance() - saves instance handle and creates main window
//        MainWndProc() - processes messages
//        About() - processes messages for "About" dialog box
//
//    Development Team:   Brian Scott
//
//    Written by Microsoft Product Support Services, Windows Developer Support
// COPYRIGHT:
//
//   (C) Copyright Microsoft Corp. 1993.  All rights reserved.
//
//   You have a royalty-free right to use, modify, reproduce and
//   distribute the Sample Files (and/or any modified version) in
//   any way you find useful, provided that you agree that
//   Microsoft has no warranty obligations or liability for any
//   Sample Application Files which are modified.
//
// ***************************************************************************
#include "windows.h"
#include "MULTAPP.h"

#include "MULTINST.h"
HANDLE hInst;
HWND hwnd;            /* handle to main window */

/****************************************************************************

    FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)

    PURPOSE: calls initialization function, processes message loop

****************************************************************************/

int PASCAL WinMain (hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;
HANDLE hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
{
   MSG msg;

   if (!hPrevInstance)
      if (!InitApplication(hInstance))
         return (FALSE);

   if (!InitInstance(hInstance, nCmdShow))
      return (FALSE);

   while (GetMessage(&msg, NULL, NULL, NULL))
   {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }

   return (msg.wParam);
}


/****************************************************************************

    FUNCTION: InitApplication(HANDLE)

    PURPOSE: Initializes window data and registers window class

****************************************************************************/

BOOL InitApplication (hInstance)
HANDLE hInstance;
{
   WNDCLASS wc;

   wc.style = NULL;
   wc.lpfnWndProc = MainWndProc;
   wc.cbClsExtra = 0;
   wc.cbWndExtra = 0;
   wc.hInstance = hInstance;
   wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
   wc.hCursor = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = GetStockObject(WHITE_BRUSH);
   wc.lpszMenuName = "MainMenu";
   wc.lpszClassName = "SampleClass";

   return (RegisterClass(&wc));
}


/****************************************************************************

    FUNCTION:  InitInstance(HANDLE, int)

    PURPOSE:  Saves instance handle and creates main window

****************************************************************************/

BOOL InitInstance (hInstance, nCmdShow)
HANDLE hInstance;
int nCmdShow;
{

   TEXTMETRIC tm;
   HDC hDC;
   HWND hEdit;

   hInst = hInstance;

   hDC = GetDC(hwnd);
   GetTextMetrics(hDC, &tm);
   ReleaseDC(hwnd, hDC);

   hwnd = CreateWindow(
          "SampleClass",
          "Multiple Instance DLL sample",
          WS_OVERLAPPEDWINDOW,
          CW_USEDEFAULT,
          CW_USEDEFAULT,
          40 * tm.tmAveCharWidth,
          150,
          NULL,
          NULL,
          hInstance,
          NULL);

   if (!hwnd)
      return (FALSE);


   /* create the edit control */
   hEdit = CreateWindow(
           "Edit",
           "",
           WS_CHILD | WS_VISIBLE | WS_BORDER,
           10,
           10,
           tm.tmAveCharWidth * 15,
           tm.tmHeight * 2,
           hwnd,
           IDC_EDIT,
           hInstance,
           NULL);
   if (!hEdit)
      return (FALSE);

   SetFocus(hEdit);
   ShowWindow(hwnd, nCmdShow);
   UpdateWindow(hwnd);
   return (TRUE);
}


/****************************************************************************

    FUNCTION: MainWndProc(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages

    MESSAGES:

        WM_COMMAND    - application menu (About dialog box)
        WM_DESTROY    - destroy window

    COMMENTS:

        WM_COMMAND processing:

            IDM_ABOUT     - display "About" box
            IDM_FILLHEAP  - fills DLL's local heap
            IDM_STOREDATA - write the string in the edit control to the DLL
            IDM_GETDATA   - gets the string from the DLL and displays it in
                            a Message Box

****************************************************************************/

long FAR PASCAL MainWndProc (hWnd, message, wParam, lParam)
HWND hWnd;
unsigned message;
WORD wParam;
LONG lParam;
{

   FARPROC lpProcAbout;

   switch (message)
      {
   case WM_COMMAND:
      switch (wParam)
         {
      case IDM_FILLHEAP:
      {
         int n;
         char outstring[40];

         n = FillHeap();
         wsprintf(outstring, "%d - 1K Local Blocks allocated", n);
         MessageBox(hwnd, outstring, "Fill Local Heap", MB_OK);
      }
         break;

      case IDM_STOREDATA:
      {
         char szData[DATASIZE];

         GetDlgItemText(hwnd, IDC_EDIT, szData, DATASIZE);

         StoreData(szData);
      }
         break;

      case IDM_GETDATA:
      {
         char szData[DATASIZE];

         GetData(szData);

         MessageBox(hwnd, szData, "Data retrieved from DLL", MB_OK);
      }

         break;

      case IDM_ABOUT:
         lpProcAbout = MakeProcInstance(About, hInst);
         DialogBox(hInst, "AboutBox", hWnd, lpProcAbout);
         FreeProcInstance(lpProcAbout);
         break;
         }
      break;

   case WM_DESTROY:
      UnregisterTask();
      PostQuitMessage(0);
      break;

   default:
      return (DefWindowProc(hWnd, message, wParam, lParam));
      }

   return (NULL);
}


/****************************************************************************

    FUNCTION: About(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages for "About" dialog box

    MESSAGES:

        WM_INITDIALOG - initialize dialog box
        WM_COMMAND    - Input received

****************************************************************************/

BOOL FAR PASCAL About (hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
   switch (message)
      {
   case WM_INITDIALOG:
      return (TRUE);

   case WM_COMMAND:
      if (wParam == IDOK || wParam == IDCANCEL)
      {
         EndDialog(hDlg, TRUE);
         return (TRUE);
      }
      break;
      }
   return (FALSE);
}

/***********************************************************************/


/* END OF FILE */
