#include "statbar.h"
#include "string.h"

static VOID NEAR _fastcall SetCapsLockText(HWND hwnd);
static VOID NEAR _fastcall SetNumLockText(HWND hwnd);
static VOID NEAR _fastcall SetStatbarText(HWND hwnd, int nID,BOOL redrawflg);
static VOID NEAR _fastcall PaintStatbar(HWND hwnd, HDC hdc);


char    szStatBarText[256];
BOOL    bIdleOnly = FALSE;
RECT    StatRecSizeAdv;
int     nMenuID = NOMENU;
BOOL    bWin30 = TRUE;
BOOL	bInKeyDown = FALSE;

HMENU hOptionMenu = NULL;
HMENU hPopupMenu1 = NULL;
HMENU hPopupMenu2 = NULL;
HMENU hPopupMenu3 = NULL;
HMENU hPopupMenu4 = NULL;

// Statbar paint helper structure
typedef struct {
    int         dyBorder;                   /* System Border Width/Height       */
    int         dyBorderx2;                 /* System Border Width/Height * 2   */
    int         dyBorderx3;                 /* System Border Width/Height * 3   */
    int         dyBorderx8;                 /* System Border Width/Height * 8   */
    int         dyBorderx9;                 /* System Border Width/Height * 9   */
    int         dyStatbar;                  /* Status Bar height                */
    int         dxStatus;                   /* Width reserved for Status Info   */
    int         dxStates;                   /* Width reserved for State Info    */
    HFONT       hFontStatbar;               /* Font used in status bar */
    } STATUSPAINT;

STATUSPAINT StatbarPntData;


BOOL StatBar_Register(HINSTANCE hInstance)
{
    WNDCLASS cls;

    cls.hCursor         = LoadCursor(NULL, IDC_ARROW);
    cls.hIcon           = LoadIcon(g_hinst, MAKEINTRESOURCE(IDR_APPICON));
    cls.lpszMenuName    = MAKEINTRESOURCE(IDR_MAINMENU);
    cls.hInstance       = hInstance;
    cls.lpszClassName   = "StatBar";
    cls.hbrBackground   = (HBRUSH)(COLOR_WINDOW+1);
    cls.lpfnWndProc	= (WNDPROC)StatBar_WndProc;
    cls.style           = 0L;
    cls.cbWndExtra      = sizeof(HWND);
    cls.cbClsExtra      = 0;

    return RegisterClass(&cls);
}

LRESULT CALLBACK StatBar_WndProc(HWND hwnd, WORD msg, WPARAM wParam, LPARAM lParam)
{
    switch (msg)
    {
        HANDLE_MSG(hwnd, WM_CREATE, StatBar_OnCreate);
        HANDLE_MSG(hwnd, WM_SIZE, StatBar_OnSize);
        HANDLE_MSG(hwnd, WM_GETMINMAXINFO, StatBar_OnGetMinMaxInfo);
        HANDLE_MSG(hwnd, WM_PAINT, StatBar_OnPaint);
        HANDLE_MSG(hwnd, WM_MENUSELECT, StatBar_OnMenuSelect);
        HANDLE_MSG(hwnd, WM_COMMAND, StatBar_OnCommand);
        HANDLE_MSG(hwnd, WM_ENTERIDLE, StatBar_OnEnterIdle);
        HANDLE_MSG(hwnd, WM_DESTROY, Statbar_OnDestroy);
        HANDLE_MSG(hwnd, WM_KEYUP, Statbar_OnKeyUp);
        HANDLE_MSG(hwnd, WM_KEYDOWN, Statbar_OnKeyDown);
        HANDLE_MSG(hwnd, WM_SETFOCUS, Statbar_OnSetFocus);
    default:
        return DefWindowProc(hwnd, msg, wParam, lParam);
    }
}

VOID Statbar_OnSetFocus(HWND hwnd, HWND hwndOldFocus)
{
    SetCapsLockText(hwnd);
    SetNumLockText(hwnd);
}

VOID Statbar_OnKeyUp(HWND hwnd, WORD vk, BOOL fDown, int cRepeat, WORD flags)
{
   bInKeyDown = FALSE;
}

VOID Statbar_OnKeyDown(HWND hwnd, WORD vk, BOOL fDown, int cRepeat, WORD flags)
{
   if ( !bInKeyDown ) {
      if ( vk == VK_CAPITAL )
	 SetCapsLockText(hwnd);
      else if ( vk == VK_NUMLOCK )
	 SetNumLockText(hwnd);

      bInKeyDown = TRUE;
   }
}


VOID Statbar_OnDestroy(HWND hwnd)
{
    DeleteObject(StatbarPntData.hFontStatbar);
    PostQuitMessage(0);
}

VOID StatBar_OnCommand(HWND hwnd, int id, HWND hwndCtl, WORD code)
{
    HMENU       hMenu;

    switch (id)
    {
    case IDM_CLOSE:
	DestroyWindow(hwnd);
        break;

    case IDM_ABOUT:
        AboutDlg_Do(hwnd);
        break;

    case IDM_IDLE:
        hMenu = GetMenu(hwnd);
        if ( bIdleOnly ) {
           bIdleOnly = FALSE;
           CheckMenuItem(hMenu, id, MF_UNCHECKED | MF_BYCOMMAND);
        }
        else {
           bIdleOnly = TRUE;
           CheckMenuItem(hMenu, id, MF_CHECKED | MF_BYCOMMAND);
        }

    break;

    }
}

VOID StatBar_OnPaint(HWND hwnd)
{
    PAINTSTRUCT ps;
    HDC hdc;

    hdc = BeginPaint(hwnd, &ps);

    PaintStatbar(hwnd, hdc);

    EndPaint(hwnd, &ps);
}



BOOL StatBar_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct)
{
    HMENU hMenu;

    hMenu       = GetMenu(hwnd);
    hOptionMenu = GetSubMenu(hMenu,0);
    hPopupMenu1 = GetSubMenu(hMenu,1);
    hPopupMenu2 = GetSubMenu(hMenu,2);
    hPopupMenu3 = GetSubMenu(hMenu,3);
    hPopupMenu4 = GetSubMenu(hMenu,4);

    SetStatbarText(hwnd, nMenuID, FALSE);
    return TRUE;
}

VOID StatBar_OnSize(HWND hwnd, WORD state, int cx, int cy)
{
    RECT rc;

    GetClientRect(hwnd, &rc);
    rc.top = rc.bottom - StatbarPntData.dyStatbar;
    if(rc.top < StatRecSizeAdv.top) {
        /* Window SHRANK, need to invalidate current status rect */
        InvalidateRect(hwnd, (LPRECT)&rc,FALSE);
    } else {
        /* Window GREW, need to invalidate prev status rect */
        InvalidateRect(hwnd, (LPRECT)&StatRecSizeAdv,TRUE);
    }
}

VOID StatBar_OnGetMinMaxInfo(HWND hwnd, MINMAXINFO FAR* lpMinMaxInfo)
{
    GetClientRect(hwnd, &StatRecSizeAdv);
    StatRecSizeAdv.top = StatRecSizeAdv.bottom - StatbarPntData.dyStatbar;

    FORWARD_WM_GETMINMAXINFO(hwnd, lpMinMaxInfo, DefWindowProc);
}

VOID StatBar_OnMenuSelect(HWND hwnd, HMENU hmenu, int item, HMENU hmenuPopup, WORD flags)
{
    int tmpMenuID;

    if (hmenu == NULL && flags == 0xffff)
    {
        // Exiting menu mode.  hMenu && hmenuPopup are NULL.
        nMenuID = NOMENU;
        SetStatbarText(hwnd, nMenuID,TRUE);
        return;
    }
    else if (flags & MF_SYSMENU)
    {
        //
        // System menu is up
        //
        if (!(flags & MF_POPUP))
        {
            //
            // System menu item is selected
            //
            // System menu: item contains SC_* code.
            nMenuID = item;
        }
        else {
            //
            // System menu and no item is selected
            //
            nMenuID = IDM_SYSMENU;
        }
    }
    else
    {
        if ((flags & MF_POPUP)) {
           // Pulling down a popup submenu: hmenuPopup contains popup handle.
           if ( hmenuPopup == hOptionMenu )
              nMenuID = IDM_OPTION;
           else if ( hmenuPopup == hPopupMenu1 )
	      nMenuID = IDM_SUBMENU1;
           else if ( hmenuPopup == hPopupMenu2 )
	      nMenuID = IDM_SUBMENU2;
           else if ( hmenuPopup == hPopupMenu3 )
	      nMenuID = IDM_SUBMENU3;
           else if ( hmenuPopup == hPopupMenu4 )
	      nMenuID = IDM_SUBMENU4;
        }
        else
           nMenuID = item;
    }

    if(!bIdleOnly && tmpMenuID != nMenuID)
        SetStatbarText(hwnd, nMenuID,TRUE);

}

VOID StatBar_OnEnterIdle(HWND hwnd, WORD source, HWND hwndSource)
{
    if( bIdleOnly )
        SetStatbarText(hwnd, nMenuID,TRUE);
}

void InitStatBar()
{
    HDC           hDC;
    TEXTMETRIC    tm;
    char          szHelv[] = "Helv";
    DWORD         wVersion;
    int           Fntheight;                  // Height of the font

    StatbarPntData.dyBorder   = GetSystemMetrics(SM_CYBORDER);
    StatbarPntData.dyBorderx2 = StatbarPntData.dyBorder * 2;
    StatbarPntData.dyBorderx3 = StatbarPntData.dyBorder * 3;
    StatbarPntData.dyBorderx8 = StatbarPntData.dyBorder * 8;
    StatbarPntData.dyBorderx9 = StatbarPntData.dyBorder * 9;

    hDC = GetDC(NULL);
    Fntheight = MulDiv(-10, GetDeviceCaps(hDC, LOGPIXELSY), 72);
    StatbarPntData.hFontStatbar = CreateFont(Fntheight, 0, 0, 0, 400, 0, 0, 0,
          ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
          DEFAULT_QUALITY, VARIABLE_PITCH | FF_SWISS, szHelv);
    SelectObject(hDC, StatbarPntData.hFontStatbar);

    GetTextMetrics(hDC, &tm);
    ReleaseDC(NULL, hDC);

    StatbarPntData.dyStatbar = tm.tmHeight + tm.tmExternalLeading + (7*StatbarPntData.dyBorder);
    StatbarPntData.dxStatus  = tm.tmMaxCharWidth * 21;
    StatbarPntData.dxStates  = tm.tmMaxCharWidth * 3;

    wVersion = GetVersion();
    if ( LOWORD(wVersion) >= 3 && HIWORD(wVersion) < 10 )
       bWin30 = TRUE;
    else
       bWin30 = FALSE;

}

static VOID NEAR _fastcall SetNumLockText(HWND hwnd)
{
    RECT        rc, rcTemp, rcTemp2;
    HDC         hdc;
    int         CapLockLeft;
    int         NumLockLeft;
    char        szString[6];
    static      int nLastState = FALSE;

    /* Num Lock Text */
    if ( GetKeyState(VK_NUMLOCK) & 0x0001) {
       if ( nLastState == TRUE )
          return;
       nLastState = TRUE;
       strcpy(szString,"NUM");
    }
    else {
       if ( nLastState == FALSE )
          return;
       nLastState = FALSE;
       strcpy(szString,"");
    }

    // Is stat bar stuff initialized ? if not then don't draw text
    //
    if ( StatbarPntData.dyStatbar) {
        hdc = GetDC(hwnd);

        GetClientRect(hwnd, &rc);
        rc.top = rc.bottom - StatbarPntData.dyStatbar;
        CapLockLeft = rc.left + StatbarPntData.dyBorderx9 + StatbarPntData.dxStatus;
        NumLockLeft = CapLockLeft + StatbarPntData.dyBorderx9 + StatbarPntData.dxStates;

        SelectObject(hdc, StatbarPntData.hFontStatbar);
        SetTextColor(hdc, GetSysColor(COLOR_BTNTEXT));
        SetBkColor(hdc, GetSysColor(COLOR_BTNFACE));

        rcTemp.top    = rc.top + StatbarPntData.dyBorder*4;
        rcTemp.bottom = rc.bottom - StatbarPntData.dyBorderx3;
        rcTemp.left   = NumLockLeft + StatbarPntData.dyBorderx9;
        rcTemp.right  = rcTemp.left + StatbarPntData.dxStates - StatbarPntData.dyBorder;

        rcTemp2 = rcTemp;

        ExtTextOut(hdc, rcTemp.left + StatbarPntData.dyBorderx2, rcTemp.top,
                   ETO_OPAQUE | ETO_CLIPPED, &rcTemp2, (LPSTR)szString,
                   lstrlen((LPSTR)szString), NULL);

        ReleaseDC(hwnd, hdc);
    }

    return;
}

static VOID NEAR _fastcall SetCapsLockText(HWND hwnd)
{
    RECT        rc, rcTemp, rcTemp2;
    HDC         hdc;
    int         CapLockLeft;
    char        szString[6];
    static      int nLastState = FALSE;

    /* Caps Lock Text */
    if ( GetKeyState(VK_CAPITAL) & 0x0001) {
       if ( nLastState == TRUE )
          return;
       nLastState = TRUE;
       strcpy(szString,"CAPS");
    }
    else {
       if ( nLastState == FALSE )
          return;
       nLastState = FALSE;
       strcpy(szString,"");
    }

    // Is stat bar stuff initialized ? if not then don't draw text
    //
    if ( StatbarPntData.dyStatbar) {
        hdc = GetDC(hwnd);

        GetClientRect(hwnd, &rc);
        rc.top = rc.bottom - StatbarPntData.dyStatbar;
        CapLockLeft = rc.left + StatbarPntData.dyBorderx9 + StatbarPntData.dxStatus;

        SelectObject(hdc, StatbarPntData.hFontStatbar);
        SetTextColor(hdc, GetSysColor(COLOR_BTNTEXT));
        SetBkColor(hdc, GetSysColor(COLOR_BTNFACE));

        rcTemp.top    = rc.top + StatbarPntData.dyBorder*4;
        rcTemp.bottom = rc.bottom - StatbarPntData.dyBorderx3;
        rcTemp.left   = CapLockLeft + StatbarPntData.dyBorderx9;
        rcTemp.right  = rcTemp.left + StatbarPntData.dxStates - StatbarPntData.dyBorder;

        rcTemp2 = rcTemp;

        ExtTextOut(hdc, rcTemp.left + StatbarPntData.dyBorderx2, rcTemp.top,
                   ETO_OPAQUE | ETO_CLIPPED, &rcTemp2, (LPSTR)szString,
                   lstrlen((LPSTR)szString), NULL);

        ReleaseDC(hwnd, hdc);
    }

    return;
}

static VOID NEAR _fastcall SetStatbarText(HWND hwnd, int nID,BOOL redrawflg)
{
    RECT        rc, rcTemp, rcTemp2;
    HDC         hdc;

   static int nLastID = -1;

   if ( nID != nLastID ) {
      if ( LoadString(g_hinst, nID, szStatBarText, 255) == 0)
         _fstrcpy(szStatBarText,"Unknown Item");
   }

   if(redrawflg) {
        /* status Text */

        hdc = GetDC(hwnd);

        GetClientRect(hwnd, &rc);
        rc.top = rc.bottom - StatbarPntData.dyStatbar;

        rcTemp.top    = rc.top + StatbarPntData.dyBorder*4;
        rcTemp.bottom = rc.bottom - StatbarPntData.dyBorderx3;
        rcTemp.left   = StatbarPntData.dyBorderx9;
        rcTemp.right  = rcTemp.left + StatbarPntData.dxStatus - StatbarPntData.dyBorder;

        rcTemp2 = rcTemp;

        SelectObject(hdc, StatbarPntData.hFontStatbar);
        SetTextColor(hdc, GetSysColor(COLOR_BTNTEXT));
        SetBkColor(hdc, GetSysColor(COLOR_BTNFACE));

        ExtTextOut(hdc, rcTemp.left + StatbarPntData.dyBorderx2, rcTemp.top,
                   ETO_OPAQUE | ETO_CLIPPED, &rcTemp2, (LPSTR)szStatBarText,
                   lstrlen((LPSTR)szStatBarText), NULL);
        ReleaseDC(hwnd, hdc);

   }

   return;
}

static VOID NEAR _fastcall PaintStatbar(HWND hwnd, HDC hdc)
{
    RECT        rc, rcTemp, rcTemp2;
    HBRUSH      hBrush;
    int         CapLockLeft;
    int         NumLockLeft;
    char        szString[6];


    GetClientRect(hwnd, &rc);

    rc.top = rc.bottom - StatbarPntData.dyStatbar;
    CapLockLeft = rc.left + StatbarPntData.dyBorderx9 + StatbarPntData.dxStatus;
    NumLockLeft = CapLockLeft + StatbarPntData.dyBorderx9 + StatbarPntData.dxStates;

    /* draw the frame */

        /* Border color */

        hBrush = CreateSolidBrush(GetSysColor(COLOR_BTNFACE));

    /* top and bottom border */

        /* Top */

        rcTemp = rc;
        rcTemp.bottom = rcTemp.top + StatbarPntData.dyBorderx3;
        rcTemp.top += StatbarPntData.dyBorderx2;
        FillRect(hdc, &rcTemp, hBrush);

        /* Bottom */

        rcTemp = rc;
        rcTemp.top = rcTemp.bottom - StatbarPntData.dyBorderx2;
        FillRect(hdc, &rcTemp, hBrush);

    /* left and right border */

        /* Left */

        rcTemp = rc;
        rcTemp.right = StatbarPntData.dyBorderx8;
        rcTemp.top  += StatbarPntData.dyBorderx2;
        FillRect(hdc, &rcTemp, hBrush);

        /* Bar between status and Caps Lock Area */
        rcTemp.left = CapLockLeft;
        rcTemp.right= rcTemp.left + StatbarPntData.dyBorderx8;
        FillRect(hdc, &rcTemp, hBrush);

        /* Bar between Caps Lock and Num Lock Area */
        rcTemp.left = NumLockLeft;
        rcTemp.right= rcTemp.left + StatbarPntData.dyBorderx8;
        FillRect(hdc, &rcTemp, hBrush);

        /* Right */
        rcTemp.left = NumLockLeft + StatbarPntData.dyBorderx9 + StatbarPntData.dxStates;
        rcTemp.right= rc.right;
        FillRect(hdc, &rcTemp, hBrush);

        DeleteObject(hBrush);

    /* Shadow color */

        hBrush = CreateSolidBrush(GetSysColor(COLOR_BTNSHADOW));

    /* Top and left shadow */

        rcTemp = rc;
        rcTemp.top    = rc.top + StatbarPntData.dyBorderx3;
        rcTemp.bottom = rcTemp.top + StatbarPntData.dyBorder;

        /* Top of Status */
        rcTemp.left   = StatbarPntData.dyBorderx8;
        rcTemp.right  = rcTemp.left + StatbarPntData.dxStatus;
        FillRect(hdc, &rcTemp, hBrush);

        /* Top of Caps Lock */
        rcTemp.left   = CapLockLeft + StatbarPntData.dyBorderx8;
        rcTemp.right  = rcTemp.left + StatbarPntData.dxStates;
        FillRect(hdc, &rcTemp, hBrush);

        /* Top of Num Lock  */
        rcTemp.left   = NumLockLeft + StatbarPntData.dyBorderx8;
        rcTemp.right  = rcTemp.left + StatbarPntData.dxStates;
        FillRect(hdc, &rcTemp, hBrush);

        /* Left */
        rcTemp = rc;
        rcTemp.top    += StatbarPntData.dyBorderx3;
        rcTemp.bottom -= StatbarPntData.dyBorderx2;

        /* Left of bar */
        rcTemp.left   = StatbarPntData.dyBorderx8;
        rcTemp.right  = rcTemp.left + StatbarPntData.dyBorder;
        FillRect(hdc, &rcTemp, hBrush);

        /* Left on Bar between status and Caps Lock Area */
        rcTemp.left   = CapLockLeft + StatbarPntData.dyBorderx8;
        rcTemp.right  = rcTemp.left + StatbarPntData.dyBorder;
        FillRect(hdc, &rcTemp, hBrush);

        /* Left on Bar between Caps Lock and Num Lock Area */
        rcTemp.left   = NumLockLeft + StatbarPntData.dyBorderx8;
        rcTemp.right  = rcTemp.left + StatbarPntData.dyBorder;
        FillRect(hdc, &rcTemp, hBrush);

        DeleteObject(hBrush);

    /* Hilight color */
    // Windows 3.1 has COLOR_BTNHIGHLIGHT so use it
    // Windows 3.0 doesn't so use White.

        if ( bWin30 )
           hBrush = GetStockObject(WHITE_BRUSH);
        else
           hBrush = CreateSolidBrush(GetSysColor(COLOR_BTNHIGHLIGHT));

    /* Right, top and bottom hilight */

        rcTemp = rc;
        rcTemp.top    = rc.bottom  - StatbarPntData.dyBorderx3;
        rcTemp.bottom = rcTemp.top + StatbarPntData.dyBorder;

        /* Bottom of status */
        rcTemp.left   = StatbarPntData.dyBorderx8;
        rcTemp.right  = rcTemp.left + StatbarPntData.dxStatus;
        FillRect(hdc, &rcTemp, hBrush);

        /* Bottom of caps lock */
        rcTemp.left   = CapLockLeft + StatbarPntData.dyBorderx8;
        rcTemp.right  = rcTemp.left + StatbarPntData.dxStates;
        FillRect(hdc, &rcTemp, hBrush);

        /* Bottom of num lock */
        rcTemp.left   = NumLockLeft + StatbarPntData.dyBorderx8;
        rcTemp.right  = rcTemp.left + StatbarPntData.dxStates;
        FillRect(hdc, &rcTemp, hBrush);

        rcTemp = rc;
        rcTemp.top    += StatbarPntData.dyBorderx3;
        rcTemp.bottom -= StatbarPntData.dyBorderx2;

        /* Right of status */
        rcTemp.left   = CapLockLeft - StatbarPntData.dyBorder;
        rcTemp.right  = rcTemp.left + StatbarPntData.dyBorder;
        FillRect(hdc, &rcTemp, hBrush);

        /* Right of caps lock */
        rcTemp.left  = NumLockLeft - StatbarPntData.dyBorder;
        rcTemp.right = rcTemp.left + StatbarPntData.dyBorder;
        FillRect(hdc, &rcTemp, hBrush);

        /* Right of num lock */
        rcTemp.left  = NumLockLeft + StatbarPntData.dyBorderx8 + StatbarPntData.dxStates;
        rcTemp.right = rcTemp.left + StatbarPntData.dyBorder;
        FillRect(hdc, &rcTemp, hBrush);

        /* Across the top */
        rcTemp = rc;
        rcTemp.top += StatbarPntData.dyBorder;
        rcTemp.bottom = rcTemp.top + StatbarPntData.dyBorder;
        FillRect(hdc, &rcTemp, hBrush);

        DeleteObject(hBrush);

    /* solid black line across top */

    hBrush = CreateSolidBrush(GetSysColor(COLOR_WINDOWTEXT));
    rcTemp = rc;
    rcTemp.bottom = rcTemp.top;
    rcTemp.bottom += StatbarPntData.dyBorder;
    FillRect(hdc, &rcTemp, hBrush);
    DeleteObject(hBrush);

    /* now the text, with the button face background */

    SelectObject(hdc, StatbarPntData.hFontStatbar);
    SetTextColor(hdc, GetSysColor(COLOR_BTNTEXT));
    SetBkColor(hdc, GetSysColor(COLOR_BTNFACE));

    /* status Text */
    rcTemp.top    = rc.top + (StatbarPntData.dyBorder*4);
    rcTemp.bottom = rc.bottom - StatbarPntData.dyBorderx3;
    rcTemp.left   = StatbarPntData.dyBorderx9;
    rcTemp.right  = rcTemp.left + StatbarPntData.dxStatus - StatbarPntData.dyBorder;

    rcTemp2 = rcTemp;

    ExtTextOut(hdc, rcTemp.left + StatbarPntData.dyBorderx2, rcTemp.top,
               ETO_OPAQUE | ETO_CLIPPED, &rcTemp2, (LPSTR)szStatBarText,
               lstrlen((LPSTR)szStatBarText), NULL);

    /* Caps Lock Text */
    if ( GetKeyState(VK_CAPITAL) & 0x0001)
       strcpy(szString,"CAPS");
    else
       strcpy(szString,"");

    rcTemp.left   = CapLockLeft + StatbarPntData.dyBorderx9;
    rcTemp.right  = rcTemp.left + StatbarPntData.dxStates - StatbarPntData.dyBorder;

    rcTemp2 = rcTemp;

    ExtTextOut(hdc, rcTemp.left + StatbarPntData.dyBorderx2, rcTemp.top,
               ETO_OPAQUE | ETO_CLIPPED, &rcTemp2, (LPSTR)szString,
               lstrlen((LPSTR)szString), NULL);

    /* Num Lock Text */
    if ( GetKeyState(VK_NUMLOCK) & 0x0001)
       strcpy(szString,"NUM");
    else
       strcpy(szString,"");

    rcTemp.left   = NumLockLeft + StatbarPntData.dyBorderx9;
    rcTemp.right  = rcTemp.left + StatbarPntData.dxStates - StatbarPntData.dyBorder;

    rcTemp2 = rcTemp;

    ExtTextOut(hdc, rcTemp.left + StatbarPntData.dyBorderx2, rcTemp.top,
               ETO_OPAQUE | ETO_CLIPPED, &rcTemp2, (LPSTR)szString,
               lstrlen((LPSTR)szString), NULL);

}
