#include <afxwin.h>

////////////////////////////////////////////////////////////
//
// Declare CNumEdit Class
//
class CNumEdit : public CEdit {
public:
	BOOL Create(	DWORD dwStyle, 
			const RECT& rect,
			CWnd* pParent,
			UINT nID ) ;

	afx_msg void OnChar(UINT nChar, UINT nRep, UINT nFlags) ;

	DECLARE_MESSAGE_MAP()
};

////////////////////////////////////////////////////////////
//
// Implement CNumEdit Class
//

BEGIN_MESSAGE_MAP(CNumEdit, CEdit)
	ON_WM_CHAR()
END_MESSAGE_MAP()

//
// Create member function
//
BOOL CNumEdit::Create(DWORD dwStyle, 
		const RECT& rect,
		CWnd* pParent,
		UINT nID )
{
	return CWnd::Create("EDIT", NULL, dwStyle, rect, 
							pParent, nID);
}

//
// OnChar member function
//
void CNumEdit::OnChar(UINT nChar, UINT nRep, UINT nFlags)
{
	if ((nChar >= '0' && nChar <= '9') || nChar == VK_BACK )
		CEdit::OnChar(nChar, nRep, nFlags) ;
	else
		MessageBeep(0) ;
}



////////////////////////////////////////////////////////////
//
// Declare CNumEdit Class
//
class CMainWindow : public CFrameWnd
{ 
public:
	CNumEdit anEdit ;
	CMainWindow() 
		{ Create(NULL, "NumEdit", WS_OVERLAPPEDWINDOW, rectDefault); }

	afx_msg void OnSize( UINT type, int x, int y) ;
	afx_msg int OnCreate(LPCREATESTRUCT cs);
	DECLARE_MESSAGE_MAP()
};

////////////////////////////////////////////////////////////
//
// Implement CMainWindow Class
//

//
// Build Message Map
//
BEGIN_MESSAGE_MAP(CMainWindow, CFrameWnd)
	ON_WM_CREATE()
	ON_WM_SIZE()
END_MESSAGE_MAP()

//
// OnCreate member function
//
int CMainWindow::OnCreate( LPCREATESTRUCT cs)
{
	CRect rect(0,0,0,0) ;
	
	anEdit.Create( WS_BORDER | WS_HSCROLL | WS_VISIBLE | WS_VSCROLL |
					 ES_AUTOHSCROLL | ES_AUTOVSCROLL | ES_MULTILINE | ES_NOHIDESEL |
					 WS_MAXIMIZE, rect, this, 100 ) ;
	anEdit.SetFocus() ;		 
	return 0 ;
}

//
// OnSize member function
//
void CMainWindow::OnSize( UINT type, int x, int y)
{
	anEdit.MoveWindow(-1,-1, x+1, y+1, TRUE) ;
}

////////////////////////////////////////////////////////////
//
// Declare CTheApp Class
//

class CTheApp : public CWinApp
{
public:
	virtual BOOL InitInstance();
};

////////////////////////////////////////////////////////////
//
// Implement CTheApp Class
//

BOOL CTheApp::InitInstance()
{
	m_pMainWnd = new CMainWindow();
	m_pMainWnd->ShowWindow(m_nCmdShow);
	m_pMainWnd->UpdateWindow();
	return TRUE;
}

CTheApp TheApp;
