/*
 * CLIENT.CPP
 * Component Schmoo Chapter 6
 *
 * Implementation of the CSchmooClient class that just makes sure
 * we get a CSchmooDoc on doc creation and that we initialize fully.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */



#include "coschmoo.h"


/*
 * CSchmooClient::CSchmooClient
 * CSchmooClient::~CSchmooClient
 *
 * Constructor Parameters:
 *  hInst           HINSTANCE of the application.
 */

CSchmooClient::CSchmooClient(HINSTANCE hInst)
    : CClient(hInst)
    {
    return;
    }


CSchmooClient::~CSchmooClient(void)
    {
    return;
    }





/*
 * CSchmooClient::CreateCDocument
 *
 * Purpose:
 *  Constructs a new document specific to the application.
 *
 * Parameters:
 *  None
 *
 * Return Value:
 *  LPCDocument     Pointer to the new document object.
 */

LPCDocument CSchmooClient::CreateCDocument(void)
    {
    return (LPCDocument)(new CSchmooDoc(m_hInst));
    }







/*
 * CSchmooClient::NewDocument
 *
 * Purpose:
 *  Small override of the CClient::NewDocument that we have just to
 *  check the initial line selection on new document creation.
 *
 * Parameters:
 *  fVisible        BOOL indicating if the document is to be visible or not.
 *  pAdv            LPCDocumentAdviseSink to set with the new document for
 *                  notifications.  Can be NULL.
 *
 * Return Value:
 *  LPCDocument      Pointer to the new document object.
 */

LPCDocument CSchmooClient::NewDocument(BOOL fVisible, LPCDocumentAdviseSink pAdv)
    {
    LPCDocument pDoc;

    //Perform default NewDocument first
    pDoc=CClient::NewDocument(fVisible, pAdv);

    //We know that m_pFR is actually a CSchmooFrame, so the type is safe.
    ((LPCSchmooFrame)m_pFR)->CheckLineSelection(IDM_LINESOLID);

    return pDoc;
    }
