/*
 * DDATAOBJ.H
 *
 * Definitions, classes, and prototypes for a DLL that provides Data objects.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _DDATAOBJ_H_
#define _DDATAOBJ_H_


#include "dataobj.h"


void FAR PASCAL ObjectDestroyed(void);


//DDATAOBJ.CPP
//This class factory object creates Data Objects.

class __far CDataObjectClassFactory : public IClassFactory
    {
    protected:
        ULONG           m_cRef;         //Reference count on class object
        UINT            m_iSize;        //Data size for this class.

    public:
        CDataObjectClassFactory(UINT);
        ~CDataObjectClassFactory(void);

        //IUnknown members
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IClassFactory members
        STDMETHODIMP         CreateInstance(LPUNKNOWN, REFIID, LPVOID FAR *);
        STDMETHODIMP         LockServer(BOOL);
    };

typedef CDataObjectClassFactory FAR * LPCDataObjectClassFactory;


#endif //_DDATAOBJ_H_
