/*
 * EDATAOBJ.H
 *
 * Definitions, classes, and prototypes for an application that
 * provides DataObject objects to any other object user.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _EDATAOBJ_H_
#define _EDATAOBJ_H_

#include "dataobj.h"


//EDATAOBJ.CPP
LRESULT FAR PASCAL __export DataObjectWndProc(HWND, UINT, WPARAM, LPARAM);

class __far CAppVars
    {
    friend LRESULT FAR PASCAL __export DataObjectWndProc(HWND, UINT, WPARAM, LPARAM);

    protected:
        HINSTANCE       m_hInst;            //WinMain parameters
        HINSTANCE       m_hInstPrev;
        LPSTR           m_pszCmdLine;
        UINT            m_nCmdShow;

        HWND            m_hWnd;             //Main window handle
        BOOL            m_fInitialized;     //Did CoInitialize work?

        //We have multiple classes, one for each data size.
        DWORD           m_rgdwRegCO[DOSIZE_CSIZES];
        LPCLASSFACTORY  m_rgpIClassFactory[DOSIZE_CSIZES];

    public:
        CAppVars(HINSTANCE, HINSTANCE, LPSTR, UINT);
        ~CAppVars(void);
        BOOL FInit(void);
    };


typedef CAppVars FAR * LPAPPVARS;

#define CBWNDEXTRA              sizeof(LONG)
#define DATAOBJWL_STRUCTURE     0


void FAR PASCAL ObjectDestroyed(void);



//This class factory object creates DataObject objects.

class __far CDataObjectClassFactory : public IClassFactory
    {
    protected:
        ULONG           m_cRef;         //Reference count on class object
        UINT            m_iSize;        //Data size for this class.

    public:
        CDataObjectClassFactory(UINT);
        ~CDataObjectClassFactory(void);

        //IUnknown members
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IClassFactory members
        STDMETHODIMP         CreateInstance(LPUNKNOWN, REFIID, LPVOID FAR *);
        STDMETHODIMP         LockServer(BOOL);
    };

typedef CDataObjectClassFactory FAR * LPCDataObjectClassFactory;


#endif //_EDATAOBJ_H_
