MODEL = l
INCLUDE = $(KERNEL)
IWLIBPATH = $(KERNEL)\t$(MODEL)
LIBS = iw_os$(MODEL).lib
MODLIB = mikmod\mikmod.lib
CFLAGS = $(DEBUG) -I$(INCLUDEPATH);$(INCLUDE) -3 -Ox -Os -j7 -m$(MODEL)!
API_OBJS = midiapi.obj wavapi.obj iwapi.obj
MLSCOMP = $(IWPROJ)\tools\mlscomp\mlscomp

.c.obj:
	bcc -c +bcc.cfg { $*.c}

all: bcc.cfg iwapi.lib

bcc.cfg:
	copy &&|
$(CFLAGS)
-n$(DIR)
| bcc.cfg

midiapi.obj: midiapi.c
wavapi.obj: wavapi.c
iwapi.obj: iwapi.c

..\kernel\$(LIBS):
	cd $(KERNEL)
	maker -f makeos.ksh -DMODEL=l -DTARGETDIR=$(IWPROJ)\apps\play\kernel -DCONFIGINCDIR=$(IWPROJ)\apps\play\api
	cd $(IWPROJ)\apps\play\api

$(MODLIB):
	cd mikmod
	maker
	cd ..
	
iwapi.lib: $(API_OBJS) ..\kernel\$(LIBS) $(MODLIB)
        makersp "+%s &\n" &&|
        $(API_OBJS) ..\kernel\$(LIBS) $(MODLIB)
|       > lib.rsp
        if exist iwapi.lib del iwapi.lib
        tlib iwapi.lib /C @lib.rsp,nul
        if exist *.bak del *.bak
