#ifndef _DIGITAL_H
#define _DIGITAL_H


#define MAX_BUFFS	32

#define STAT_UNUSED	0	/* voice unused */
#define STAT_PLAYING	1	/* voice playing sound */
#define STAT_PAUSED	2	/* voice paused or awaiting next dma xfer */
#define STAT_USER_PAUSED 3	/* voice paused by user */
#define STAT_MASK	3
#define STAT_STARTED	4	/* voice has started playback */
#define DMASTAT_WORKING	8	/* dma in progress */
#define DMASTAT_PENDING 16	/* application has requested a new dma transfer
				   but dma channel was busy */
#define STAT_SET_ACCUM  32	/* reset accumulator */
#define STAT_EXTRA_VOICE 64	/* This voice is used to generate interrupts
				   for another voice */

#define BUFSTAT_FILLED	1	/* buffer has data */
#define BUFSTAT_DONE	2	/* when done playing send voice_done callback */
#define BUFSTAT_INT	4	/* generate interrupt at end of this buffer */

struct dig_buffer_s {
	ULONG addr_s;
	ULONG play_size;
	UCHAR status;
	UCHAR dummy;
};

struct dig_voice_status {
	USHORT status; 		/* status of voice */
	UCHAR type;		/* bit fields describing use of voice */
	UCHAR dma_control;
	UCHAR RFAR *pc_buffer;	/* current buffer being dma'd */
	USHORT rate;		/* rate of playback */
	USHORT threshold;	/* minimum buffer size before interrupt */
	ULONG size;		/* size of pc_buffer */
	ULONG position;		/* relative position since first play */
	struct iw_dma_buff RFAR *pc_stbuff;	/* stereo work buffer */
	ULONG addr_s;		/* start address of iwl buffer */
	ULONG addr_e;		/* end address of iwl buffer */
	ULONG addr_m;		/* address at middle of iwl buffer */
	ULONG b_size;		/* size of iwl buffer */
	ULONG max;		/* size of iwl buffer */
	ULONG filled;		/* amount of data in iwl buffer */
	USHORT volume;
	USHORT play_buf;
	USHORT insert_buf;
	ULONG insert_addr;
	ULONG insert_len;
	ULONG st_offset;	/* offset for stereo buffers */
	UCHAR voice_control;
	UCHAR volume_control;
	UCHAR do_update;
	short extra_voice;	/* voice for stereo playback */
	struct dig_buffer_s buffs[MAX_BUFFS];
	int (RFAR *callback)(int, int, UCHAR RFAR * RFAR *, ULONG RFAR *);
};
extern struct dig_voice_status dig_voice_status[32];

#define VS dig_voice_status[voice].

extern void iwl_start_record(int);
extern void RFAR iwl_stop_record(int);
extern void iwl_restart_record(int);
extern void iwl_pause_record(int);
extern void iwl_dig_change_voice(int voice, int ints);
extern void iwl_dig_dma_next_buffer(int voice);
extern void iwl_start_playback(int);
extern void RFAR iwl_stop_playback(int);
extern void iwl_restart_playback(int);
extern int iwl_playback();
extern void iwl_dig_synth_master_vol(void);
extern void iwl_dig_codec_master_vol(short, short, int);
extern void iwl_dig_codec_master_vol(short, short, int);
extern void iwl_dig_codec_get_master_vol(short *, short *);
#endif
