;***************************************************************************
;	NAME: IWASM.INC
;	COPYRIGHT:
;	"Copyright (c) 1994,1995 by e-Tek Labs"
;
;       "This software is furnished under a license and may be used,
;        copied, or disclosed only in accordance with the terms of such
;        license and with the inclusion of the above copyright notice.
;        This software or any other copies thereof may not be provided or
;        otherwise made available to any other person. No title to and
;        ownership of the software is hereby transfered."
;****************************************************************************
; $Log: iwasm.inc $
; Revision 1.1  1995/02/23 11:07:01  unknown
; Initial revision
;***************************************************************************/
CPROC Macro	name		; Macro to establish a C callable procedure.
IFDEF __f__
	public	&name&_
&name&_	proc	near
ELSE
	public	_&name
IF NEARCODE EQ 1
_&name	proc	near
ELSE
_&name	proc	far
ENDIF
ENDIF
	endm

ENDPROC Macro	name
IFDEF __f__
	&name&_	endp
ELSE
	_&name	endp
ENDIF
	endm

EPROC Macro name
IFDEF __f__
	extrn &name&_:near
ELSE
IF NEARCODE EQ 1
	extrn _&name:near
ELSE
	extrn _&name:far
ENDIF
ENDIF
	endm

Eint Macro name
IFDEF __f__
	extrn _&name:word
ELSE
	extrn _&name:word
ENDIF
	endm
Eshort Macro name
IFDEF __f__
	extrn _&name:word
ELSE
	extrn _&name:word
ENDIF
	endm
Elong Macro name
IFDEF __f__
	extrn _&name:dword
ELSE
	extrn _&name:dword
ENDIF
	endm
Echar Macro name
IFDEF __f__
	extrn _&name:byte
ELSE
	extrn _&name:byte
ENDIF
	endm
Eaddr Macro name
IFDEF __f__
	extrn _&name:dword
ELSE
IF NEARDATA
	extrn _&name:word
ELSE
	extrn _&name:dword
ENDIF
ENDIF
	endm

Pint Macro name
IFDEF __f__
	_&name dw ?
	public _&name
ELSE
	_&name dw ?
	public _&name
ENDIF
	endm
Pshort Macro name
IFDEF __f__
	_&name dw ?
	public &name_
ELSE
	_&name dw ?
	public _&name
ENDIF
	endm
Plong Macro name
IFDEF __f__
	_&name dd ?
	public _&name
ELSE
	_&name dd ?
	public _&name
ENDIF
	endm
Pchar Macro name
IFDEF __f__
	_&name db ?
	public _&name
ELSE
	_&name db ?
	public _&name
ENDIF
	endm
Paddr Macro name
IFDEF __f__
	public _&name:dword
ELSE
IF NEARDATA
	public _&name:word
ELSE
	public _&name:dword
ENDIF
ENDIF
	endm

IFDEF __f__
PENTER Macro
	push	ebp
	mov	ebp, esp
	endm
PLEAVE Macro
	mov	esp, ebp
	pop	ebp
	endm
ELSE
PENTER Macro
	push	bp
	mov	bp, sp
	endm
PLEAVE Macro
	mov	sp, bp
	pop	bp
	endm
ENDIF

IFDEF __f__ 
	STOFF EQU 8
	DIST  EQU NEAR
ELSE
IF NEARCODE EQ 1
	STOFF	EQU 4
	DIST	EQU NEAR
ELSE
	STOFF	EQU 6
	DIST	EQU FAR
ENDIF
ENDIF

IW_OK			EQU	0
IW_NO_MORE_VOICES		EQU	-1
IW_BASE_NOT_FOUND		EQU	1
IW_BAD_IRQ			EQU	2
IW_BAD_DMA			EQU	3
IW_OS_LOADED		EQU	4
IW_NOT_LOADED		EQU	5
IW_NO_MEMORY		EQU	6
IW_DMA_BUSY		EQU	7
IW_NO_MORE_HANDLERS	EQU	8
IW_DMA_HUNG		EQU	9
IW_CARD_NOT_FOUND		EQU	10
IW_CARD_BEING_USED		EQU	11
IW_NO_MORE_INTERRUPTS	EQU	12
IW_BAD_TIMER		EQU	13
IW_BAD_PATCH		EQU	14
IW_OLD_PATCH		EQU	15
IW_DOS_ERROR		EQU	16
IW_FILE_NOT_FOUND		EQU	17

; BIT masks
BIT0	equ 01h
BIT1	equ 02h
BIT2	equ 04h
BIT3	equ 08h
BIT4	equ 10h
BIT5	equ 20h
BIT6	equ 40h
BIT7	equ 80h

; bounds for volume enveloping functions 
IW_MIN_OFFSET	equ	5
IW_MAX_OFFSET      equ	251

; bounds for voice allocation
IW_MIN_VOICES	equ	14
IW_MAX_VOICES	equ	32

; DMA control bits
IW_DMA_ENABLE		equ BIT0
IW_DMA_READ		equ BIT1
IW_DMA_WIDTH_16		equ BIT2 ; width of DMA channel 
IW_DMA_RATE_DIV_1		equ BIT3
IW_DMA_RATE_DIV_2		equ BIT4
IW_DMA_IRQ_ENABLE		equ BIT5
IW_DMA_IRQ_PRESENT		equ BIT6
IW_DMA_DATA_16		equ BIT6 ; width of data
IW_DMA_INVERT_MSB		equ BIT7

; SAMPLE control bits
IW_DMA_STEREO		equ 2

; DMA flags
IW_RECORD		equ 0 ; use dma control or sample control
IW_DMA			equ 1

; digital playback flags
IW_TYPE_8BIT		equ BIT0    ; 1 use 8 bit data
				    ; 0 use 16 bit data 
IW_TYPE_PRELOAD		equ BIT1    ; preload data 
IW_TYPE_INVERT_MSB 	equ BIT2    ; invert most significant bit during dma
IW_TYPE_STEREO		equ BIT3    ; 1 for stereo data

; MIDI control register
IW_MIDI_RESET		equ (BIT0 OR BIT1)
IW_IW_MIDI_TD_INT		equ BIT5
IW_IW_MIDI_RD_INT		equ BIT7

; MIDI_STATUS_REGISTER 
IW_MIDI_RD			equ BIT0
IW_MIDI_TD			equ BIT1
IW_MIDI_ERR_FRAMING 	equ BIT4
IW_MIDI_ERR_OVERRUN 	equ BIT5

; patch macros
IW_HEADER_SIZE	           equ 12
IW_ID_SIZE		           equ 10
IW_DESC_SIZE 	           equ 60
IW_RESERVED_SIZE	           equ 40
PATCH_HEADER_IW_RESERVED_SIZE equ 36
LAYER_IW_RESERVED_SIZE	   equ 40
PATCH_DATA_IW_RESERVED_SIZE   equ 36
IW_HEADER_TEXT            equ "GF1PATCH110"
IW_INST_NAME_SIZE		   equ 16
IW_ENVELOPES		   equ 6

; patch modes
IW_PATCH_16		   equ BIT0
IW_PATCH_UNSIGNED		   equ BIT1
IW_PATCH_LOOPEN		   equ BIT2
IW_PATCH_BIDIR		   equ BIT3
IW_PATCH_BACKWARD  	   equ BIT4
IW_PATCH_SUSTAIN   	   equ BIT5
PATCH_ENVEN     	   equ BIT6
IW_PATCH_FAST_REL  	   equ BIT7

; flags for patch loading
IW_PATCH_LOAD_8_BIT 	   equ BIT0

; digital playback callback reasons & return values
IW_DIG_DONE		   equ 0
IW_DIG_MORE_DATA		   equ 1
IW_DIG_BUFFER_DONE            equ 2
IW_DIG_PAUSE                  equ 3

IFDEF MODULE_GF1NOTE
; log table used for vibrato and pitch bend.  log table made public for
; developers use */
LOG_TAB_SIZE  equ 12
Eaddr iw_log_table
ENDIF

; structure definitions
load_os STRUC
	lo_voices dw ?
	lo_forced_base_port dw ?
	lo_forced_iwl_irq db ?
	lo_forced_midi_irq db ?
	lo_forced_channel_in db ?
	lo_forced_channel_out db ?
load_os ENDS

patchheader STRUC
	ph_header		db IW_HEADER_SIZE dup (?)
	ph_gravis_id		db IW_ID_SIZE dup (?)
	ph_description		db IW_DESC_SIZE dup (?)
	ph_instruments		db ?
	ph_voices		db ?
	ph_channels		db ?
	ph_wave_forms		dw ?
	ph_master_volume	dw ?
	ph_data_size		dd ?
	ph_reserved		db PATCH_HEADER_IW_RESERVED_SIZE dup (?)
patchheader ENDS

instrumentdata STRUC
	id_instrument		dw ?
	id_instrument_name	db IW_INST_NAME_SIZE dup (?)
	id_instrument_size	dd ?
	id_layers		db ?
	id_reserved		db IW_RESERVED_SIZE dup (?)
instrumentdata ENDS

layerdata STRUC
	lr_layer_duplicate	db ?
	lr_layer		db ?
	lr_layer_size		dd ?
	lr_samples		db ?
	lr_reserved		db LAYER_IW_RESERVED_SIZE dup (?)
layerdata ENDS

patchdata STRUC
	pd_wave_name	db 7 dup (?)
	pd_fractions	db ?
	pd_wave_size	dd ?
	pd_start_loop	dd ?
	pd_end_loop	dd ?
	pd_sample_rate	dw ?
	pd_low_frequency	dd ?
	pd_high_frequency	dd ?
	pd_root_frequency	dd ?
	pd_tune		dw ?
	pd_balance		db ?
	pd_envelope_rate	db IW_ENVELOPES dup (?)
	pd_envelope_offset	db IW_ENVELOPES dup (?)
	pd_tremolo_sweep	db ?
	pd_tremolo_rate	db ?
	pd_tremolo_depth	db ?
	pd_vibrato_sweep	db ?
	pd_vibrato_rate	db ?
	pd_vibrato_depth	db ?
	pd_modes		db ?
	pd_scale_frequency dw ?
	pd_scale_factor	dw ?
	pd_reserved	db PATCH_DATA_IW_RESERVED_SIZE dup (?)
patchdata ENDS

wave_struct STRUC
	ws_start_loop	dd ?
	ws_end_loop	dd ?
	ws_low_frequency	dd ?
	ws_high_frequency	dd ?
	ws_root_frequency	dd ?
	ws_mem		dd ?
	ws_scale_frequency dw ?
	ws_sample_rate	dw ?
	ws_scale_factor	dw ?
	ws_start_acc_low	dw ?
	ws_start_acc_high	dw ?
	ws_start_low	dw ?
	ws_start_high	dw ?
	ws_end_low		dw ?
	ws_end_high	dw ?
	ws_end_acc_low	dw ?
	ws_end_acc_high	dw ?
	ws_sample_ratio	dw ?
	ws_wave_size	dd ?
	ws_fractions	db ?
	ws_balance		db ?
	ws_envelope_rate	db IW_ENVELOPES dup (?)
	ws_envelope_offset	db IW_ENVELOPES dup (?)
	ws_tremolo_sweep	db ?
	ws_tremolo_rate	db ?
	ws_tremolo_depth	db ?
	ws_vibrato_sweep	db ?
	ws_vibrato_rate	db ?
	ws_vibrato_depth	db ?
	ws_modes		db ?
wave_struct ENDS

patchinfo STRUC
	; patchheader
	pi_header		db IW_HEADER_SIZE dup (?)
	pi_gravis_id		db IW_ID_SIZE dup (?)
	pi_description		db IW_DESC_SIZE dup (?)
	pi_instruments		db ?
	pi_voices		db ?
	pi_channels		db ?
	pi_wave_forms		dw ?
	pi_master_volume	dw ?
	pi_data_size		dd ?
	pi_ph_reserved		db PATCH_HEADER_IW_RESERVED_SIZE dup (?)
	; instrument data 
	pi_instrument		dw ?
	pi_instrument_name	db IW_INST_NAME_SIZE dup (?)
	pi_instrument_size	dd ?
	pi_layers		db ?
	pi_id_reserved		db IW_RESERVED_SIZE dup (?)
patchinfo ENDS

patch STRUC
	pt_nlayers 	dw ?
	pt_layer_waves	dd 4 dup (?) ; far pointers to layers
	pt_layer_nwaves	dw 4 dup (?)
patch ENDS

IFDEF MODULE_IWINIT2
    EPROC iw_delay
    EPROC iw_init_ports
ENDIF
IFDEF MODULE_GF1SEM
    EPROC iw_set_external_semaphore
    EPROC iw_clear_external_semaphore
    EPROC iw_leave
    EPROC iw_enter
ENDIF
IFDEF MODULE_IWINIT
    EPROC iw_load_os
    EPROC iw_unload_os
    EPROC iwu_reset_ultra
    EPROC iwl_getvect
    EPROC iwl_setvect
ENDIF
IFDEF MODULE_IWISR
    EPROC iw_add_handler
ENDIF
IFDEF MODULE_IWISR1
    EPROC iwl_irq1_service
    EPROC iwl_irq2_service
ENDIF
IFDEF MODULE_GF1AINIT
    EPROC iw_asm_init
ENDIF
IFDEF MODULE_GF1DRAM
    EPROC iw_peek
    EPROC iw_poke
    EPROC iw_poke_block
    EPROC iw_good_dram
ENDIF
IFDEF MODULE_GF1UTILS
    EPROC GetUltraCfg
    EPROC iw_atoi
    EPROC iwl_getenv
ENDIF
IFDEF MODULE_GF1MEM
    EPROC iw_malloc
    EPROC iw_free
    EPROC iw_mem_avail
    EPROC iw_mem_largest_avail
ENDIF
IFDEF MODULE_GF1VOICE
    EPROC iw_allocate_voice
    EPROC iw_free_voice
    EPROC iw_adjust_priority
ENDIF
IFDEF MODULE_GF1DMA
    EPROC iw_dram_xfer
    EPROC iw_wait_dma
ENDIF
IFDEF MODULE_GF1ADDR
    EPROC iwu_convert_to_16bit
ENDIF
IFDEF MODULE_GF1DETCT
    EPROC iw_detect_card
ENDIF
IFDEF MODULE_GF1ERROR
    EPROC iw_error_str
ENDIF
IFDEF MODULE_DIGITAL
    EPROC iw_play_digital
    EPROC iw_restart_digital
    EPROC iw_start_digital
    EPROC iw_dig_set_vol
    EPROC iw_dig_set_pan
    extrn _iw_stop_digital:far
ENDIF
IFDEF MODULE_DIGPOS
    EPROC iw_digital_position
ENDIF
IFDEF MODULE_DIGNEXT
    EPROC iw_play_next_buffer
ENDIF
IFDEF MODULE_DIGPAUSE
    EPROC iw_pause_digital
ENDIF
IFDEF MODULE_GF1WAVE
    EPROC iw_update_waveform
ENDIF
IFDEF MODULE_GF1PATCH
    EPROC iw_get_patch_info
    EPROC iw_load_patch
    EPROC iw_unload_patch
ENDIF
IFDEF MODULE_GF1NOTE
    EPROC iw_calc_fc
    EPROC iw_midi_stop_voice
    EPROC iw_midi_wait_voice
    extrn _iw_midi_stop_note:far
    EPROC iw_midi_note_on
    EPROC iw_midi_note_off
    EPROC iw_midi_silence_patch_notes
    EPROC iwl_midi_master_volume
    EPROC iw_midi_pitch_bend
    EPROC iw_midi_change_program
    EPROC iw_midi_set_vibrato
    EPROC iw_midi_change_volume
    EPROC iw_midi_set_balance
    EPROC iw_midi_channel_sustain
    EPROC iw_midi_all_notes_off
ENDIF
IFDEF MODULE_TIMER
    EPROC iw_enable_timer1
    EPROC iw_enable_timer2
    EPROC iw_disable_timer1
    EPROC iw_disable_timer2
ENDIF
IFDEF MODULE_GF1NOTE1
    EPROC iw_midi_get_channel_notes
    EPROC iw_midi_get_channel_volume
    EPROC iw_midi_get_master_volume
    EPROC iw_midi_get_volume
ENDIF
IFDEF MODULE_GF1UART
    EPROC iw_midi_reset
ENDIF
    EPROC os_eoi
IFDEF MODULE_OS
    EPROC os_push_disable
    EPROC os_popf
ENDIF
