/***************************************************************************
*	NAME:  IWDIG.C $Revision: 1.6 $
**	COPYRIGHT:
**	"Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: iwdig.c $
* Revision 1.6  1995/11/21 17:29:06  sdsmith
* Changes for new Windows init.
* Revision 1.5  1995/10/26 14:59:29  mleibow
* Added mutes for software mixer controls.
* Revision 1.4  1995/10/13 17:18:17  mleibow
* Fixed master volume to use 10dB drop off instead of 6dB.
* Revision 1.3  1995/06/22 08:30:46  sdsmith
* Added master volume query functions
* Revision 1.2  1995/05/24 23:44:11  sdsmith
* Fixed wave client volume vs. wave master volume
* Revision 1.1  1995/02/23 11:07:03  unknown
* Initial revision
***************************************************************************/

#include "iw.h"
#include "iwl.h"
#include "globals.h"
#include "digital.h"
#include "iwatten.h"

/***************************************************************************

FUNCITON DEFINITION:
iw_digital_master_volume - set the master volume for all digital audio playback

RETURNS: void
*/
void iw_dig_master_vol(short vol)
{
    iwl_digital_master_volume = IWL_TO_FMM(iw_atten_tab[vol]);
#if !defined(IWL_NO_CODEC)
    iwl_dig_codec_master_vol(0,0,0);
#endif
#if !defined(IWL_NO_SYNTH) && defined(IW_MODULE_SYNTH_DIGITAL)
    iwl_dig_synth_master_vol();
#endif
}

short iw_dig_get_master_vol(void)
{
    int i;
    int rc;
	for (i=0; i<IW_ATTENTABSIZE; i++) {
		if (IWL_FROM_FMM(iwl_digital_master_volume) > iw_atten_tab[i]) {
			break;
		}
	}
	if (i)
		rc = i - 1;
	else
		rc = 0;
	if (rc < 0)
		rc = 0;
	if (rc > 127)
		rc = 127;
    return(rc);
}

void iw_dig_mute(short mute)
{
    if (mute) {
	iwl_digital_mute_atten = IW_MAX_VOLUME;
    } else {
	iwl_digital_mute_atten = 0;
    }
#if !defined(IWL_NO_CODEC)
    iwl_dig_codec_master_vol(0,0,0);
#endif
#if !defined(IWL_NO_SYNTH) && defined(IW_MODULE_SYNTH_DIGITAL)
    iwl_dig_synth_master_vol();
#endif
}

