;***************************************************************************
;	NAME: IWL.INC
;	COPYRIGHT:
;	"Copyright (c) 1994,1995 by e-Tek Labs"
;
;       "This software is furnished under a license and may be used,
;        copied, or disclosed only in accordance with the terms of such
;        license and with the inclusion of the above copyright notice.
;        This software or any other copies thereof may not be provided or
;        otherwise made available to any other person. No title to and
;        ownership of the software is hereby transfered."
;****************************************************************************
; $Log: iwl.inc $
; Revision 1.1  1995/02/23 11:07:09  unknown
; Initial revision
;***************************************************************************/
MIN_BASE equ 200h
MAX_BASE equ 2f0h

; flags
F_IW_OS_LOADED equ 1
F_REDO_INT  equ 2
F_GEN_TC equ 4
F_REDO_MIDI_INT equ 8

; REGISTERS
SET_CONTROL    equ 0
SET_FREQUENCY  equ 1
SET_START_HIGH equ 2
SET_START_LOW  equ 3
SET_END_HIGH   equ 4
SET_END_LOW    equ 5
SET_VOLUME_RATE	equ 6
SET_VOLUME_START equ 7
SET_VOLUME_END   equ 8
SET_VOLUME       equ 9
SET_ACC_HIGH     equ 0ah
SET_ACC_LOW	 equ 0bh
SET_BALANCE	 equ 0ch
SET_VOLUME_CONTROL equ 0dh
SET_VOICES	   equ 0eh
DMA_CONTROL        equ 41h
SET_DMA_ADDRESS	   equ 42h
SET_DRAM_LOW       equ 43h
SET_DRAM_HIGH           equ 44h
ADLIB_CONTROL           equ 45h
ADLIB_TIMER1		equ 46h
ADLIB_TIMER2		equ 47h
SET_SAMPLE_RATE		equ 48h
SAMPLE_CONTROL          equ 49h
SET_JOYSTICK		equ 4Bh
MASTER_RESET		equ 4Ch
GET_CONTROL		equ 80h
GET_FREQUENCY		equ 81h
GET_START_HIGH		equ 82h
GET_START_LOW		equ 83h
GET_END_HIGH		equ 84h
GET_END_LOW		equ 85h
GET_VOLUME_RATE		equ 86h
GET_VOLUME_START	equ 87h
GET_VOLUME_END		equ 88h
GET_VOLUME		equ 89h
GET_ACC_HIGH		equ 8ah
GET_ACC_LOW		equ 8bh
GET_BALANCE		equ 8ch
GET_VOLUME_CONTROL 	equ 8dh
GET_VOICES		equ 8eh
GET_IRQV		equ 8fh

; REGISTER BITS
; mixer
IWL_DISABLE_LINE	equ 1
IWL_DISABLE_OUT		equ 2
IWL_ENABLE_MIC		equ 4
IWL_ENABLE_IRQ_DMA	equ 8
IWL_CONTROL_REGISTER_SELECT	equ 16

; voice control
IWL_STOPPED		equ 1
IWL_STOP		equ 2
IWL_WT16		equ 4
IWL_LPE			equ 8
IWL_BLE			equ 16
IWL_IRQE		equ 32
IWL_DIR_DEC		equ 64
IWL_IRQP		equ 128

; volume control
IWL_STOPPED		equ 1
IWL_STOP		equ 2
IWL_ENPCM		equ 4
IWL_LPE			equ 8
IWL_BLE			equ 16
IWL_IRQE		equ 32
IWL_DIR_DEC		equ 64
IWL_IRQP		equ 128

; IRQ control
IWL_COMBINE_IRQ		equ 64
 
; DMA control
IWL_COMBINE_DMA		equ 64

; IRQ status register
MIDI_IRQ_SEND		equ 1
MIDI_IRQ_RCV		equ 2
TIMER_1			equ 4
TIMER_2			equ 8
ADLIB_DATA		equ 16
IWL_WAVETABLE		equ 32
IWL_ENVELOPE		equ 64
DMA_TC_BIT		equ 128

IFDEF MODULE_IWISR
    EPROC iw_add_handler
    EPROC iwl_process_irq1_interrupt
    EPROC iwl_process_irq2_interrupt
    EPROC iwl_isr_init
ENDIF
IFDEF MODULE_GF1MEM
    EPROC iwl_write_block
    EPROC iw_read_block
ENDIF
IFDEF MODULE_GF1DMA
    EPROC iw_dma_ready
ENDIF
IFDEF MODULE_GF1ADDR
    EPROC iwl_make_physical_address
ENDIF
