/***************************************************************************
*	NAME:  IWLOAD.C $Revision: 1.6 $
**	COPYRIGHT:
**	"Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: iwload.c $
* Revision 1.6  1995/10/26 14:59:30  mleibow
* Added mutes for software mixer controls.
* Revision 1.5  1995/06/09 14:13:54  sdsmith
* Mike's changes
* Revision 1.4  1995/06/09 05:01:06  mleibow
* Changed iw_load_kernel_to_automatically call iw_unload_kernel on failure.
* Revision 1.3  1995/04/20 09:24:33  sdsmith
* Added calls for iw_auto_deinit
* Revision 1.2  1995/02/24 14:02:21  mleibow
* changed iw_asm_init() to iw_auto_init() and added iw_close_kernel() code
* Revision 1.1  1995/02/23 11:07:12  unknown
* Initial revision
***************************************************************************/

#include <dos.h>
#include "iw.h"
#include "globals.h"
#include "iwl.h"
#include "digital.h"
#include "codec.h"

extern int os_loaded;

/***************************************************************************

FUNCTION DEFINITION:
iw_load_kernel - initalize the InterWave Kernel and subsystems

DESCRIPITON:
iw_load_kernel is typically the first kernel routine called.  This routine checks
the card's existance, sets the synthesizers PC interface parameters, 
initializes the codec, and initializes various data structures.

RETURNS: int - IW_OK
               IW_CARD_NOT_FOUND
	       other error codes
*/
int	iw_load_kernel(struct load_kernel_cfg RFAR *cfg)
{
    int rc;

	OS_PUSH_DISABLE();

        if ((rc = iw_init_kernel(cfg)) == IW_OK) {
	    if ((rc = iw_init_synth(cfg)) == IW_OK) {
		if ((rc = iw_init_codec(cfg)) == IW_OK) {
		    if ((rc = iw_init_mixer(cfg)) == IW_OK) {
			rc = iw_auto_init(cfg);
		    }
		}
	    }
	}
	if (rc != IW_OK) iw_unload_kernel();
	OS_POP_FLAGS();
	return(rc);
}

/***************************************************************************

FUNCTION DEFINITION:
iw_unload_kernel - shutdown the InterWave kernel

DESCRIPITON:
iw_unload_kernel stops all activity in the synth, ramps all voice volumes to
zero, clears interrupt status, and shuts down the codec.

RETURNS: int - IW_OK
*/
void	iw_unload_kernel(void)
{
	if (!(iwl_flags & F_IW_OS_LOADED)) return;
	if (os_loaded != 1) {
	    os_loaded--;
	    return;
	}
	OS_PUSH_DISABLE();
	iw_auto_deinit();
	iw_close_synth();
    iw_close_codec();
	iw_close_kernel();

//#if !defined(__WATCOMC__) && !defined(__FLAT__) && !defined(OS2) && !defined(_WINDOWS)
//	iw_free_multiplex();
//#endif
	OS_POP_FLAGS();
#ifdef DEBUG
	stack_check();
#endif
}
