/***************************************************************************
*	NAME:  IWNOTE.H $Revision: 1.6 $
**	COPYRIGHT:
**	"Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: iwnote.h $
* Revision 1.6  1995/10/13 17:29:06  mleibow
* Initial attempt at getting effects (reverb and chorus) into midi engine.
* Revision 1.5  1995/05/25 18:17:11  mleibow
* Revision 1.4  1995/05/25 15:14:15  mleibow
* Added far ptr list handling
* Revision 1.3  1995/05/03 09:20:19  mleibow
* Added tremolo to MOD wheel
* Revision 1.2  1995/04/17 12:56:05  mleibow
* Added iw_midi_master_volume() & volume query code
* Revision 1.1  1995/02/23 11:07:15  unknown
* Initial revision
***************************************************************************/

#define IW_MAX_VOICES 32
#define IW_MAX_CHANNELS 32
#define IW_MAX_SYNTHS (IW_MAX_CHANNELS/16)

#define VS_START ((struct voice_status RFAR *)(iwl_active_voices.head))
#define VS_NEXT(node) ((struct voice_status RFAR *)node->n.next)

#define DONT_WAIT 0
#define WAIT 1
#define POLLED 0
#define USE_INTERRUPT 1

#define STAT_VOICE_RUNNING	1
#define STAT_VOICE_SUSTAINING   2
#define STAT_VOICE_RELEASING	4
#define STAT_VOICE_VIBRATO_RUNNING         8
#define STAT_VOICE_TREMOLO_RUNNING         16

static enum env_index {
    BEFORE=-1,
    ATTACK=0,
    SUSTAIN=1,
    VAR_RELEASE=2,
    FINAL_RELEASE=3,
    DONE=4,
};

struct voice_status {
    struct iwl_node n;		/* node header, must be first in structure */
    struct iw_layer RFAR *layer;/* current playing layer */
    struct iw_wave RFAR *wave;	/* current playing wave */
    short layer_atten;		/* 12 bit log attenuation 1 = 0.234375dB */
    short pan_offset;		/* offset from channel pan position */
    short vel_atten;		/* velocity attenuation */
    short wave_atten;		/* wave attenuation */
    short voice;
    short rel_offset;		/* release attenuation offset */
    USHORT fc_register;		/* fc image before pitch envelope */
    USHORT ofc_reg;		/* fc register before freq scaling */
    /* volume envelope data */
    enum env_index venv_state;
    short venv_index;
    short RFAR *venv_data;
    struct iw_envp_header RFAR *vep;
    struct iw_envp_record RFAR *ver;
    /* pitch envelope data */
    enum env_index penv_state;
    short penv_index;
    short RFAR *penv_data;
    struct iw_envp_header RFAR *pep;
    struct iw_envp_record RFAR *per;
    long penv_pitch;	  /* current pitch multiplier */
    long penv_increment;  /* increment per clock interval */
    long penv_next;	  /* destination pitch multiplier */
    short penv_timer;	  /* countdown centisecond timer */
    short penv_in_progress;	  /* true while pitch slide in progress */
    /* */
    struct note_status RFAR *note;
    char pan;			/* final pan value (0 - 127) */
    UCHAR status;
    UCHAR synth;
    UCHAR channel;
    UCHAR volume_control;
    UCHAR voice_control;
};

#define CHANNEL_SUSTAIN 1
#define CHANNEL_LEGATO  2
struct channel_status {
    struct iw_patch RFAR *patch;/* currently assigned patch */
    short volume;		/* 12 bit log attenuation 1 = 0.234375dB */
    short expression;		/* 12 bit log attenuation 1 = 0.234375dB */
    short pitch_bend;		/* pitch multiplier (10 bit fraction) */
    char pan;			/* midi pan position (0 - 127) */
    char status;
    short vib_depth;
    short trem_depth;
    short effect1_level;	/* reverb level */
    short effect3_level;	/* chorus level */
};

#define NS_START ((struct note_status RFAR *)(iwl_active_notes.head))
#define NS_NEXT(node) ((struct note_status RFAR *)node->n.next)

#define NOTE_ACTIVE  1
#define NOTE_SUSTAIN 2
#define NOTE_RELEASING 4
struct note_status {
    struct iwl_node n;		/* node header, must be first in structure */
    struct iw_patch RFAR *patch;
    USHORT priority;
    char note;
    char velocity;
    char status;
    char channel;
};

/* local functions */
void iwl_change_voice_volume(int voice);

/* private global data structures */
extern struct iwl_list iwl_active_voices;
extern struct iwl_list iwl_active_notes;
extern struct channel_status iwl_channel_status[IW_MAX_CHANNELS];
extern short iwl_m_volume[IW_MAX_SYNTHS]; /* 12 bit log attenuation */
extern short iwl_midi_master_volume; /* 12 bit log attenuation */

