/***************************************************************************
*	NAME:  IWUART.C $Revision: 1.2 $
**	COPYRIGHT:
**	"Copyright (c) 1994,1995 e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: iwuart.c $
* Revision 1.2  1995/05/03 08:50:45  mleibow
* Changed names with midi to uart
* Revision 1.1  1995/02/23 11:07:39  unknown
* Initial revision
***************************************************************************/

#include <dos.h>
#include "iw.h"
#include "iwl.h"
#include "globals.h"

int iwl_uart_init(void)
{
    iw_uart_reset(IW_UART_RESET);
    iw_uart_reset(IW_UART_POLLED);
    return(0);
}

void iw_uart_reset(int c)
{
    OS_OUTPORTB(iwl_uart_control, c);
    iw_delay();
}

void iw_uart_send(int datum)
{
    int port_val;

    for(;;) {
	port_val = OS_INPORTB(iwl_uart_control);
	if ((port_val & IW_UART_TD)) break;
    }
    OS_OUTPORTB(iwl_uart_data, datum);
}

int iw_uart_recv(void)
{
    int port_val, datum;
    
    for(;;) {
	port_val = OS_INPORTB(iwl_uart_control);
	if ((port_val & IW_UART_RD)) break;
    }
    datum = OS_INPORTB(iwl_uart_data);
    return(datum);
}

int iw_uart_status(void)
{
    int port_val;
    
    port_val = OS_INPORTB(iwl_uart_control);
    return(port_val);
}
