/***************************************************************************
*	NAME:  IWWISR.C $Revision: 1.1 $
**	COPYRIGHT:
**	"Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: iwwisr.c $
* Revision 1.1  1995/02/23 11:07:41  unknown
* Initial revision
***************************************************************************/
#include "globals.h"
#include "iw.h"
#include "iwl.h"

//#define FLASH

#define USER_STACK_SIZE 1024
static unsigned char user_stack[USER_STACK_SIZE];
static unsigned char __far *user_stack_p = user_stack + USER_STACK_SIZE;
static unsigned int user_ss;
static unsigned long user_sp;
static unsigned char stack_in_use=0;
//static int midi_semaphore=0;

#if defined(__WATCOMC__) && defined(__FLAT__)
#pragma aux NewStack = \
	"mov    word ptr user_ss, ss"		\
	"mov	user_sp, esp"			\
	"lss	esp, user_stack_p"		

#pragma aux OldStack = \
	"mov	ax, word ptr user_ss"		\
	"mov	ss, ax"				\
	"mov	esp, user_sp"			\
	modify [EAX]
#endif

/***************************************************************************

FUNCTION DEFINITION:
iwl_irq1_service - interrupt service routine for syntheziser interrupt

DESCRIPTION:
iwl_irq1_service is the function whose address is placed in the interrupt
vector table for the IRQ assigned to the synthesizer.  When the synthesizer
generates an interrupt, this routine receives control first.

This routine sends the EOI signal to the PIC.

RETURNS: void

SEE ALSO:
iwl_process_interrupt

NOTE: This routine is only used with the Watcom compiler
*/
void interrupt iwl_irq1_service(void)
{
#ifdef FLASH
OS_INPORTB(0x3da);
OS_OUTPORTB(0x3c0, 0x31);
OS_OUTPORTB(0x3c0, 0x31);
#endif
	os_eoi(iwl_irq1);
	if (iwl_irq1_semaphore != 0) {
	    iwl_flags |= F_REDO_INT;
#ifdef FLASH
OS_INPORTB(0x3da);
OS_OUTPORTB(0x3c0, 0x31);
OS_OUTPORTB(0x3c0, 0x0);
#endif
	    return;
	}
	iwl_irq1_semaphore++;
	NewStack();
	OS_LOAD_ES_WITH_DS();
	do {
	    iwl_flags &= ~F_REDO_INT;
	    iwl_process_irq1_interrupt();
	} while (iwl_flags & F_REDO_INT);
	OldStack();
	iwl_irq1_semaphore--;
#ifdef FLASH
OS_INPORTB(0x3da);
OS_OUTPORTB(0x3c0, 0x31);
OS_OUTPORTB(0x3c0, 0x0);
#endif
	return;
}

/***************************************************************************

FUNCTION DEFINITION:
iwl_irq2_service - interrupt service routine for MIDI port interrupt

DESCRIPTION:
iwl_irq2_service is the function whose address is placed in the interrupt
vector table for the IRQ assigned to the MIDI port.  When the MIDI port
generates an interrupt, this routine receives control first.

This routine sends the EOI signal to the PIC. 

RETURNS: void

SEE ALSO:
process_midi_interrupt

NOTE: This routine is only used with the Watcom compiler
*/
void interrupt iwl_irq2_service(void)
{
    os_eoi(iwl_irq2);
//    if (iwl_semaphore != 0) {
//	iwl_flags |= F_REDO_INT;
//	return;
//    }
//    midi_semaphore++;
//    do {
//	iwl_flags &= ~F_REDO_INT;
	iwl_process_irq2_interrupt();
//    } while (iwl_flags & F_REDO_INT);
//    midi_semaphore--;
}
