# InterWave Kernel Makefile for OS/2 
# $Revision: 1.3 $

CC = cl
PROCESSOR = -DPROC386
EXTRA =
MODEL=S
MODELlc = s
# DIR = os2
LIBNAME = iw_os2.lib
CODESIZE = -DNEARCODE=1
DATASIZE = -DNEARDATA=1
CPROC = -G2
DDKDIR = $(ROOTDIR)\ddk
OSINCDIR = os\os2
CFLAGS = $(DEBUG) -Zp1 -I. -I$(OSINCDIR) -I$(INCLUDE) $(DATASIZE) $(CODESIZE) $(CPROC) -Ox -A$(MODEL) -Aw $(PROCESSOR) -Gs -W3 -DOS2 -Fl
ASMFLAGS = -DMASM -DOS2 $(PROCESSOR) $(DEBUG) -D__$(MODELlc)__ $(CODESIZE) $(DATASIZE) /Sa /Fo$*.obj

LANGUAGES = english\kernel.mls

all: BEGIN $(TARGETDIR)\iw_os2.lib $(LANGUAGES)

english\kernel.mls: english\kernel.txt
	$(TOOLS)\mlscomp\mlscomp english\kernel.txt
.c.obj:
	$(CC) -c $(CFLAGS) -Fo$(TARGETDIR)\$*.obj $*.c

OBJS= 	iwinit2.obj \
	iwisr1.obj \
	iwisr.obj \
	iwsem.obj \
	iwinit.obj \
	iwpnp.obj \
	iwsynth.obj \
	iwload.obj \
	iwdetct.obj \
	globals.obj \
	iwmem.obj \
	iwdram.obj \
	iwutils.obj \
	iwvoice.obj \
	iwdma.obj \
	iwaddr.obj \
	iwatten.obj \
	iwllist.obj \
	iwnote.obj \
	iwnote1.obj \
	iwlfo.obj \
	iwscale.obj \
	timer.obj \
	iwerror.obj \
	iwmidi.obj \
	iwuart.obj \
	iwmixer.obj \
	iwsound.obj \
	iwdig.obj \
	play.obj \
	record.obj \
	codec.obj \
	play16.obj \
	irq16.obj \
	vars16.obj \
	util16.obj \
	mixer.obj \
	profile.obj \
	profile1.obj \
	mixctl.obj \
	mixbld.obj \
	iwmls.obj \
	os.obj


BEGIN:
	set CL=$(CFLAGS)
	set INCLUDE=$(INCLUDE)

$(TARGETDIR)\iwainit.obj: iwainit.asm iwasm.inc globals.inc iwpriv.inc
	ml -c $(ASMFLAGS) iwainit.asm
$(TARGETDIR)\iwwmem.obj: iwwmem.asm iwinit.inc
	ml -c $(ASMFLAGS) iwwmem.asm
$(TARGETDIR)\iwwvoic.obj: iwwvoic.asm iwinit.inc
	ml -c $(ASMFLAGS) iwwvoic.asm
$(TARGETDIR)\iwwdma.obj: iwwdma.asm iwinit.inc
	ml -c $(ASMFLAGS) iwwdma.asm
$(TARGETDIR)\wdigital.obj: wdigital.asm iwinit.inc
	ml -c $(ASMFLAGS) wdigital.asm
$(TARGETDIR)\iwwnote.obj: iwwnote.asm iwinit.inc
	ml -c $(ASMFLAGS) iwwnote.asm
$(TARGETDIR)\wtimer.obj: wtimer.asm iwinit.inc
	ml -c $(ASMFLAGS) wtimer.asm
$(TARGETDIR)\iwwuart.obj: iwwuart.asm iwinit.inc
	ml -c $(ASMFLAGS) iwwuart.asm
$(TARGETDIR)\iwinit2.obj: iwinit2.asm iwinit.inc
	ml -c $(ASMFLAGS) iwinit2.asm
$(TARGETDIR)\iwsem.obj: iwsem.asm iwasm.inc globals.inc iwpriv.inc
	ml -c $(ASMFLAGS) iwsem.asm
$(TARGETDIR)\iwisr1.obj: iwisr1.asm iwasm.inc globals.inc iwpriv.inc
	ml -c $(ASMFLAGS) iwisr1.asm
$(TARGETDIR)\iwisr.obj: iwisr.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\iwisr.obj iwisr.c
$(TARGETDIR)\iwinit.obj: iwinit.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\iwinit.obj iwinit.c
$(TARGETDIR)\iwdetct.obj: iwdetct.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\iwdetct.obj iwdetct.c
$(TARGETDIR)\globals.obj: globals.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\globals.obj globals.c
$(TARGETDIR)\iwmem.obj: iwmem.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\iwmem.obj iwmem.c
$(TARGETDIR)\iwmem1.obj: iwmem1.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\iwmem1.obj iwmem1.c
$(TARGETDIR)\iwdram.obj: iwdram.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\iwdram.obj iwdram.c
$(TARGETDIR)\iwutils.obj: iwutils.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\iwutils.obj iwutils.c
$(TARGETDIR)\iwvoice.obj: iwvoice.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\iwvoice.obj iwvoice.c
$(TARGETDIR)\iwdma.obj: iwdma.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\iwdma.obj iwdma.c
$(TARGETDIR)\iwdma1.obj: iwdma1.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\iwdma1.obj iwdma1.c
$(TARGETDIR)\iwaddr.obj: iwaddr.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\iwaddr.obj iwaddr.c
$(TARGETDIR)\divisor.obj: divisor.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\divisor.obj divisor.c
$(TARGETDIR)\digital.obj: digital.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\digital.obj digital.c
$(TARGETDIR)\digpause.obj: digpause.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\digpause.obj digpause.c
$(TARGETDIR)\digpos.obj: digpos.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\digpos.obj digpos.c
$(TARGETDIR)\iwatten.obj: iwatten.c iw.h iwl.h globals.h iwatten.h
	$(CC) -c -Fo$(TARGETDIR)\iwatten.obj iwatten.c
$(TARGETDIR)\iwllist.obj: iwllist.c iw.h iwl.h globals.h iwllist.h
	$(CC) -c -Fo$(TARGETDIR)\iwllist.obj iwllist.c
$(TARGETDIR)\iwnote.obj: iwnote.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\iwnote.obj iwnote.c
$(TARGETDIR)\timer.obj: timer.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\timer.obj timer.c
$(TARGETDIR)\iwerror.obj: iwerror.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\iwerror.obj iwerror.c
$(TARGETDIR)\iwscale.obj: iwscale.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\iwscale.obj iwscale.c
$(TARGETDIR)\iwmidi.obj: iwmidi.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\iwmidi.obj iwmidi.c
$(TARGETDIR)\iwuart.obj: iwuart.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\iwuart.obj iwuart.c
$(TARGETDIR)\iwrec.obj: iwrec.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\iwrec.obj iwrec.c
$(TARGETDIR)\iwmixer.obj: iwmixer.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\iwmixer.obj iwmixer.c
$(TARGETDIR)\icsmixer.obj: icsmixer.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\icsmixer.obj icsmixer.c
$(TARGETDIR)\voltab.obj: voltab.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\voltab.obj voltab.c
$(TARGETDIR)\iwsound.obj: iwsound.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\iwsound.obj iwsound.c
$(TARGETDIR)\play.obj: play.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\play.obj play.c
$(TARGETDIR)\record.obj: record.c iw.h iwl.h globals.h
	$(CC) -c -Fo$(TARGETDIR)\record.obj record.c
$(TARGETDIR)\play16.obj: play16.c iw.h iwl.h globals.h codec.h
	$(CC) -c -Fo$(TARGETDIR)\play16.obj play16.c
$(TARGETDIR)\vars16.obj: vars16.c iw.h iwl.h globals.h codec.h
	$(CC) -c -Fo$(TARGETDIR)\vars16.obj vars16.c
$(TARGETDIR)\util16.obj: util16.c iw.h iwl.h globals.h codec.h
	$(CC) -c -Fo$(TARGETDIR)\util16.obj util16.c
$(TARGETDIR)\codec.obj: codec.c iw.h iwl.h globals.h codec.h
	$(CC) -c -Fo$(TARGETDIR)\codec.obj codec.c
$(TARGETDIR)\irq16.obj: irq16.c iw.h iwl.h globals.h codec.h
	$(CC) -c -Fo$(TARGETDIR)\irq16.obj irq16.c
$(TARGETDIR)\mixer16.obj: mixer16.c iw.h iwl.h globals.h codec.h
	$(CC) -c -Fo$(TARGETDIR)\mixer16.obj mixer16.c
$(TARGETDIR)\mixctl.obj: mixctl.c iw.h iwl.h globals.h codec.h
	$(CC) -c -Fo$(TARGETDIR)\mixctl.obj mixctl.c
$(TARGETDIR)\mixbld.obj: mixbld.c iw.h iwl.h globals.h codec.h
	$(CC) -c -Fo$(TARGETDIR)\mixbld.obj mixbld.c
$(TARGETDIR)\profile.obj: profile.c iw.h profile.h
	$(CC) -c -Fo$(TARGETDIR)\profile.obj profile.c
$(TARGETDIR)\profile1.obj: profile1.c iw.h profile.h
	$(CC) -c -Fo$(TARGETDIR)\profile1.obj profile1.c
$(TARGETDIR)\iwmls.obj: iwmls.c iw.h
	$(CC) -c -Fo$(TARGETDIR)\iwmls.obj iwmls.c
$(TARGETDIR)\os.obj: $(OSINCDIR)\os.c
	$(CC) -I$(DDKDIR)\h -I$(DDKDIR)\mmos2\mmtoolkt\h -I..\os2 -c -Fo$(TARGETDIR)\os.obj $(OSINCDIR)\os.c

$(TARGETDIR)\$(LIBNAME): $(OBJS) makeos
        if exist $(TARGETDIR)\$(LIBNAME) del $(TARGETDIR)\$(LIBNAME)
	lib $(TARGETDIR)\$(LIBNAME) @<<makems.lnk
+$(OBJS:  = &^
+)
;
<<KEEP

clean:
	if exist $(TARGETDIR)\*.obj del $(TARGETDIR)\*.obj
	if exist $(TARGETDIR)\*.lib del $(TARGETDIR)\*.lib
	if exist $(TARGETDIR)\*.bak del $(TARGETDIR)\*.bak
