# InterWave Kernel Makefile for Microsoft Windows Driver using C/C++ v8.0
# $Revision: 1.16 $
#

LIBNAME = iw_osdm.lib

!IF "$(MODEL)"=="T"
EXTRA = $(EXTRA) -D__t__
!endif

!if "$(MODEL)"=="T" || "$(MODEL)"=="S" || "$(MODEL)"=="C"
CODESIZE =-DNEARCODE=1
!else
CODESIZE =-DNEARCODE=0
!endif

!if "$(MODEL)"=="T" || "$(MODEL)"=="S" || "$(MODEL)"=="M"
DATASIZE =-DNEARDATA=1
!else
DATASIZE =-DNEARDATA=0
!endif

!if "$(MODEL)"=="T"
MODELlc = t
!endif

!if "$(MODEL)"=="S"
MODELlc = s
!endif

!if "$(MODEL)"=="M"
MODELlc = m
!endif

!if "$(MODEL)"=="C"
MODELlc = c
!endif

!if "$(MODEL)"=="L"
MODELlc = l
!endif

!if "$(MODEL)"=="H"
MODELlc = h
!endif

PROCESSOR = -DPROC386
EXTRA =

!if [SET CL=-Gs -GA -Zp1 -Aw -DPROC386]
!endif
!if "$(DEBUG)"=="YES"
COPT = -W3 -Od
CPROC = -G2
!else
EXTRA = $(EXTRA) $(PROCESSOR)
COPT = -w -Ox -Os
CPROC = -G3
!endif

OSINCDIR = os\windows

!if "$(DEBUG)"=="YES"
CFLAGS = -Zi $(DATASIZE) $(CODESIZE) $(CPROC) $(COPT) -A$(MODEL) /Fo$*.obj -DIWU_PATCH_EDIT
ASMFLAGS = -Zi $(PROCESSOR) -D__$(MODELlc)__ $(CODESIZE) $(DATASIZE) /Fo$*.obj
!else
CFLAGS = $(DATASIZE) $(CODESIZE) $(CPROC) $(COPT) -A$(MODEL) /Fo$*.obj -DIWU_PATCH_EDIT
ASMFLAGS = $(PROCESSOR) -D__$(MODELlc)__ $(CODESIZE) $(DATASIZE) /Fo$*.obj
!endif


.c.obj:
	cl -c $(CFLAGS) $*.c

OBJS= 	$(TARGETDIR)\iwinit2.obj \
	$(TARGETDIR)\iwisr1.obj \
	$(TARGETDIR)\iwisr.obj \
	$(TARGETDIR)\iwsem.obj \
	$(TARGETDIR)\iwinit.obj \
	$(TARGETDIR)\iwpnp.obj \
	$(TARGETDIR)\iwsynth.obj \
	$(TARGETDIR)\iwload.obj \
	$(TARGETDIR)\iwdetct.obj \
	$(TARGETDIR)\globals.obj \
	$(TARGETDIR)\iwmem.obj \
	$(TARGETDIR)\iwdram.obj \
	$(TARGETDIR)\iwutils.obj \
	$(TARGETDIR)\iwvoice.obj \
	$(TARGETDIR)\iwdma.obj \
	$(TARGETDIR)\iwaddr.obj \
	$(TARGETDIR)\iwatten.obj \
	$(TARGETDIR)\iwllist.obj \
	$(TARGETDIR)\iwnote.obj \
	$(TARGETDIR)\iwnote1.obj \
	$(TARGETDIR)\iwnote2.obj \
	$(TARGETDIR)\iwlfo.obj \
	$(TARGETDIR)\iwscale.obj \
	$(TARGETDIR)\timer.obj \
	$(TARGETDIR)\iwerror.obj \
	$(TARGETDIR)\iwmidi.obj \
	$(TARGETDIR)\iwuart.obj \
	$(TARGETDIR)\iwmixer.obj \
	$(TARGETDIR)\iwsound.obj \
	$(TARGETDIR)\iwdig.obj \
	$(TARGETDIR)\play.obj \
	$(TARGETDIR)\record.obj \
	$(TARGETDIR)\codec.obj \
	$(TARGETDIR)\play16.obj \
	$(TARGETDIR)\irq16.obj \
	$(TARGETDIR)\vars16.obj \
	$(TARGETDIR)\util16.obj \
	$(TARGETDIR)\mixer.obj \
	$(TARGETDIR)\profile.obj \
	$(TARGETDIR)\profile1.obj \
	$(TARGETDIR)\mixctl.obj \
	$(TARGETDIR)\mixbld.obj \
	$(TARGETDIR)\iwmls.obj \
	$(TARGETDIR)\patch.obj \
	$(TARGETDIR)\effects.obj \
	$(TARGETDIR)\os.obj

LANGUAGES = english\kernel.mls english\patch.mls

all: $(TARGETDIR)\iw_osdm.lib $(LANGUAGES)

dist: $(LANGUAGES)
	cp english\kernel.mls $(IWPROJ)\dist\language\english
	cp english\patch.mls $(IWPROJ)\dist\language\english

english\kernel.mls: english\kernel.txt
	$(TOOLS)\mlscomp\mlscomp english\kernel.txt
english\patch.mls: english\patch.txt
	$(TOOLS)\mlscomp\mlscomp english\patch.txt

$(TARGETDIR)\iwainit.obj: iwainit.asm iwasm.inc globals.inc iwl.inc
	mlx -c $(ASMFLAGS) -DSEGNAME=_TEXT2 iwainit.asm
$(TARGETDIR)\iwwmem.obj: iwwmem.asm iwinit.inc
	mlx -c $(ASMFLAGS) -DSEGNAME=_TEXT2 iwwmem.asm
$(TARGETDIR)\iwwvoic.obj: iwwvoic.asm iwinit.inc
	mlx -c $(ASMFLAGS) -DSEGNAME=_TEXT2 iwwvoic.asm
$(TARGETDIR)\iwwdma.obj: iwwdma.asm iwinit.inc
	mlx -c $(ASMFLAGS) -DSEGNAME=_TEXT2 iwwdma.asm
$(TARGETDIR)\wdigital.obj: wdigital.asm iwinit.inc
	mlx -c $(ASMFLAGS) -DSEGNAME=_TEXT2 wdigital.asm
$(TARGETDIR)\wrecord.obj: wrecord.asm iwinit.inc
	mlx -c $(ASMFLAGS) -DSEGNAME=_TEXT2 wrecord.asm
$(TARGETDIR)\iwwnote.obj: iwwnote.asm iwinit.inc
	mlx -c $(ASMFLAGS) -DSEGNAME=_TEXT2 iwwnote.asm
$(TARGETDIR)\iwwlfo.obj: iwwlfo.asm iwinit.inc
	mlx -c $(ASMFLAGS) -DSEGNAME=_TEXT2 iwwlfo.asm
$(TARGETDIR)\iwwcodec.obj: iwwcodec.asm iwinit.inc
	mlx -c $(ASMFLAGS) -DSEGNAME=_TEXT2 iwwcodec.asm
$(TARGETDIR)\wtimer.obj: wtimer.asm iwinit.inc
	mlx -c $(ASMFLAGS) -DSEGNAME=_TEXT2 wtimer.asm
$(TARGETDIR)\iwwuart.obj: iwwuart.asm iwinit.inc
	mlx -c $(ASMFLAGS) -DSEGNAME=_TEXT2 iwwuart.asm
$(TARGETDIR)\iwwsnd.obj: iwwsnd.asm iwinit.inc
	mlx -c $(ASMFLAGS) -DSEGNAME=_TEXT2 iwwsnd.asm
$(TARGETDIR)\iwinit2.obj: iwinit2.asm iwinit.inc
	mlx -c $(ASMFLAGS) -DSEGNAME=_TEXT2 iwinit2.asm
$(TARGETDIR)\iwisr1.obj: iwisr1.asm iwasm.inc globals.inc iwl.inc
	mlx -c $(ASMFLAGS) -DSEGNAME=_TEXT2 iwisr1.asm
$(TARGETDIR)\iwisr.obj: iwisr.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwisr.c
$(TARGETDIR)\iwsem.obj: iwsem.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwsem.c
$(TARGETDIR)\iwinit.obj: iwinit.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwinit.c
$(TARGETDIR)\iwpnp.obj: iwpnp.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwpnp.c
$(TARGETDIR)\iwsynth.obj: iwsynth.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwsynth.c
$(TARGETDIR)\iwload.obj: iwload.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwload.c
$(TARGETDIR)\iwdetct.obj: iwdetct.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwdetct.c
$(TARGETDIR)\globals.obj: globals.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) globals.c
$(TARGETDIR)\iwmem.obj: iwmem.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwmem.c
$(TARGETDIR)\iwmem1.obj: iwmem1.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwmem1.c
$(TARGETDIR)\iwdram.obj: iwdram.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwdram.c
$(TARGETDIR)\iwutils.obj: iwutils.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwutils.c
$(TARGETDIR)\iwvoice.obj: iwvoice.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwvoice.c
$(TARGETDIR)\iwdma.obj: iwdma.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwdma.c
$(TARGETDIR)\iwdma1.obj: iwdma1.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwdma1.c
$(TARGETDIR)\iwaddr.obj: iwaddr.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwaddr.c
$(TARGETDIR)\divisor.obj: divisor.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 divisor.c
$(TARGETDIR)\digital.obj: digital.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 digital.c
$(TARGETDIR)\digpause.obj: digpause.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 digpause.c
$(TARGETDIR)\dignext.obj: dignext.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 dignext.c
$(TARGETDIR)\digpos.obj: digpos.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 digpos.c
$(TARGETDIR)\iwatten.obj: iwatten.c iw.h iwl.h globals.h iwatten.h
	cl -c $(CFLAGS) -NT _TEXT2 iwatten.c
$(TARGETDIR)\iwllist.obj: iwllist.c iw.h iwl.h globals.h iwllist.h
	cl -c $(CFLAGS) -NT _TEXT2 iwllist.c
$(TARGETDIR)\iwnote.obj: iwnote.c iw.h iwl.h globals.h iwnote.h
	cl -c $(CFLAGS) -NT _TEXT2 iwnote.c
$(TARGETDIR)\iwnote1.obj: iwnote1.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwnote1.c
$(TARGETDIR)\iwnote2.obj: iwnote2.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwnote2.c
$(TARGETDIR)\iwlfo.obj: iwlfo.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwlfo.c
$(TARGETDIR)\iwscale.obj: iwscale.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) iwscale.c
$(TARGETDIR)\timer.obj: timer.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 timer.c
$(TARGETDIR)\iwerror.obj: iwerror.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwerror.c
$(TARGETDIR)\iwmidi.obj: iwmidi.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwmidi.c
$(TARGETDIR)\iwuart.obj: iwuart.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwuart.c
$(TARGETDIR)\iwrec.obj: iwrec.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwrec.c
$(TARGETDIR)\iwmixer.obj: iwmixer.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) iwmixer.c
$(TARGETDIR)\icsmixer.obj: icsmixer.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) icsmixer.c
$(TARGETDIR)\voltab.obj: voltab.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 voltab.c
$(TARGETDIR)\iwsound.obj: iwsound.c iw.h iwl.h globals.h
	cl -c $(CFLAGS) -NT _TEXT2 iwsound.c
$(TARGETDIR)\iwdig.obj: iwdig.c iw.h iwl.h globals.h digital.h
	cl -c $(CFLAGS) -NT _TEXT2 iwdig.c
$(TARGETDIR)\play.obj: play.c iw.h iwl.h globals.h digital.h
	cl -c $(CFLAGS) -NT _TEXT2 play.c
$(TARGETDIR)\record.obj: record.c iw.h iwl.h globals.h digital.h
	cl -c $(CFLAGS) -NT _TEXT2 record.c
$(TARGETDIR)\play16.obj: play16.c iw.h iwl.h globals.h codec.h digital.h
	cl -c $(CFLAGS) -NT _TEXT2 play16.c
$(TARGETDIR)\vars16.obj: vars16.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) vars16.c
$(TARGETDIR)\util16.obj: util16.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) -NT _TEXT3 util16.c
$(TARGETDIR)\codec.obj: codec.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) codec.c
$(TARGETDIR)\cdcclose.obj: cdcclose.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) cdcclose.c
$(TARGETDIR)\irq16.obj: irq16.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) -NT _TEXT2 irq16.c
$(TARGETDIR)\mixer.obj: mixer.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) -NT _TEXT3 mixer.c
$(TARGETDIR)\mixctl.obj: mixctl.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS)  -NT _TEXT3 mixctl.c
$(TARGETDIR)\mixbld.obj: mixbld.c iw.h iwl.h globals.h codec.h
	cl -c $(CFLAGS) mixbld.c
$(TARGETDIR)\profile.obj: profile.c iw.h profile.h
	cl -c $(CFLAGS) profile.c
$(TARGETDIR)\profile1.obj: profile1.c iw.h profile.h
	cl -c $(CFLAGS) profile1.c
$(TARGETDIR)\iwmls.obj: iwmls.c iw.h
	cl -c $(CFLAGS) iwmls.c
#$(TARGETDIR)\list.obj: list.c list.h
#	cl -c $(CFLAGS) -NT _TEXT3 list.c
$(TARGETDIR)\patch.obj: patch.c patch.h
	cl -c $(CFLAGS) -NT _TEXT3 patch.c
$(TARGETDIR)\effects.obj: effects.c
	cl -c $(CFLAGS) -NT _TEXT2 effects.c
$(TARGETDIR)\os.obj: $(OSINCDIR)\os.c
	cl -c $(CFLAGS) -NT _TEXT2 -I$(IWPROJ)\windows\viwd $(OSINCDIR)\os.c

$(TARGETDIR)\$(LIBNAME): $(OBJS) makmsdll.ksh
	if exist $(TARGETDIR)\$(LIBNAME) del $(TARGETDIR)\$(LIBNAME)
	lib $(TARGETDIR)\$(LIBNAME) @<<makmsdll.lnk
+$(OBJS:  = &^
+)
;
<<KEEP

clean:
	if exist $(TARGETDIR)\*.obj del $(TARGETDIR)\*.obj
	if exist $(TARGETDIR)\*.lib del $(TARGETDIR)\*.lib
	if exist $(TARGETDIR)\*.bak del $(TARGETDIR)\*.bak
	
########### segmentation ##########
#
#   INIT   is the init/exit time segment
#   _TEXT2  is the interrupt time fixed segment
#   KERNEL is the Kernel code

SEG  = $(CC) -NT TSEG $*.c
SEGA = $(ASM) -DSEGNAME=TSEG /Fo $*.obj /Ta $*.asm

# libinit.obj    : ; $(SEGA:TSEG=INIT)
# drvproc.obj    : ; $(SEG:TSEG=INIT)
