/***************************************************************************
*	NAME:  OS.H $Revision: 1.1 $
**	COPYRIGHT:
**	"Copyright (c) 1994, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: os.h $
* Revision 1.1  1995/02/23 11:06:54  unknown
* Initial revision
* Revision 1.1  1994/09/12 15:17:46  unknown
***************************************************************************
* This module has macros for operating system dependant functions 
***************************************************************************/

#include <dos.h>
#include <conio.h>

/* DOS functions */
#define	DOS_TRAP	0x21
#define	SETVECTOR	0x2500
#define	GETVECTOR	0x3500
#define DOS_READ	0x3F00
#define DOS_CLOSE	0x3E00
#define DOS_OPEN_R	0x3D00
#define DOS_SEEK	0x42

/* DMA mode bits */
#define DMAMODE_VERIFY_TRANSFER	0x00	/* verify DMA transfer mode */
#define DMAMODE_WRITE		0x04	/* write to external device */
#define DMAMODE_READ		0x08	/* read from external device */
#define DMAMODE_AUTOINIT	0x10	/* autoinitialization mode */
#define DMAMODE_AUTOINC		0x20	/* autoincrement mode */
#define DMAMODE_DEMAND_MODE	0x00
#define DMAMODE_SINGLE_MODE	0x40
#define DMAMODE_BLOCK_MODE	0x80
#define DMAMODE_CASCADE_MODE	0xC0

/* DMA macros */
#define DMA_GET_PAGE(addr) ((unsigned short)((addr & 0xffff0000L) >> 16))
#define DMA_GET_ADDR(addr) ((unsigned short)(addr & 0x0000ffffL))
#define DMA_PAGE_SIZE	0x10000L

#define ASM _asm
#ifndef RFAR
#define RFAR far
#endif
#define MK_FP(a, b) ((void far *)(((unsigned long)(a)<<16)+((unsigned long)b)))
#define OS_DISABLE_INTERRUPTS() _disable()
#define OS_ENABLE_INTERRUPTS()  _enable()
#define OS_OUTPORTW 		outpw
#define OS_OUTPORTB		outp
#define OS_INPORTW		inpw
#define OS_INPORTB		(unsigned char)inp
#define OS_LOAD_ES_WITH_DS()	_asm push ds _asm pop es 
#define OS_PUSH_DISABLE()	os_push_disable()
#define OS_POP_FLAGS()		os_popf()
#define OS_PUSH_DS()		_asm push ds 
#define OS_POP_DS()		_asm pop ds 
#define OS_DISABLE_INTERRUPTS() _disable()
#define OS_ENABLE_INTERRUPTS()  _enable()

typedef void (_interrupt far *OS_PINTERRUPT)();
typedef void _interrupt far OS_INTERRUPT(void);

void os_init_channel(int channel, int dma_channel);
void os_pgm_dma(int chan,
	unsigned long count,
	unsigned short mode,
	unsigned short page,
	unsigned short addr);
void os_stop_dma(int channel);
unsigned long os_dma_count(int channel);
unsigned short os_file_read(int handle, void far *io_buffer, unsigned short size);
unsigned short os_file_close(int handle);
unsigned short os_file_seek(int handle, unsigned long offset, int method);
int os_file_open(char far *name);
OS_PINTERRUPT os_getvect(int int_number);
void os_setvect(int int_number, OS_PINTERRUPT isr);
#ifdef OS2
void os_set_irq(int irq, void (RFAR *handler)(void));
#else
void os_set_irq(int irq, OS_PINTERRUPT handler);
#endif
void os_unset_irq(int irq);
void os_eoi(unsigned short irq);
void os_push_disable(void);
void os_popf(void);
