# InterWave Kernel Makefile for Watcom C++
# $Revision: 1.7 $

DEBUG = -d2
BCC3_1 = -DTHREE_1
ASMPROC = -j.386p 
EXTRA =
MODEL = f
DIR = w$(MODEL)
LIBNAME = $(DIR)\iw_os$(MODEL).lib
ASMFLAGS = -DPROC386 -DTASM -q -t -ml -D__f__ -DNEARDATA=1 $(ASMPROC)
OSINCDIR = os\dos32\watcom
CONFIGINCDIR = configs\watcom
INCLUDE = c:\wc\h
!ifeq DEBUG -d2
COPT = -oi
!else
COPT = -oneatx
!endif
WOPTS = -w4 -zq -ei -3r -I$(INCLUDE);$(OSINCDIR);$(CONFIGINCDIR) $(DEBUG) -m$(MODEL) $(COPT) -of+ -s -zp1
CFLAGS = @WOPTS

.obj: $(DIR)

.c.obj:
	wcc386 -fo$(DIR)\ $< $(CFLAGS) 

!ifeq DEBUG -d2
.asm.obj :
        tasm -l -zi $(ASMFLAGS) $< , $(DIR)\
!else
.asm.obj :
        tasm $(ASMFLAGS) $< , $(DIR)\
!endif

OBJS=	iwinit2.obj &
	iwwisr.obj &
	iwsem.obj &
	iwinit.obj &
	iwpnp.obj &
	iwsynth.obj &
	iwload.obj &
	iwisr.obj &
	iwdetct.obj &
	globals.obj &
	iwmem.obj &
	iwdram.obj &
	iwutils.obj &
	iwvoice.obj &
	iwdma.obj &
	iwaddr.obj &
	iwatten.obj &
	iwllist.obj &
	iwnote.obj &
	iwnote1.obj &
	iwnote2.obj &
	iwlfo.obj &
	iwscale.obj &
	timer.obj &
	iwerror.obj &
	iwmidi.obj &
	iwuart.obj &
	iwsound.obj &
	iwdig.obj &
        play.obj &
        record.obj &
        codec.obj &
        mixer.obj &
        play16.obj &
        irq16.obj &
        vars16.obj &
        util16.obj &
	mixctl.obj &
	mixbld.obj &
	iwmls.obj &
	profile.obj &
	profile1.obj &
	effects.obj &
	os.obj &
	os1.obj

all : environ $(DIR)\iw_os$(MODEL).lib .SYMBOLIC
	%null
	
environ: .SYMBOLIC
	set WOPTS=$(WOPTS)

os.obj: $(OSINCDIR)\os.c
	wcc386 -fo$(DIR)\ $(OSINCDIR)\os.c $(CFLAGS) 

os1.obj: $(OSINCDIR)\os1.asm
	wasm -fo$(DIR)\ $(OSINCDIR)\os1.asm

$(LIBNAME): $(OBJS)
        %create temp.lnk
        for %i in ($(objs)) do %append temp.lnk -+wf\%i
	wlib $^@ /n /b @temp.lnk
	del temp.lnk

clean: .SYMBOLIC
	if exist $(DIR)\*.obj del $(DIR)\*.obj
	if exist $(DIR)\*.lib del $(DIR)\*.lib
	if exist $(DIR)\*.bak del $(DIR)\*.bak
