/***************************************************************************
*       NAME:  DRVRDATA.C $Revision: 1.10 $
**      COPYRIGHT:
**      "Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************/
#include <stdio.h>
#include <dos.h>
#include <stdlib.h>
#include <string.h>
#include "sbosdata.h"
#include "sbosdefs.h"
#include "shared.h"
#include "version.h"
#include "fm.h"
#include "synth.h"
#include "mpu401.h"

extern void interrupt new_int02();
extern void interrupt new_int08();
extern void interrupt new_int15();
extern void interrupt new_int21();
extern void interrupt new_int2f();
extern void interrupt new_int7x();
extern void interrupt new_intsynth();
extern void interrupt new_win21();

extern NEW_VECTORS newvec;
extern OLD_VECTORS oldvec;
extern BOARD_CFG config;
extern SBOSDATA sbosdata;
extern unsigned char inst_table[];

/****
    FLAGS BITS
    0    - Data is initialized in the driver by the loader
    1    - MPU-401 emulation on
    2     - NMI is Card IRQ
    3     - Wave data is located in PC RAM instead of DRAM
    4     - Codec has been found
    5     - Line input has been enabled
    6     - Turn off Panning of instruments
    7     - Turn off Frequency Effect
****/

SHARED shared = 
    {
    0, sizeof(SHARED), VERSION_HIGH, VERSION_LOW1,VERSION_LOW2, 0, 0, 0,
    &newvec, &oldvec, &config, &sbosdata, inst_table, 0L, 0L, 0L
    };

NEW_VECTORS newvec = { new_int02, new_int08, new_int15, new_int21, new_int2f,
                       new_int7x, new_intsynth, new_win21 };

unsigned char fm_data;
unsigned int fm_voice;
unsigned int mod_voice;
unsigned int car_voice;
unsigned int fm_chan;
unsigned char hit_perc = 0;
FM_CHANNEL  fm_channel[9]= {0};
FM_OPERATOR fm_operator[18]= { /** The 0x3f is the volume for the voice **/
    0,0x3f,0,0,0,0,0,0, // voice 0
    0,0x3f,0,0,0,0,0,0, // voice 1
    0,0x3f,0,0,0,0,0,0, // voice 2
    0,0x3f,0,0,0,0,0,0, // voice 3
    0,0x3f,0,0,0,0,0,0, // voice 4
    0,0x3f,0,0,0,0,0,0, // voice 5
    0,0x3f,0,0,0,0,0,0, // voice 6
    0,0x3f,0,0,0,0,0,0, // voice 7
    0,0x3f,0,0,0,0,0,0, // voice 8
    0,0x3f,0,0,0,0,0,0, // voice 9
    0,0x3f,0,0,0,0,0,0, // voice 10
    0,0x3f,0,0,0,0,0,0, // voice 11
    0,0x3f,0,0,0,0,0,0, // voice 12
    0,0x3f,0,0,0,0,0,0, // voice 13
    0,0x3f,0,0,0,0,0,0, // voice 14
    0,0x3f,0,0,0,0,0,0, // voice 15
    0,0x3f,0,0,0,0,0,0, // voice 16
    0,0x3f,0,0,0,0,0,0  // voice 17
    };

unsigned char pending_to_do[18]={0};        // on per fm VOICE 

FM_CHANNEL  * chan_ptr;
FM_OPERATOR * voice_ptr;
FM_OPERATOR * mod_ptr;
FM_OPERATOR * car_ptr;

// Global port declarations for use anywhere in the driver
unsigned int reg_mixer;
unsigned int reg_sb2x6;
unsigned int reg_irq_status;
unsigned int reg_dram_io;
unsigned int reg_adlib_status;
unsigned int reg_update_sb2xA;
unsigned int reg_adlib_data;
unsigned int reg_sb2xC;
unsigned int reg_2xC_write;
unsigned int reg_sb2xE;
unsigned int reg_status_read; /** READ **/
unsigned int reg_2xFcontrol; /** WRITE **/
unsigned int reg_2xBindexed;
unsigned int reg_voice_sel;
unsigned int reg_midi_control;
unsigned int reg_midi_data;
unsigned int reg_index;
unsigned int reg_data_high;
unsigned int reg_data_low;
unsigned int reg_388_read;
unsigned int reg_389;

unsigned int reg_codec_addr;
unsigned int reg_codec_data;
unsigned int reg_codec_status;
unsigned int reg_codec_pio;

// These normally point to a return. If MPU401, they point to the
// appropriate handlers.....
PFV start_release_callback;
PFV done_release_callback;

SYN_VOICE *voice_data;      // startup code will init this ...

unsigned char *begin_extra_data;
int extra_data_size;
int rom_flag;

// Only 18 needed for FM. MPU401 on IW needs more ....
unsigned char iw_syn_flags[32]={0};
