/****************************************************************************
	DUMPBNK.H  -- Header information for bank dumping procedures
				  and picking algorithm

****************************************************************************/

#define NUM_CHARS 4    /** number of characters per instrument **/
#define PERC_OFFSET 93 /** instrument 128 is percussion 35 **/
#define MIN_WEIGHT_SPREAD 5 /** no insts in table within 5 of eachother **/

#define WEIGHT_CA 2    /** Weight in picker for Carrier Attack    **/
#define WEIGHT_CR 1    /** Weight in picker for Carrier Release   **/
#define WEIGHT_MS 0    /** Weight in picker for Modulator Sustain **/
#define WEIGHT_FB 1    /** Weight in picker for Feedback          **/

/** Header structure **/
typedef struct
	{
	int some_number;     /** Yep, some number **/
	char adlib[6];       /** Text string "ADLIB" **/
	int num_instruments; /** number of instruments in bank **/
	int num_inst_blocks; /** number of instrument structures in bank **/
	char shit[16];       /** WTFIT ??? **/
	} BNK_HEADER;

/** First instrument structure **/
typedef struct
	{
	int number;   /** instrument number **/
	char one;     /** There is a '1' here ??? **/
	char name[9]; /** 9th one should be a null - 8 valid chars in name **/
	} INST_BLOCK;

/** Data structure **/
typedef struct
	{
	char guess1;
	char guess2;
	char mod_ksl;
	char mod_multi;
	char feedback;
	char mod_attack;
	char mod_sust;
	char mod_sust01;
	char mod_decay;
	char mod_release;
	char mod_vol;
	char mod_vib;
	char mod_trem;
	char mod_ksr;
	char con;
	char car_ksl;
	char car_multi;
	char guess3;
	char car_attack;
	char car_sust;
	char car_sust01;
	char car_decay;
	char car_release;
	char car_vol;
	char car_vib;
	char car_trem;
	char car_ksr;
	char guess4;
	char mod_wave;
	char car_wave;
	} DATA;

struct INST
	{
	char type;     // Melodic or percussion
	char num;      // GM instrument number
	struct INST * next;   // linked list pointers
	struct INST * prev;
	char ca;       // Carrier attack
	char cr;       // Carrier release
	char ma;       // Modulator attack
	char ms;       // Modulator sustain
	char mr;       // Modulator release
	char fb;       // Feedback
//	char sus;      // Instrument sustain flag (from library builder)
	};

typedef struct INST INSTRUMENT;
