
typedef struct {
    unsigned char tag[4];
    unsigned long length;
} CHUNK_HDR;

/* patch structure definitions */
typedef struct {
    unsigned short freq;	/* (0 - 2047) 0.01Hz - 21.5Hz */
    short depth;			/* volume +-(0 - 255) 0.48675dB/step */
    						/* pitch +-(0 - 255) #cents */
    short sweep;			/* 0 - 950 deciseconds */
    unsigned char shape;	/* LFO_TRIANGLE, LFO_POSTRIANGLE */
    unsigned char delay;	/* 0 - 255 deciseconds */
}LFO;

typedef struct {
    short major_id;
    short minor_id;
}DISK_ID;

typedef union {
    /* At runtime, all disk based pointers and ID's are turned into */
    /* memory references for quick access. This mechanism allows */
    /* patch information to be maintained without copying or allocating */
    /* extra memory */
    DISK_ID id;	/* disk based ID or pointer to an ID */
    void RFAR *p;		/* memory based pointer to another struct */
}ID;

typedef struct {
    ID id;						/* waveform id */
    unsigned long size;			/* size of waveform in samples */
    unsigned long start;		/* starting offset in bytes */
    unsigned long loopstart;	/* loop start offset in samples */
    unsigned long loopend;		/* loop end offset in samples */
    unsigned long m_start;		/* position of sample in memory */
    unsigned long sample_ratio;	/* sample ratio (44100 * 1024 / rate) */
    char attenuation;			/* 0 - 127 (no corresponding midi controller) */
    char low_note;				/* lower frequency range for this waveform */
    char high_note;				/* higher frequency range for this waveform */
    unsigned char format;
    unsigned char m_format;		/* in memory copy of patch data format */
    ID data_id;
} IW_WAVE;

typedef struct {
    ID id;		    		/* layer id */
    char nwaves;			/* number of waveforms for this layer */
    char flags;				/* flags: retrigger */
    char high_range;		/* range for layer based */
    char low_range;			/* on either velocity or frequency */
    char pan;				/* pan offset from CC1 (0 left - 127 right) */
    char pan_freq_scale;	/* position based on frequency (0 - 127) */
    LFO tremolo;
    LFO vibrato;
    char velocity_mode;		/* IW_LAYER_TIME, IW_LAYER_RATE */
    char attenuation;		/* 0 - 127 (no corresponding midi controller) */
    short freq_scale;		/* 0 - 2048, 1024 is equal to semitone scaling */
    char freq_center;		/* center for keyboard frequency scaling */
    char layer_event;		/* IW_LAYER_KEY_UP, IW_LAYER_KEY_DOWN */
    ID penv;				/* pitch envelope */
    ID venv;				/* volume envelope */
    IW_WAVE RFAR *waves;	/* not used on disk, but is used in memory */
}IW_LAYER;

typedef struct {
    ID id;					/* patch id */
    short nlayers;			/* number of layers in patch */
    char layer_mode;		/* how are layers activated */
    char exclusion_mode;	/* _NONE, _SINGLE, _MULTIPLE */
    short exclusion_group;	/* group identifier for mutually exclusive */
    						/* patches */
    char effect1;			/* use global effect if available */
    char effect1_depth;		/* 0 - 127 */
    char effect2;			/* use global effect if available */
    char effect2_depth;		/* 0 - 127 */
    unsigned char bank;		/* bank */
    unsigned char program;	/* program */
    IW_LAYER RFAR *layers;	/* not used on disk, but is used in memory */
}IW_PATCH;

#define IW_PATCH_VERSION_MAJOR 0
#define IW_PATCH_VERSION_MINOR 1

typedef struct {
    ID id;					/* program id */
    ID version;				/* patch engine version */
}IW_PROGRAM;

typedef IW_PATCH iw_patch_t;
 
typedef struct {	/* patch editor name chunk */
    ID id;	/* id of chunk to name */
    char name[80];
}IW_NAME;
 
typedef struct {
    ID id;
    char filename[80];
}IW_DATA;
 
typedef struct {
    char num_envelopes;		/* number of envelopes that follow */
    char flags;				/* retrigger & retrigger_layer */
    char mode;				/* 1 shot, sustained, non sustained */
    char index_type;		/* none, velocity, frequency */
}IW_ENVP_HEADER;

typedef struct {
    ID id;		/* envelope id */
    IW_ENVP_HEADER h;
    /* struct iw_envp_record RFAR *records; */
    /* an array of iw_envp_records always follows envp_chunks for both RAM
    and disk data structures */
}IW_ENVP;
 
typedef struct {
    short nattack;
    short nrelease;
    unsigned short sustain_offset;
    unsigned short sustain_rate;
    unsigned short release_rate;
    unsigned char hirange;
    unsigned char pad;
}IW_ENVP_RECORD;

typedef struct {
	short level;
	short rate;
} ENV_DATA;

typedef struct {
	char fff_file[80];
	char fff_path[80];
	unsigned int fff_size;
	CHUNK_HDR *fff_data;
} FFF_INFO;

/* rom header */
typedef struct {
/* 000 */    char iwave[8];
//              "INTRWAVE"
/* 008 */    unsigned char rom_hdr_revision;
//              rom header revision
/* 009 */    unsigned char series_number;
//              series number (for multi chip rom sets or 0)
/* 010 */    char series_name[16];
//              series name for identifying a chip as part of a collection.
/* 026 */    char date[10];
//              rom creation date. i.e. 03/13/1995
/* 036 */    unsigned short vendor_revision_major;
//              revision number (used by manufacturer)
/* 038 */    unsigned short vendor_revision_minor;
//              revision number (used by manufacturer)
/* 040 */    unsigned long rom_size;
//              size of this rom chip in bytes
/* 044 */    char copyright[128];
//              vendors copyright message.  NUL terminated.
/* 172 */    char vendor_name[64];
//              vendors name or information.  NUL terminated.
/* 236 */    char rom_description[128];
//              text description of ROM.  NUL terminated.
/* 364 */    char pad[147];
//              padding - must be zero filled
/* 511 */    unsigned char csum;
//              checksum of header
}ROM_HDR;

