##############################################################################
#
#	makefile for IWSBOS
#   
#   Supports BORLAND V3.1
#      BCC   Version 3.1
#      TASM  Version 3.1
#      TLINK Version 5.1
#      MAKE  Version 3.6
#
###############################################################################

LOAD_NAME=iwsbsldr.exe
DRIV_NAME=iwsbsdrv.exe

###############################################################################
#            Transformation rules
# Compile all .c files with the Borland C++ compiler
###############################################################################
#
# DEBUGGING OPTIONS:
#	Comment these lines to disable the specific debugging options
#
# DEBUG_CODE = debugging code for driver
# DEBUG_ADLIB = add adlib data to debug table info
# DEBUG_SBDAC = add sb dac data to debug table info
#
MPU = MPU401
VAR_PCM = VAR_PCM
RATIONAL_DISK = RATIONAL_DISK
#RATIONAL_FLY = RATIONAL_FLY
!if "$(DEBUG)"=="-v"
DEBUG_CODE = DEBUG
DEBUG_ADLIB = D_AD
DEBUG_SBDAC = D_SB
!endif

!if $(ASM)
ASM = -S -o$&.xxx
!else
#DEBUG = -v
!endif
ASMDEFS=-d$(MPU) -d$(VAR_PCM) -d$(DEBUG_CODE) -d$(DEBUG_ADLIB) -d$(DEBUG_SBDAC) -d$(RATIONAL_DISK) -d$(RATIONAL_FLY)
ASMFLAGS=-zi -q -t $(ASMDEFS) -m3 -I..\windows\viwd
LINKFLAGS=$(DEBUG) -m -3 -L$(LIBPATH)
BNK_NAME = fatv10.bnk

.c.obj:
	bcc -zGDGROUP -zPDGROUP -zSDGROUP $(ASM) -c +bcc.cfg -mt { $*.c}

.asm.obj:
	tasm $(ASMFLAGS) $<

.autodepend

LOADOBJS = loader.obj utillib.obj util.obj loaddac.obj stuffl.obj

DRIVEOBJS   = ints.obj\
	synth.obj\
	calc.obj\
	synint.obj\
	adlib.obj\
	dsp.obj\
	debug.obj\
	timer.obj\
	basend.obj\
	startup.obj\
	mpu401.obj\
	mpu401c.obj\
	mpuend.obj\
	sbc.obj\
	synthc.obj\
	dac.obj\
	drvrdata.obj\
	resfunc.obj\
	xlat.obj\
	pick.obj\
	startupc.obj\
	debugc.obj\
	stufft.obj\
	error.obj

DEBOBJS = sbosdeb.obj stuffl.obj

all:     bcc.cfg pick.h $(DRIV_NAME) $(LOAD_NAME) sbosdeb.exe bldlib.exe sbos.mls
driver:  $(DRIV_NAME)
loader:  $(LOAD_NAME)
debug:   sbosdeb.exe
sbosdeb: sbosdeb.exe
calcadsr: calcadsr.exe

sbos.mls: sbos.txt
	$(TOOLS)\mlscomp\mlscomp sbos.txt

dist: $(DRIV_NAME) $(LOAD_NAME) sbos.mls
	cp -f $(DRIV_NAME) $(IWPROJ)\dist\apps
	cp -f $(LOAD_NAME) $(IWPROJ)\dist\apps
	cp -f sbos.mls $(IWPROJ)\dist\language\english\sbos.mls
	cp -f *.iwl $(IWPROJ)\dist\sbos
	chmod 777 $(IWPROJ)\dist\sbos\*.iwl
	cp -f iwsbos.bat $(IWPROJ)\dist\apps
	chmod 777 $(IWPROJ)\dist\apps\iwsbos.bat

bcc.cfg:
  copy &&|
$(DEBUG)
-I$(INCLUDEPATH)
-L$(LIBPATH)
-D$(MPU)
-D$(VAR_PCM)
-D$(RATIONAL_DISK)
-D$(RATIONAL_FLY)
-D$(DEBUG_CODE)
-D$(DEBUG_ADLIB)
-D$(DEBUG_SBDAC)
-O2 -k- -Z -3 -j12
| bcc.cfg

pick.h: dumpbnk.exe
	dumpbnk $(BNK_NAME) > inst.dmp

dumpbnk.exe: dumpbnk.obj 
	c:\\bc\\bin\\tlink $(LINKFLAGS) $(LIBPATH)\\c0l dumpbnk.obj,dumpbnk.exe,,$(LIBPATH)\\cl.lib

dumpbnk.obj: dumpbnk.c
	bcc +bcc.cfg -ml dumpbnk.c

bldlib.exe: $(SYMBOLIC)
	maker -f makelib.ksh

calcadsr.exe: calcadsr.obj
	bcc +bcc.cfg -ml calcadsr.c

$(DRIV_NAME): $(DRIVEOBJS)
	tlink -L$(LIBPATH) $(DEBUG) @driver.lnk

$(LOAD_NAME):  $(LOADOBJS) 
	tlink $(LINKFLAGS) $(LIBPATH)\\c0l $(LOADOBJS),$(LOAD_NAME),,$(LIBPATH)\\cl.lib

sbosdeb.exe: $(DEBOBJS)
	tlink $(LINKFLAGS) $(LIBPATH)\\c0l $(DEBOBJS),sbosdeb.exe,,$(LIBPATH)\\cl.lib

sbosdeb.obj: sbosdeb.c
	bcc +bcc.cfg -c -ml -DDEBUG sbosdeb.c

loader.obj: loader.c
	bcc +bcc.cfg -c -ml loader.c

util.obj: util.c
	bcc +bcc.cfg -c -ml util.c

utillib.obj: utillib.c
	bcc +bcc.cfg -c -ml utillib.c

loaddac.obj: loaddac.c
	bcc +bcc.cfg -c -ml loaddac.c

stufft.obj: stuff.c
	bcc +bcc.cfg -c -mt -ostufft.obj stuff.c

stuffl.obj: stuff.c
	bcc +bcc.cfg -c -ml -ostuffl.obj stuff.c

calc.obj: pick.inc

zip:
	pkzip newsbos.zip *.c *.h *.asm *.inc make* *.lnk stamp *.cfg *.bnk

zipiw:
	tdstrip *.exe
	pkzip iwsbos.zip $(LOAD_NAME) $(DRIV_NAME) on.bat off.bat
	pkzip iwsbos.zip iwsb512.iwl iwsb1024.iwl
#	pkzip iwsbos.zip read.me

zipmax:
	tdstrip *.exe
	pkzip maxsbos.zip $(LOAD_NAME) $(DRIV_NAME) on.bat off.bat
	pkzip maxsbos.zip sbos512.sbs sbos1024.sbs
#	pkzip maxsbos.zip read.me


clean:
	if exist *.obj del *.obj 
	if exist *.map del *.map 
	if exist *.xxx del *.xxx

tags:
	ctags *.c *.asm *.h

stamp:
	dir > stamp
	$(MAKE) -f make.ksh zip

