#define NUM_VOICES 32

#define MPU_ATTEN (0x7f) /** 7f is no attenuation **/

typedef struct {
	unsigned char flags;
	unsigned char note;
	unsigned char channel;
	unsigned char velocity;
	unsigned int age;
	unsigned int fc;
	}MPU_VOICES ;

#define VOICE_PEDAL_SUSTAIN 0x0001 /** on when pedal forces sustain after noff*/
#define VOICE_IN_RELEASE    0x0002 /** Set if voice is in release phase **/

typedef struct {
	unsigned char flags;
	unsigned char volume;
	unsigned char expression;
	unsigned char pan;
	unsigned int fc_bend_mult; /** Multiplier for the FC for pitch bend **/
	unsigned int pb_sensitivity; /** can be a char **/
	} MPU_CHANNELS;

#define CHAN_PEDAL    0x0001  /** Sustain **/
#define CHAN_RPN_LAST 0x0002  /** If rpn was last - not nrpn **/

void pascal midi_note_off(void);
void pascal midi_note_on(void);
void pascal midi_control_change(void);
void pascal midi_program_change(void);
void pascal midi_pitch_bend(void);
void pascal midi_all_notes_off(void);

void pascal mpu_set_voice_volume(void);
void pascal mpu_update_channel_volume(void);
void pascal mpu_update_channel_frequency(void);
void pascal mpu_set_pedal(int onoff);
void pascal mpu_reset_voice(void);
void pascal mpu_reset_channels(void);
void pascal mpu_full_reset(void);
unsigned int pascal mpu_get_pan(void);
int pascal mpu_get_bend(long);
int  pascal mpu_get_voice(unsigned char);
unsigned long pascal mpu_get_frequency(int note);
int pascal mpu_voice_is_on(void);

void mpu_done_release_callback(void);
void mpu_start_release_callback(void);
int voice_is_playing(void);
