/***************************************************************************
*       NAME:  RESFUNC.C $Revision: 1.16 $
**      COPYRIGHT:
**      "Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************/
#include <dos.h>
#include "sbosdata.h"
#include "sbosdefs.h"
#include "shared.h"
#include "mpu401.h"

// internal prototypes
void reset_synth(void);

extern unsigned char *begin_extra_data;
extern int extra_data_size;
extern SHARED shared;
extern unsigned char fake_sb_irq;
extern unsigned int sb_irq;

extern unsigned int reg_codec_addr;
extern unsigned int reg_codec_data;
extern unsigned int reg_codec_status;
extern unsigned int reg_codec_pio;
#ifdef DEBUG
extern unsigned int reg_index;
extern unsigned int reg_dram_io;
extern unsigned int reg_data_high;
extern unsigned int reg_data_low;
#endif
/****************************************************************************

FUNCTION DEFINITION:
int7x_loaded - Performs any operations that need to be done by the driver
  immediately after the loader has setup the card.

DESCRIPTION:
  Outputs the masks to the card to make sure they were the last to be progd.

EXPECTS:
  DRAM has been loaded, or the system is ROM

*/
void int7x_loaded(void)
{
int i;
unsigned int tbase;
unsigned char *ptr = &(begin_extra_data[0]);

    tbase = shared.codec_base;
    /** create the variables that point to the CODEC registers **/
    /** so we can reference them from assembly language **/
    reg_codec_addr   = tbase++;
    reg_codec_data   = tbase++;
    reg_codec_status = tbase++;
    reg_codec_pio    = tbase;

    for (i=extra_data_size;i>0;i--)
        *ptr++ = 0;

    fake_sb_irq = sb_irq + 0x08;    // set up for simulated SB IRQ
    reset_synth();
    if(shared.status & STAT_MPU401_ENABLED)
        mpu_full_reset();
}

#ifdef DEBUG
void poke_dram( unsigned long address, unsigned char value )
{
    outp(reg_index, 0x43); /** set DRAM low **/
    outpw (reg_data_low, (unsigned int)(address));
    outp(reg_index,0x44); /** set DRAM high **/
    outp(reg_data_high,LOW_B(MS_WORD(address)));
    outp(reg_dram_io,value);
}
#endif

