
typedef     void     (*PFV)(void);

#define FLOOR_VOL 0x06
#define ATTACK_FLOOR 0x80


// Flag for telling whether we are doing FM or MPU401 emul.
#define MPU401_EMUL 1
#define FM_EMUL     2

// Flag for upload envelopes
#define UPLOAD_FM 1
#define UPLOAD_MPU 2

// Flag bit definitions
#define SYN_PLAYING        0x01
#define SYN_SUSTAINING     0x02
#define SYN_PLAY_EFFECT    0x04
#define SYN_PLAY_NOISE     0x08
#define SYN_INJECT_POINT   0x10
#define SYN_MPU401_EMUL    0x20

typedef struct {
    SYN_ENVELOPE    envelope;
    WAVE_INFO wave_info;
    unsigned long frequency;
    int wave_num;
    int old_wave_num;
    unsigned char patch_type;
    unsigned char instrument;
    unsigned char cur_env_point;
    unsigned char start_env;
    unsigned char end_env;
} SYN_VOICE;

