#!/bin/sh

export OPATH="$PATH"; export OPATH

#
#                          ****************************
#                          *** FUNCTION DEFINITIONS ***
#                          ****************************
#
#
# ***********************
# *** BUILD FUNCTIONS ***
# ***********************
#

#
# build ost kernel
#
function make_ost
{
	cd $KERNEL
	export TARGETDIR="$KERNEL\\tt"; export TARGETDIR
	$MAKE -fmakeos.ksh -DMODEL=t $TARGET
	if
		test $? -ne 0
	then
		echo "\n** ost build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}

#
# build osl kernel
#
function make_osl
{
	cd $KERNEL
	export TARGETDIR="$KERNEL\\tl"; export TARGETDIR
	$MAKE -fmakeos.ksh -DMODEL=l $TARGET
	if
		test $? -ne 0
	then
		echo "\n** osl build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}

#
# build osc kernel
#
function make_osc
{
	cd $KERNEL
	export TARGETDIR="$KERNEL\\tc"; export TARGETDIR
	$MAKE -fmakeos.ksh -DMODEL=c $TARGET
	if
		test $? -ne 0
	then
		echo "\n** osc build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}

#
# build oss kernel
#
function make_oss
{
	cd $KERNEL
	export TARGETDIR="$KERNEL\\ts"; export TARGETDIR
	$MAKE -fmakeos.ksh -DMODEL=s $TARGET
	if
		test $? -ne 0
	then
		echo "\n** oss build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}

#
# build osm kernel
#
function make_osm
{
	cd $KERNEL
	export TARGETDIR="$KERNEL\\tm"; export TARGETDIR
	$MAKE -fmakeos.ksh -DMODEL=m $TARGET
	if
		test $? -ne 0
	then
		echo "\n** osm build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}

#
# build os4t kernel
#
function make_os4t
{
	cd $KERNEL
	export TARGETDIR="$KERNEL\\tt"; export TARGETDIR
	$MAKE -fmakeosb4.ksh -DMODEL=t $TARGET
	if
		test $? -ne 0
	then
		echo "\n** os4t build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}

#
# build osm kernel
#
function make_os4l
{
	cd $KERNEL
	export TARGETDIR="$KERNEL\\tl"; export TARGETDIR
	$MAKE -fmakeosb4.ksh -DMODEL=l $TARGET
	if
		test $? -ne 0
	then
		echo "\n** os4l build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}

#
# build watcom kernel
#
function make_watcom
{
	cd $KERNEL
	export TARGETDIR="$KERNEL\\wf"; export TARGETDIR
	$MAKE -f watcom.ksh $TARGET
	if
		test $? -ne 0
	then
		echo "\n** watcom build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}

#
# build lucid kernel
#
function make_lucid
{
	cd $KERNEL
	export TARGETDIR="$KERNEL\\lucid"; export TARGETDIR
	$MAKE -f lucid.ksh $TARGET
	if
		test $? -ne 0
	then
		echo "\n** lucid build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}

#
# build ms6t kernel
#
function make_ms6t
{
	cd $KERNEL
	export TARGETDIR="$KERNEL\\m6t"; export TARGETDIR
	$MAKE -f makems6.ksh MODEL=T $TARGET
	if
		test $? -ne 0
	then
		echo "\n** ms6t build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}

#
# build ms6l kernel
#
function make_ms6l
{
	cd $KERNEL
	export TARGETDIR="$KERNEL\\m6l"; export TARGETDIR
	$MAKE -f makems6.ksh MODEL=L $TARGET
	if
		test $? -ne 0
	then
		echo "\n** ms6l build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}

#
# build ms8t kernel
#
function make_ms8t
{
	cd $KERNEL
	export TARGETDIR="$KERNEL\\mt"; export TARGETDIR
	$MAKE -f makems.ksh MODEL=T $TARGET
	if
		test $? -ne 0
	then
		echo "\n** ms8t build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}

#
# build ms8l kernel
#
function make_ms8l
{
	cd $KERNEL
	export TARGETDIR="$KERNEL\\ml"; export TARGETDIR
	$MAKE -f makems.ksh MODEL=L $TARGET
	if
		test $? -ne 0
	then
		echo "\n** ms8l build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}

#
# build msdllm kernel
#
function make_msdllm
{
	cd $KERNEL
	export TARGETDIR="$KERNEL\\mwdllm"; export TARGETDIR
	$MAKE -f makmsdll.ksh MODEL=M $TARGET
	if
		test $? -ne 0
	then
		echo "\n** msdllm build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}

#
# build os2 kernel
#
function make_os2
{
	cd $KERNEL
	export TARGETDIR="$KERNEL\\os2"; export TARGETDIR
	$MAKE -f makeos2.ksh $TARGET
	if
		test $? -ne 0
	then
		echo "\n** os2 build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}


#
# ***********************
# *** SETUP FUNCTIONS ***
# ***********************
#

#
# reset PATH environment variable
#
function reset
{
	export PATH="$OPATH"; export PATH
}

#
# unset everything
#
function unset_all
{
	unset MAKEINIT
	unset MAKESTARTUP
	unset TOOLROOTDIR
	unset LIBPATH
	unset INCLUDE
	unset INCLUDEPATH
	unset WATCOM
	unset COMPILER
	unset MAKE
	unset BCPATH
	unset MCPATH
	unset WCPATH
	unset MC8INCLUDE
	unset MC6INCLUDE
	unset OSVERSION
	unset MAKEINIT
	unset HELPFILES
	unset INIT
	unset ASMEX
	unset CONFIGINCDIR
}

#
# variables that are unique to each compiler or applicable 
# to all compilers
#
function set_general
{
	export BCPATH="$BCDIR\\bin"; export BCPATH
	export MCPATH="$DDKDIR;$DDKDIR\\tools;$MC8DIR\\bin;$BCDIR\\bin;$MLDIR\\bin;$MLDIR\\binb"; export MCPATH
	export WCPATH="$WCDIR\\bin;$WCDIR\\binb;$BCDIR\\bin"; export WCPATH
	export MC8INCLUDE="$MC8DIR\\include;$MLDIR\\include"; export MC8INCLUDE
	export MC6INCLUDE="$MC6DIR\\include;$MLDIR\\include"; export MC6INCLUDE
	export OSVERSION="6"; export OSVERSION
	export MAKEINIT="$HOME\\etc\\watcomc.mk"; export MAKEINIT
}

#
# set up variables for the borland compiler
#
function set_borland
{
	export MAKESTARTUP="$HOME\\etc\\borlandc.mk"; export MAKESTARTUP
	export TOOLROOTDIR="$BCDIR"; export TOOLROOTDIR
	export COMPILER="$BCDIR"; export COMPILER
	export INCLUDEPATH="$BCDIR\\include"; export INCLUDEPATH
	export CONFIGINCDIR="$KERNEL\\configs\\borland"
	export LIBPATH="$BCDIR\\lib"; export LIBPATH
	export PATH="$PATH;$BCPATH;$COMPILER"
	export MAKE="$BCDIR\\bin\\make" export MAKE;
	if
		test "$DBG" = "Y"
	then
		export DEBUG="-v"; export DEBUG
	fi
}

#
# set up variables for the borland compiler
#
function set_bs4
{
	export MAKESTARTUP="$HOME\\etc\\borlandc.mk"; export MAKESTARTUP
	export TOOLROOTDIR="$BCDIR"; export TOOLROOTDIR
	export COMPILER="$BCDIR"; export COMPILER
	export INCLUDEPATH="$BCDIR\\include"; export INCLUDEPATH
	export LIBPATH="$BCDIR\\lib"; export LIBPATH
	export CONFIGINCDIR="$KERNEL\\configs\\borland"
	export PATH="$PATH;$BCPATH;$COMPILER"
	export MAKE="$BCDIR\\bin\\make" export MAKE;
	if
		test "$DBG" = "Y"
	then
		export DEBUG="-v"; export DEBUG
	fi
}

#
# set up variables for the microsoft compiler
#
function set_ms8
{
	export MAKESTARTUP="$HOME\\etc\\msc.mk"; export MAKESTARTUP
	export TOOLROOTDIR="$MC8DIR"; export TOOLROOTDIR
	export LIBPATH="$MC8DIR\\lib;$MLDIR\\lib\\"; export LIBPATH
	export INCLUDE="$KERNEL\\os\\dos\\micro;$KERNEL\\configs\\borland;.;$MC8INCLUDE"; export INCLUDE
	export HELPFILES="$MLDIR\\help\\*.hlp"; export HELPFILES
	export INIT="$MC6DIR\\init\\"; export INIT
	export ASMEX="$MLDIR\\samples\\"; export ASMEX
	export PATH="$PATH;$MCPATH"
	export MAKE="$MC6DIR\\bin\\nmake" export MAKE;
	if
		test "$DBG" = "Y"
	then
		export DEBUG="-Zi"; export DEBUG
	fi
}

#
# set up variables for msdll compile
#
function set_msdll
{
	export MAKESTARTUP="$HOME\\etc\\msc.mk"; export MAKESTARTUP
	export TOOLROOTDIR="$MC8DIR"; export TOOLROOTDIR
	export LIBPATH="$MC8DIR\\lib;$MLDIR\\lib\\"; export LIBPATH
	export INCLUDE="$KERNEL\\os\\windows;$KERNEL\\configs\\windows;.;$MC8INCLUDE"; export INCLUDE
	export HELPFILES="$MLDIR\\help\\*.hlp"; export HELPFILES
	export INIT="$MC6DIR\\init\\"; export INIT
	export ASMEX="$MLDIR\\samples\\"; export ASMEX
	export PATH="$PATH;$MCPATH"
	export MAKE="$MC6DIR\\bin\\nmake" export MAKE;
	if
		test "$DBG" = "Y"
	then
		export DEBUG="-Zi"; export DEBUG
	fi
}

#
# set up variables for the microsoft compiler
#
function set_ms6
{
	export MAKESTARTUP="$HOME\\etc\\msc.mk"; export MAKESTARTUP
	export TOOLROOTDIR="$MC6DIR"; export TOOLROOTDIR
	export LIBPATH="$MC6DIR\\lib;\$MLDIR\\lib\\"; export LIBPATH
	export INCLUDE="$MC6DIR\\include"; export INCLUDE
	export INCLUDEPATH=".;$KERNEL\\os\\dos\\micro;$MC6DIRINCLUDE"; export INCLUDEPATH
	export HELPFILES="$MLDIR\\help\\*.hlp"; export HELPFILES
	export INIT="$MC8DIR\\init\\"; export INIT
	export ASMEX="$MLDIR\\samples\\"; export ASMEX
	export PATH="$PATH;$MCPATH"
	export MAKE="$MC6DIR\\bin\\nmake" export MAKE;
	if
		test "$DBG" = "Y"
	then
		export DEBUG="-Zi"; export DEBUG
	fi
}

#
# set up variables for the watcom compiler
#
function set_wc
{
	export MAKEINIT="$HOME\\etc\\watcomc.mk"; export MAKEINIT
	export TOOLROOTDIR="$WCDIR"; export TOOLROOTDIR
	export LIBPATH="$WCDIR\\lib"; export LIBPATH
	export INCLUDE="$WCDIR\\H"; export INCLUDE
	export INCLUDEPATH="$INCLUDE;$WCDIR\\include"; export INCLUDEPATH
	export WATCOM="$WCDIR"; export WATCOM
	export CONFIGINCDIR="$KERNEL\\configs\\watcom"; export CONFIGINCDIR
	export COMPILER="$WCDIR"; export COMPILER
	export PATH="$PATH;$WCDIRPATH;$COMPILER"
	export MAKE="$WCDIR\\binb\\wmake" export MAKE;
	if
		test "$DBG" = "Y"
	then
		export DEBUG="-d2"; export DEBUG
	fi
}

#
# set up variables for the lucid compiler
#
function set_lucid
{
	export MAKEINIT="$HOME\\etc\\watcomc.mk"; export MAKEINIT
	export TOOLROOTDIR="$WCDIR"; export TOOLROOTDIR
	export LIBPATH="$WCDIR\\lib"; export LIBPATH
	export INCLUDE="$WCDIR\\H"; export INCLUDE
	export INCLUDEPATH="$INCLUDE;$WCDIR\\include"; export INCLUDEPATH
	export WATCOM="$WCDIR"; export WATCOM
	export CONFIGINCDIR="$KERNEL\\configs\\lucid"; export CONFIGINCDIR
	export COMPILER="$WCDIR"; export COMPILER
	export PATH="$PATH;$WCPATH;$COMPILER"
	export MAKE="$WCDIR\\binb\\wmake" export MAKE;
	if
		test "$DBG" = "Y"
	then
		export DEBUG="-d2"; export DEBUG
	fi
}


#
#                      *****************************
#                      *** START OF SHELL SCRIPT ***
#                      *****************************
#

#
# set up common environment variables
#
set_general

if
	test "$2" = "debug"
then
	export DBG="Y"
	export TARGET=""
else
	export TARGET="$2"
	export DEBUG=""; export DEBUG
fi

if
	test "$TARGET" = "refresh"
then
	pj refresh
	export TARGET=""
fi

#
# **************
# *** KERNEL ***
# **************
#

#
#  borland compiles
#
if
	test $1 = "ost"
then
	reset
	set_borland
	make_ost
elif
	test $1 = "osl"
then
	reset
	set_borland
	make_osl
elif
	test $1 = "osc"
then
	reset
	set_borland
	make_osc
elif
	test $1 = "oss"
then
	reset
	set_borland
	make_oss
elif
	test $1 = "osm"
then
	reset
	set_borland
	make_osm
elif
	test $1 = "osb4t"
then
	reset
	set_bs4
	make_os4t
elif
	test $1 = "osb4l"
then
	reset
	set_bs4
	make_os4l
#
#  microsoft compiles (6)
#
elif
	test $1 = "ms6t"
then
	reset
	set_ms6
	make_ms6t
elif
	test $1 = "ms6l"
then
	reset
	set_ms6
	make_ms6l
#
#  microsoft compiles (8)
#
elif
	test $1 = "ms8t"
then
	reset
	set_ms8
	make_ms8t
elif
	test $1 = "ms8l"
then
	reset
	set_ms8
	make_ms8l
elif
	test $1 = "msdllm"
then
	reset
	set_msdll
	make_msdllm
#
#  os2 compiles
#
elif
	test $1 = "os2"
then
	reset
	set_ms6
	make_os2
#
#
#  watcom compiles
#
elif
	test "$1" = "watcom"
then
	reset
	set_wc
	make_watcom
elif
	test $1 = "lucid"
then
	reset
	set_wc
	make_lucid
#
#
# set up and compile all kernel targets
#
elif
	test "$1" = "allkernels"
then
	cd $KERNEL
	reset
	set_borland
	make_ost
	make_osl
	make_osc
	make_oss
	make_osm
	make_osb4t
	make_osb4l
#
# set up and perform microsoft compiles (6)
#
	reset
	set_ms6
	make_ms6t
	make_ms6l
#
# set up and perform microsoft compiles (8)
#
	reset
	set_ms8
	make_ms8t
	make_ms8l
	make_msdllm
#
# set up and perform os2 compiles
#
	reset
	set_ms8
	make_os2
#
#
# set up and perform watcom compiles
#
	reset
	set_wc
	make_watcom
	make_lucid
	
#
# invalid target
#
else
	echo "$1: unknown target"
	reset
	unset_all
	exit
fi

reset
unset_all
