#!/bin/sh

function refresh
{
    if
	test ! -f sandbox.use
    then
    	echo "Creating sandbox for $1"
	pj sandbox "-P$1"
    fi
    pj refresh -y
    cd $IWPROJ
}

function test_md_cd
{
    if
	test ! -d "$1"
    then
	echo "Creating $1 directory"
	mkdir $1
    fi
    cd $1
}

function make_refresh
{
    test_md_cd scripts
    refresh r:\\proj\\amd\\scripts\\scripts.pj
    
    test_md_cd kernel
    refresh r:\\proj\\amd\\kernel\\kernel.pj
    
    test_md_cd apps
    test_md_cd iwinit
    refresh r:\\proj\\amd\\iwtest\\iwinit\\iwinit.pj
	    
    cd apps\\iwinit
    test_md_cd kernel
    cd "$IWPROJ"
    cd apps
    test_md_cd play
    test_md_cd api
    test_md_cd mikmod
    test_md_cd bin
	    
    cd "$IWPROJ"
    cd apps\\play
    refresh r:\\proj\\amd\\play\\play.pj
    cd apps\\play
    test_md_cd kernel
    
    cd "$IWPROJ"
    test_md_cd windows
    refresh r:\\proj\\amd\\windows\\windows.pj
    
    cd windows
    test_md_cd kernel
    cd "$IWPROJ"
    cd windows
    test_md_cd mixer
    refresh r:\\proj\\amd\\mixer\\mixer.pj
	    
    test_md_cd sbos
    refresh r:\\proj\\amd\\sbos\\iwsbos.pj

    test_md_cd tools
    test_md_cd rommaker
    refresh r:\\proj\\amd\\rommaker\\rommaker.pj
    cd tools\\rommaker
    test_md_cd kernel
    cd "$IWPROJ"
    cd tools
	    
    test_md_cd mlscomp
    refresh r:\\proj\\amd\\mlscomp\\mlscomp.pj
    
    test_md_cd etek
    test_md_cd install
    refresh r:\\proj\\amd\\install\\install.pj
    cd etek
    test_md_cd build
    refresh r:\\proj\\amd\\tools\\build\\build.pj
    cd etek
    test_md_cd ui
    refresh r:\\proj\\amd\\etek\\ui\\ui.pj
    
    cd etek
    test_md_cd midifier
    refresh r:\\proj\\amd\\etek\\midifier\\midifier.pj
    cd etek
    test_md_cd gwin
    refresh r:\\proj\\amd\\etek\\gwin\\gwin.pj
    
    test_md_cd docs
    refresh r:\\proj\\amd\\docs\\docs.pj
    
    test_md_cd binary
    refresh r:\\proj\\amd\\binary\\binary.pj
}

cd "$IWPROJ"
make_refresh "."
