#!/bin/sh

export OPATH="$PATH"; export OPATH

#
#                          ****************************
#                          *** FUNCTION DEFINITIONS ***
#                          ****************************
#
#
# ***********************
# *** BUILD FUNCTIONS ***
# ***********************
#

#
# build sbos
#
function make_sbos
{
	set_borland
	echo "\n***********************"
	echo "*** building sbos..."
	echo "***********************\n"
	cd $IWPROJ\\sbos
	if
		test "$REFRESH" = "Y"
	then
		pj refresh
	fi
		
	$MAKE -f make.ksh $TARGET
	if
		test $? -ne 0
	then
		echo "\n** sbos build failed; exiting\n"
		reset
		unset_all
		exit 1
	fi
}

#
# ***********************
# *** SETUP FUNCTIONS ***
# ***********************
#

#
# reset PATH environment variable
#
function reset
{
	export PATH="$OPATH"; export PATH
}

#
# unset everything
#
function unset_all
{
	unset MAKEINIT
	unset TOOLROOTDIR
	unset LIBPATH
	unset INCLUDE
	unset INCLUDEPATH
	unset WATCOM
	unset COMPILER
	unset PATH
	unset MAKE
	unset DEBUG
	unset BCPATH
	unset MCPATH
	unset WCPATH
	unset MC8INCLUDE
	unset OSVERSION
	unset MAKEINIT
	unset SBOSEXE
}

#
# variables that are unique to each compiler or applicable 
# to all compilers
#
function set_general
{
	export BCPATH="$BCDIR\\bin"; export BCPATH
	export MCPATH="$DDKDIR;$DDKDIR\\tools;$MC8DIR\\bin;$BCDIR\\bin;$MLDIR\\bin;$MLDIR\\binb"; export MCPATH
	export WCPATH="$WCDIR\\bin;$WCDIR\\binb"; export WCPATH
	export MC8INCLUDE="$MC8DIR\\include;$MLDIR\\include"; export MC8INCLUDE
	export OSVERSION="6"; export OSVERSION
	export MAKEINIT="$HOME\\etc\\watcomc.mk"; export MAKEINIT
	export SBOSEXE="$IWPROJ\\dist\\sbos"; export SBOSEXE
	if
		test "$DBG" = "Y"
	then
		export DEBUG="-v"; export DEBUG
	fi
}

#
# set up variables for the borland compiler
#
function set_borland
{
	export MAKESTARTUP="$HOME\\etc\\borlandc.mk"; export MAKESTARTUP
	export TOOLROOTDIR="$BCDIR"; export TOOLROOTDIR
	export COMPILER="$BCDIR"; export COMPILER
	export INCLUDEPATH="$BCDIR\\include"; export INCLUDEPATH
	export LIBPATH="$BCDIR\\lib"; export LIBPATH
	export PATH="$BCPATH;$PATH"
	export MAKE="$BCDIR\\bin\\maker" export MAKE;
}

#
#                      *****************************
#                      *** START OF SHELL SCRIPT ***
#                      *****************************
#

#
# set up common environment variables
#

if
	test "$1" = "debug"
then
	export DBG="Y"
	export TARGET=""
	export REFRESH=""
elif
	test "$1" = "refresh"
then
	export REFRESH="Y"
	export TARGET=""
	export DEBUG=""; export DEBUG
else
	export TARGET="$1"
	export DEBUG=""
	export REFRESH=""
fi

set_general

#
# ********************
# ***     SBOS     ***
# ********************
#

#
# set up and compile the kernel (borland version) and sbos
#
make_sbos
reset
unset_all

