#!/bin/sh

export OPATH="$PATH"; export OPATH

#
#                          ****************************
#                          *** FUNCTION DEFINITIONS ***
#                          ****************************
#
#
# ***********************
# *** BUILD FUNCTIONS ***
# ***********************
#

#
# build the rommaker executable
#
function make_rom
{
	if
		test "$TARGET" = ""
	then
		export CONFIGINCDIR="$ROM"; export CONFIGINCDIR
		export TARGETDIR="$ROM\\kernel"; export TARGETDIR
		make_osl
	fi
	
	echo "\n**********************"
	echo "*** building rommaker..."
	echo "**********************\n"
	cd $ROM
	if
		test "$REFRESH" = "Y"
	then
		pj refresh
	fi
		
	if
		test "$TARGET" = ""
	then
		$MAKE -f make.ksh all
	else
		$MAKE -f make.ksh $TARGET
	fi

	if
		test $? -ne 0
	then
		echo "\n** rommaker build failed; exiting\n"
		reset
		unset_all
		exit 1
	fi
}

#
# build the mlscomp executable
#
function make_mls
{
	echo "\n**********************"
	echo "*** building mlscomp..."
	echo "**********************\n"
	cd $MLS
	if
		test "$REFRESH" = "Y"
	then
		pj refresh
	fi
		
	$MAKE -f make.ksh $TARGET

	if
		test $? -ne 0
	then
		echo "\n** mlscomp build failed; exiting\n"
		reset
		unset_all
		exit 1
	fi
}

#
# build all the tools
#
function make_all
{
	make_mls
	make_rom
}

#
# build osl kernel
#
function make_osl
{
	echo "\n***********************************"
	echo "*** making sure osl kernel exists..."
	echo "***********************************\n"

	cd $KERNEL
	$MAKE -fmakeos.ksh -DMODEL=l
	if
		test $? -ne 0
	then
		echo "\n** osl build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}

#
# ***********************
# *** SETUP FUNCTIONS ***
# ***********************
#

#
# reset PATH environment variable
#
function reset
{
	export PATH="$OPATH"; export PATH
}

#
# unset everything
#
function unset_all
{
	export PATH="$OPATH"; export PATH
	unset MAKEINIT
	unset TOOLROOTDIR
	unset LIBPATH
	unset INCLUDE
	unset INCLUDEPATH
	unset WATCOM
	unset COMPILER
	unset MAKE
	unset BCPATH
	unset OSVERSION
	unset MAKEINIT
	unset ROM
	unset MLS
	unset TOOLEXE
	unset CONFIGINCDIR
	unset TARGETDIR
}

#
# variables that are unique to each compiler or applicable 
# to all compilers
#
function set_general
{
	export BCPATH="$BCDIR\\bin"; export BCPATH
	export OSVERSION="6"; export OSVERSION
	export MAKEINIT="$HOME\\etc\\watcomc.mk"; export MAKEINIT
	export ROM="$IWPROJ\\tools\\rommaker"; export ROM
	export MLS="$IWPROJ\\tools\\mlscomp"; export MLS
	export TOOLEXE="$IWPROJ\\dist\\tools"; export TOOLEXE
	if
		test "$DEBUG" = "Y"
	then
		export DEBUG="-v"; export DEBUG
	fi
}

#
# set up variables for the borland compiler
#
function set_borland
{
	export MAKESTARTUP="$HOME\\etc\\borlandc.mk"; export MAKESTARTUP
	export TOOLROOTDIR="$BCDIR"; export TOOLROOTDIR
	export COMPILER="$BCDIR"; export COMPILER
	export INCLUDEPATH="$BCDIR\\include"; export INCLUDEPATH
	export LIBPATH="$BCDIR\\lib"; export LIBPATH
	export PATH="$PATH;$BCPATH;$COMPILER"
	export MAKE="$BCDIR\\bin\\maker" export MAKE;
}

#
#                      *****************************
#                      *** START OF SHELL SCRIPT ***
#                      *****************************
#

#
# set up common environment variables
#
reset
export REFRESH=""
if
	test "$2" = "refresh"
then
	export REFRESH="Y"
	export TARGET=""
	export DEBUG=""; export DEBUG
elif
	test "$2" = "debug"
then
	export DEBUG="Y"
	export TARGET=""
	export REFRESH=""
else
	export REFRESH=""
	export DEBUG=""; export DEBUG
	export TARGET="$2"
fi

set_general
set_borland

#
# ********************
# *** APPLICATIONS ***
# ********************
#
# set up and compile the kernel and rommaker source code
#
if
	test "$1" = "rom"
then
	make_rom
	reset
#
# set up and compile the mlscomp source code
#
elif
	test "$1" = "mls"
then
	make_mls
	reset
#
# set up and compile the kernel (osl version) and all apps
#
elif
	test "$1" = "all"
then
	make_all
	reset
#
# invalid target
#
else
	echo "$1: unknown target, exiting"
	reset
	unset_all
	exit
fi

reset
unset_all
