#!/bin/sh

export OPATH="$PATH"; export OPATH



#
# build msdllm kernel
#
function make_msdllm
{
	cd $KERNEL
	$MAKE -f makmsdll.ksh MODEL=M
	if
		test $? -ne 0
	then
		echo "\n** msdllm build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}

#
# reset PATH environment variable
#
function reset
{
	export PATH="$OPATH"; export PATH
}

#
# unset PATH environment variable
#
function unset_all
{
	export PATH="$OPATH"; export PATH
	unset MAKESTARTUP
	unset TOOLROOTDIR
	unset INCLUDE
	unset INCLUDEPATH
	unset HELPFILES
	unset ASMEX
	unset LIBPATH
	unset COMPILER
	unset MAKE
	unset LINKER
	unset INIT
	unset MCPATH
	unset MC8INCLUDE
	unset MC8LIBS
	unset OSVERSION
	unset WINEXE
	unset WIN
	unset TARGETDIR
	unset CL
}

#
# set up variables for msdll compile
#
function set_msdll
{
	export MAKESTARTUP="$HOME\\etc\\msc.mk"; export MAKESTARTUP
	export TOOLROOTDIR="$MC8DIR"; export TOOLROOTDIR
	export LIBPATH="$MC8DIR\\lib;$MLDIR\\lib\\"; export LIBPATH
	export INCLUDE="$WIN;$KERNEL\\os\\windows;$VIWD;.;$MC8INCLUDE"; export INCLUDE
	export HELPFILES="$MLDIR\\help\\*.hlp"; export HELPFILES
	export INIT="$MC8DIR\\init\\"; export INIT
	export ASMEX="$MLDIR\\samples\\"; export ASMEX
	export PATH="$PATH;$MCPATH"
	export TARGETDIR="$WIN\\kernel"; export TARGETDIR
	export MAKE="$MC8DIR\\bin\\nmake" export MAKE
	export PROCESSOR="-DPROC386"; export PROCESSOR
	if
		test "$DBG" = "Y"
	then
		export DEBUG="-Zi"; export DEBUG
		export CPROC="-G2"; export CPROC
		export COPT="-W3 -Od"; export COPT
		export CL="$DEBUG $CPROC $COPT -Gs -GA -Zp1 -Aw $PROCESSOR"; export CL
	else
		export DEBUG=""; export DEBUG
	fi
	export ML="$DEBUG $PROCESSOR -DMASM -D_WINDOWS -Sa -Fl"; export ML


}

function set_win
{
	unset ML
	unset CL
	export MAKESTARTUP="$HOME\\etc\\msc.mk"; export MAKESTARTUP
	export ML="-DMASM -D_WINDOWS -Sa -Fl -VM"; export ML
	export TOOLROOTDIR="$MCDIR"; export TOOLROOTDIR
	export INCLUDE="$KERNEL;$KERNEL\\os\\windows;$IWPROJ\\windows\\minc;$VIWD;$VIWD\\minc;$MC8INCLUDE;$SNDSYSINC"; export INCLUDE
	export INCLUDEPATH="$INCLUDE"; export INCLUDEPATH
	export HELPFILES="$MLDIR\\help\\*.hlp"; export HELPFILES
	export LIB="$WIN\\kernel;$MC8LIBS;$SNDSYSLIB"; export LIB
	export LIBPATH="$BCDIR\\lib;$WIN\\kernel"; export LIBPATH
	export COMPILER="$BCDIR"; export COMPILER
	export MAKE="$MC8DIR\\bin\\nmake" export MAKE
	export ASMDIR="$MLDIR\\binp"; export LINKER
	export PATH="$PATH;$MCPATH;$COMPILER;$SICEDIR;$ASMDIR"
	if
		test "$DBG" = "Y"
	then
		export DEBUG="YES"; export DEBUG
	fi
}

function set_general
{
#
# variables that are unique to each compiler or applicable 
# to all compilers
#
	export MCPATH="$DDKDIR;$DDKDIR\\tools;$MC8DIR\\bin;$BCDIR\\bin;$MLDIR\\bin;$MLDIR\\binb"; export MCPATH
	export MC8INCLUDE="$MC8DIR\\include;$MLDIR\\include"; export MC8INCLUDE
	export MC8LIBS="$MC8DIR\\lib"; export MC8INCLUDE
	export SNDSYSLIB="$SNDSYS\\src\\rlib"; export SNDSYSLIB
	export SNDSYSINC="$SNDSYS\\src\\rinc"; export SNDSYSINC
	export OSVERSION="6"; export OSVERSION
	export WIN="$IWPROJ\\windows"; export WIN
	export MIXER="$IWPROJ\\windows\\mixer"; export MIXER
	export VIWD="$IWPROJ\\windows\\viwd"; export VIWD
	export WINEXE="$IWPROJ\\dist\\windows"; export WINEXE
}


reset
export REFRESH=""
set_general

if
	test "$1" = "debug"
then
	export DBG="Y"
	export TARGET=""
	export REFRESH=""
elif
	test "$1" = "refresh"
then
	export REFRESH="Y"
	export DEBUG=""; export DEBUG
	export TARGET=""
else
	export TARGET="$1"
	export DEBUG=""; export DEBUG
	export REFRESH=""
fi

if
	test "$TARGET" = ""
then
	set_msdll
	make_msdllm
	reset
fi

echo "\n***********************"
echo "*** building windows..."
echo "***********************\n"

reset
set_win

cd $IWPROJ\\windows
if
	test "$REFRESH" = "Y"
then
	pj refresh
fi

$MAKE -f make.ksh $TARGET
if
	test $? -ne 0
then
	echo "\n** windows build failed; exiting\n"
	reset
	unset_all
	exit 1
fi

cd $IWPROJ\\windows\\iwloader
if
	test "$REFRESH" = "Y"
then
	pj refresh
fi

if
	test "$TARGET" != "dist95"
then
	echo "\n***********************"
	echo "*** building iwloader..."
	echo "***********************\n"

	$MAKE -f make.ksh $TARGET
	if
	 	test $? -ne 0
	then
	 	echo "\n** iwloader build failed; exiting\n"
	 	reset
	 	unset_all
	 	exit 1
	fi

	cd $IWPROJ\\windows\\mixer
	if
		test "$REFRESH" = "Y"
	then
		pj refresh
	fi

	echo "\n***********************"
	echo "*** building mixer..."
	echo "***********************\n"

	$MAKE -f make.ksh $TARGET
	if
		test $? -ne 0
	then
		echo "\n** mixer build failed; exiting\n"
		reset
		unset_all
		exit 1
	fi
fi


reset
unset_all
