#include "list.h"

void InitList(struct list RFAR *list)
{
    list->head = 0L;
    list->tail = 0L;
}

void AddNode(struct list RFAR *list, struct node RFAR *node, struct node RFAR *where, int pa)
{
    if (where != 0L) {
	if (pa == PREPEND) {
	    node->next = where;
	    node->prev = where->prev;
	    if (node->prev) {
		node->prev->next = node;
	    } else {
		list->head = node;
	    }
	    where->prev = node;
	} else {
	    node->next = where->next;
	    where->next = node;
	    if (node->next) {
		node->next->prev = node;
	    } else {
		list->tail = node;
	    }
	    where->next = node;
	}
    } else {
	if (pa == PREPEND) {
	    node->next = list->head;
	    if (list->head) {
		list->head->prev = node;
	    } else {
		list->tail = node;
	    }
	    node->prev = 0L;
	    list->head = node;
	} else {
	    node->prev = list->tail;
	    if (list->tail) {
		list->tail->next = node;
	    } else {
		list->head = node;
	    }
	    node->next = 0L;
	    list->tail = node;
	}
    }
}

void DeleteNode(struct list RFAR *list, struct node RFAR *node)
{
    struct node RFAR *t;

    if (node->prev) {
	node->prev->next = node->next;
    } else {
	list->head = node->next;
    }
    if (node->next) {
	node->next->prev = node->prev;
    } else {
	list->tail = node->prev;
    }
}
