/***************************************************************************
*   NAME:  DIGINTR.C $Revision: 1.8 $
**  COPYRIGHT:
**  "Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: digintr.c $
* Revision 1.8  1995/08/07 15:59:08  teckert
* Fixed problem with dram transfer, now uses iw_poke_block()
* Revision 1.7  1995/05/08 09:02:10  teckert
* Added pload dma buf for dram transfers
* Revision 1.6  1995/05/05 13:27:29  teckert
* Fixed ModPlayer bug
* Revision 1.5  1995/05/03 14:10:24  teckert
* Revision 1.4  1995/04/26 15:48:50  sdsmith
* Fixed iwFreeMem function
* Revision 1.3  1995/04/20 07:37:20  teckert
* Added iwSoundOpen and iwSoundClose
* Revision 1.2  1995/03/01 16:55:45  unknown
* Added file header
* Revision 1.1  1995/02/23 15:14:59  sdsmith
* Initial revision
***************************************************************************/
#include <windows.h>
#include <mmsystem.h>
#include <mmddk.h>
#include <iw.h>
#include "wave.h"
#include <viwd.h>
#include "interwav.h"

int nSoundRunning = 0;
int nSoundHandle = 0;

#define SOUND_PRIORITY 0

typedef struct IW_SOUND_tag {    
	DWORD dwPosition;
	DWORD dwStartLoop;
	DWORD dwEndLoop;
	BYTE  bType;    
}IW_SOUND;
typedef IW_SOUND FAR *LPIW_SOUND;    

extern struct iw_dma_buff dma_buf_pload;

/* Ultrasound Memory Access Functions */

/****************************************************************************

FUNCTION DEFINITION:
iwGetMem - exports the Kernel function iw_malloc()
*/
DWORD   FAR PASCAL _export __loadds iwGetMem(
	DWORD dwSize)
{
	if(nSoundRunning==0)
		return 0;
		
	return iw_malloc(dwSize);
}

/****************************************************************************

FUNCTION DEFINITION:
iwFreeMem - exports the Kernel function iw_free()
*/
void    FAR PASCAL _export __loadds iwFreeMem(
	DWORD dwAddr)
{
	if(nSoundRunning!=0)
		iw_free(dwAddr);
	return;
}

/****************************************************************************

FUNCTION DEFINITION:
iwMemAvail - exports the Kernel function iw_mem_avail()
*/
DWORD   FAR PASCAL _export __loadds iwMemAvail(void)
{                  
	if(nSoundRunning==0)
		return 0;
		
	return iw_mem_avail();
}

/****************************************************************************

FUNCTION DEFINITION:
iwMemLargestAvail- exports the Kernel function iw_mem_largest_avail()
*/
DWORD   FAR PASCAL _export __loadds iwMemLargestAvail(void)
{                        
	if(nSoundRunning==0)
		return 0;
  
	return iw_mem_largest_avail();
}

/****************************************************************************

FUNCTION DEFINITION:
iwPeek - exports the Kernel function iw_peek()
*/
BYTE    FAR PASCAL _export __loadds iwPeek(
	DWORD dwAddr)
{                     
	if(nSoundRunning==0)
		return 0;

	return iw_peek(dwAddr);
}

/****************************************************************************

FUNCTION DEFINITION:
iwPoke - exports the Kernel function iw_poke()
*/
void    FAR PASCAL _export __loadds iwPoke(
	DWORD dwAddr,
	BYTE bData)
{               
	if(nSoundRunning==0)
		return;
	    
	iw_poke(dwAddr,bData);
}

/****************************************************************************

FUNCTION DEFINITION:
iwDramTransfer - 
 
DESCRIPTION:
Uses the Kernel function iw_dram_xfer() to transfer the buffer to GF1 memory.  If
the buffer is bigger than the DMA buffer size then a series of transfers is used.

RETURNS: error code
*/
int     FAR PASCAL _export __loadds iwDramTransfer(
	DWORD dwDest,
	LPSTR dwSource,
	DWORD dwSize,
	WORD wDmaControl,
	WORD wDmaFlags)
{                       
	unsigned char ret;
	
        if(nSoundRunning!=0)
            iw_poke_block((unsigned char RFAR *)dwSource,dwDest,dwSize,wDmaControl);

        return 0;
}
  
  
/* Error Message Function */

/****************************************************************************

FUNCTION DEFINITION:
iwGetErrorString - exports the Kernel function iw_error_str()
*/
void    FAR PASCAL _export __loadds iwGetErrorString(
	int nError,
	LPSTR lpBuffer,
	int nLength)
{                                                             
	char FAR *pMsg;
	int nStrLen=0;
	
	if(nSoundRunning==0)
		return;
		
	pMsg = iw_error_str(nError);
	while(*pMsg && nStrLen < nLength)
		*lpBuffer++ = *pMsg++;
	lpBuffer = 0;
}
				 
				 
/* Digital Music Functions */

/****************************************************************************

FUNCTION DEFINITION:
iwSoundOpen - initializes the digital music interface
*/
int     FAR PASCAL _export __loadds  iwSoundOpen(void)
{
	if(nSoundRunning == 0){
		nSoundHandle = HWAllocate(IWAR_SOMEVOICES|IWAR_SOMEMEMORY);
		if(nSoundHandle == -1)
			return 0;
	}
	nSoundRunning++;
	return 1;
}

/****************************************************************************

FUNCTION DEFINITION:
iwSoundClose - closes the digital music interface
*/
int     FAR PASCAL _export __loadds  iwSoundClose(void)
{
	if(nSoundRunning==0)
		return 0;
	nSoundRunning--;
	if(nSoundRunning==0){
		HWFree(nSoundHandle);
	}                
	return 1;
}

/****************************************************************************

FUNCTION DEFINITION:
iwSoundStart - exports the Kernel function iw_sound_start()
*/
int     FAR PASCAL _export __loadds iwSoundStart(
	LPIW_SOUND lpSound,
	int nVolume,
	DWORD dwPeriod,
	WORD wPan,
	DWORD dwFrequency,
	WORD wBend)
{
	if(nSoundRunning==0)
		return -1;
	return iw_sound_start(
		SOUND_PRIORITY,
		(struct iw_sound RFAR *)lpSound,
		nVolume,
		dwPeriod,
		wPan,
		dwFrequency,
		wBend,
		NULL);
}
												 
/****************************************************************************

FUNCTION DEFINITION:
iwSoundMode - exports the Kernel function iw_sound_mode()
*/
void    FAR PASCAL _export __loadds iwSoundMode(
	int nVoice,
	LPIW_SOUND lpSound,
	BYTE bType)
{
	if(nSoundRunning==0)
		return;
	iw_sound_mode(nVoice,(struct iw_sound RFAR *)lpSound,bType);
}
												 
/****************************************************************************

FUNCTION DEFINITION:
iwSoundStop - exports the Kernel function iw_sound_stop()
*/
void    FAR PASCAL _export __loadds iwSoundStop(
	int nVoice)
{
	if(nSoundRunning==0)
		return;
	iw_sound_stop(nVoice);
}

/****************************************************************************

FUNCTION DEFINITION:
iwSoundPlaying - exports the Kernel function iw_sound_playing()
*/
int     FAR PASCAL _export __loadds iwSoundPlaying(
	int nVoice)
{                          
	if(nSoundRunning==0)
		return 0;
	return iw_sound_playing(nVoice);
}

/****************************************************************************

FUNCTION DEFINITION:
iwSoundVolume - exports the Kernel function iw_sound_volume()
*/
void    FAR PASCAL _export __loadds iwSoundVolume(
	int nVoice,
	int nVolume,
	DWORD dwPeriod)
{                                    
	if(nSoundRunning==0)
		return;
	iw_sound_volume(nVoice, nVolume, dwPeriod);
}

/****************************************************************************

FUNCTION DEFINITION:
iwSoundFrequency - exports the Kernel function iw_sound_frequency()
*/
void    FAR PASCAL _export __loadds iwSoundFrequency(
	int nVoice,
	DWORD dwFrequency)
{                                               
	if(nSoundRunning==0)
		return;
	iw_sound_frequency(nVoice, dwFrequency);
}

/****************************************************************************

FUNCTION DEFINITION:
iwSoundPan - exports the Kernel function iw_sound_pan()
*/
void    FAR PASCAL _export __loadds iwSoundPan(
	int nVoice,
	WORD wPan)
{                                            
	if(nSoundRunning==0)
		return;
	iw_sound_pan(nVoice, wPan);
}
