/***************************************************************************
*   NAME:  DRVPROC.C $Revision: 1.5 $
**  COPYRIGHT:
**  "Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: drvproc.c $
* Revision 1.5  1995/04/19 15:06:24  teckert
* Added calls to lock functions during load
* Revision 1.4  1995/03/07 16:02:16  teckert
* Fixed bug (lParam1 instead of lParam)
* Revision 1.3  1995/03/03 12:36:57  teckert
* Added call to configuration dialog.
* Revision 1.2  1995/03/01 16:56:11  unknown
* Added file header
* Revision 1.1  1995/02/23 15:14:59  sdsmith
* Initial revision
***************************************************************************/
#include <windows.h>
#include <mmsystem.h>
			       
void Fix1(void);                               
int Enable(void);
int Disable(void);
LONG  ConfigurationPanel(HWND);

/****************************************************************************

FUNCTION DEFINITION:
DriverProc - The entry point for an installable driver.

DESCRIPTION:
The installable device driver entry point this function handles any messages
for which the default handling is inapropriate the rest are passed on to
DefDriverProc().

RETURNS: a long whose meaning depends upon the message 
*/
LONG FAR PASCAL _loadds DriverProc(
	DWORD dwDriverID,                       // for instance specific messages this is the
								// value returned for the DRV_OPEN message
	HANDLE hDriver,                         // the driver's instance handle
	WORD wMessage,                          // the message
	LONG lParam1,                           // message specific data
	LONG lParam2)                           // message specific data
{
	switch (wMessage) {

		case DRV_LOAD:
#ifdef DEBUG
			OutputDebugString("DRV_LOAD\r\n");
#endif

			/*
			   Sent to the driver when it is loaded. Always the first
			   message received by a driver.

			   dwDriverID is 0L. 
			   lParam1 is 0L.
			   lParam2 is 0L.
				
			   Return 0L to fail the load.

			   DefDriverProc will return NON-ZERO so we don't have to
			   handle DRV_LOAD
			*/
			Fix1();
			Fix2();
			Fix3();
			Fix4();
			return 1L;

		case DRV_FREE:
#ifdef DEBUG
			OutputDebugString("DRV_FREE\r\n");
#endif

			/*
			   Sent to the driver when it is about to be discarded. This
			   will always be the last message received by a driver before
			   it is freed. 

			   dwDriverID is 0L. 
			   lParam1 is 0L.
			   lParam2 is 0L.
				
			   Return value is ignored.
			*/

			return 1L;

		case DRV_OPEN:
#ifdef DEBUG
			OutputDebugString("DRV_OPEN\r\n");
#endif
			 
			/*
			   Sent to the driver when it is opened. 

			   dwDriverID is 0L.
			   
			   lParam1 is a far pointer to a zero-terminated string
			   containing the name used to open the driver.
			   
			   lParam2 is passed through from the drvOpen call.
				
			   Return 0L to fail the open.
 
			   DefDriverProc will return ZERO so we do have to
			   handle the DRV_OPEN message.
			 */

			return 1L;

		case DRV_CLOSE:
#ifdef DEBUG
			OutputDebugString("DRV_CLOSE\r\n");
#endif
		   
			/*
			   Sent to the driver when it is closed. Drivers are unloaded
			   when the close count reaches zero. 

			   dwDriverID is the driver identifier returned from the
			   corresponding DRV_OPEN.
			   
			   lParam1 is passed through from the drvClose call.

			   lParam2 is passed through from the drvClose call.
				
			   Return 0L to fail the close.

			   DefDriverProc will return ZERO so we do have to
			   handle the DRV_CLOSE message.
			*/

			return 1L;

		case DRV_ENABLE:
#ifdef DEBUG
			OutputDebugString("DRV_ENABLE\r\n");
#endif

			/*
			   Sent to the driver when the driver is loaded or reloaded
			   and whenever Windows is enabled. Drivers should only
			   hook interrupts or expect ANY part of the driver to be in
			   memory between enable and disable messages
 
			   dwDriverID is 0L. 
			   lParam1 is 0L.
			   lParam2 is 0L.
				
			   Return value is ignored.
			*/
			return Enable() ? 1L : 0L;

		case DRV_DISABLE:
#ifdef DEBUG
			OutputDebugString("DRV_DISABLE\r\n");
#endif

			/*
			   Sent to the driver before the driver is freed.
			   and whenever Windows is disabled
 
			   dwDriverID is 0L. 
			   lParam1 is 0L.
			   lParam2 is 0L.
				
			   Return value is ignored.
			*/
			Disable();
			return 1L;



		case DRV_QUERYCONFIGURE:
#ifdef DEBUG
			OutputDebugString("DRV_QUERYCONFIGURE\r\n");
#endif

			/*
				Sent to the driver so that applications can
				determine whether the driver supports custom
				configuration. The driver should return a
				non-zero value to indicate that configuration
				is supported.
				
				dwDriverID is the value returned from the DRV_OPEN
				call that must have succeeded before this message
				was sent.
 
				lParam1 is passed from the app and is undefined.
				lParam2 is passed from the app and is undefined.

				Return 0L to indicate configuration NOT supported.
			*/

			return 1L;        // we do do configuration yet

		case DRV_CONFIGURE:
#ifdef DEBUG
			OutputDebugString("DRV_CONFIGURE\r\n");
#endif

			/*
				Sent to the driver so that it can display a custom
				configuration dialog box.

				lParam1 is passed from the app. and should contain
				the parent window handle in the loword.
				lParam2 is passed from the app and is undefined.

				Return value is undefined.

				Drivers should create their own section in system.ini.
				The section name should be the driver name.
			*/

			return ConfigurationPanel((HWND)LOWORD(lParam1));

		case DRV_INSTALL:
#ifdef DEBUG
			OutputDebugString("DRV_INSTALL\r\n");
#endif
			return (LRESULT)DRVCNF_RESTART;

		case DRV_REMOVE:
#ifdef DEBUG
			OutputDebugString("DRV_REMOVE\r\n");
#endif
			return (LRESULT)DRVCNF_RESTART;


		default:
			return DefDriverProc(dwDriverID, hDriver, wMessage,lParam1,lParam2);
		}                  
}
