/***************************************************************************
*   NAME:  INTERWAV.H $Revision: 1.15 $
**  COPYRIGHT:
**  "Copyright (c) 1994, by ETEK Labs
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: interwav.h $
* Revision 1.15  1995/11/10 15:00:33  sdsmith
* Changes for Win95 compatability
* Revision 1.14  1995/10/24 11:26:18  sdsmith
* Fixes for Windows 95 compatability tests
* Revision 1.13  1995/09/05 15:20:31  teckert
* Added the MDEVICECAPSEX structure for Windows 95 support.
* Revision 1.12  1995/09/05 10:19:21  teckert
* Added IWDF_WINDOWS95 flag
* Revision 1.11  1995/07/06 19:07:05  sdsmith
* Additions for Save Settings
* Revision 1.10  1995/06/05 16:13:13  teckert
* Added IWDF_DPMIBUFFER flag definition
* Revision 1.9  1995/05/07 18:27:36  teckert
* Add flag for sharing dma buffer
* Revision 1.8  1995/04/26 17:53:46  teckert
* Added flags to support handling sysex messages from a callback
* Revision 1.7  1995/04/19 18:38:37  teckert
* Added status flag to warn midi device if patch file parsing failed
* Revision 1.6  1995/04/19 15:40:12  sdsmith
* Added support for saving mixer settings
* Revision 1.5  1995/03/30 10:06:55  sdsmith
* Added new mixer support
* Revision 1.4  1995/03/30 10:01:03  teckert
* Added arbitration support
* Revision 1.3  1995/03/17 13:22:28  teckert
* Removed GetDMA and FreeDMA
* Revision 1.2  1995/03/15 15:04:44  teckert
* Added GetDMA and FreeDMA prototypes and defines
* Revision 1.1  1995/02/23 15:15:03  sdsmith
* Initial revision
***************************************************************************/
#ifndef _INTERWAV_H
#define _INTERWAV_H

#include <msmixmgr.h>

#define DRIVER_VERSION      0x0100  // 
       
/* wIWDriverFlags contains information about the configuration of the driver */       
extern WORD wIWDriverFlags;   
extern DWORD Virtual_API;


#define IWDF_VXDPRESENT               0x0001
#define IWDF_VXDBUFFER                0x0002
#define IWDF_VXDARBITRATION           0x0004
#define IWDF_PATCH_CONFIG_FAIL        0x0008
#define IWDF_SYSEXPENDING             0x0010
#define IWDF_INFOREGROUND             0x0020
#define IWDF_SHARINGDMABUF            0x0040
#define IWDF_DPMIBUFFER               0x0080
#define IWDF_WINDOWS95                0x0100


/* Ultrasound Vendor ID */
#define MM_ETEK           34

/* wPid's are left up to the vendor */
#define MM_INTERWAVE_WAVEOUT       13
#define MM_INTERWAVE_WAVEIN        14
#define MM_INTERWAVE_MIDIOUT       15
#define MM_INTERWAVE_MIDISYNTH     16
#define MM_INTERWAVE_MIDIIN        17
#define MM_INTERWAVE_MIXER         18
#define MM_INTERWAVE_AUX           19

/* Setup customized message offsets */
#define MXDM_OFFSET  DRV_USER + 100
#define MIDI_OFFSET  DRV_USER + 200

#define MXDM_GET_STRLEN       MXDM_OFFSET+1
#define MXDM_GET_SETTINGS     MXDM_OFFSET+2
#define MXDM_RESTORE_SETTINGS MXDM_OFFSET+3

/* Mixer device */
#define MAX_WINDOWS_VOLUME 0xFF00
typedef struct {
	MIXERLINE mxl;
	MIXERLINECONTROLS mxlc;
}
MIXERINPUT, *PMIXERINPUT, far *LPMIXERINPUT;

typedef struct {
	MIXERLINE mxl;
	LPMIXERINPUT inputs;
	MIXERLINECONTROLS mxlc;
}
MIXEROUTPUT, *PMIXEROUTPUT, far *LPMIXEROUTPUT;

typedef struct mixer_node_s {
	struct mixer_node_s far *next;
	struct mixer_node_s far *prev;
	short id;
	iw_mixer_node_type type;
	iw_mixer_node_subtype subtype;
	short ordinal;
	short subordinal;
	short attributes;
	int range_min;
	int range_max;
	int weight1;
	int weight2;
	DWORD left;
	DWORD right;
	LONG  fValue;
	union {
		int id;
		struct mixer_node_s far *parent;
	}
	path1;
	union {
		int id;
		struct mixer_node_s far *parent;
	}
	path2;
	unsigned char far *description;
	unsigned char far *name;
}
MIXERNODE, *PMIXERNODE, FAR *LPMIXERNODE;
/***** End of Mixer Stuff ***********************************************/
       

struct RESOURCE_WORDS {
  unsigned int loword,hiword;
};

union RESOURCE {
  struct RESOURCE_WORDS;
  unsigned long dword;
};

/* FUNCTIONS */
extern HINSTANCE ghModule;
extern void far * _pascal MemCopySrc(void far *lpDst, void far *lpSrc, unsigned int cnt);
extern void far * _pascal MemCopyDst(void far *lpDst, void far *lpSrc, unsigned int cnt);
extern void mxdLineChange(int,int);
int HWAllocate(unsigned long);
void HWFree(int);
void PatchesUnloaded(void);

/* Resource string definitions */
#define STR_IWAVE_AUX_DIG_AUDIO 100
#define STR_IWAVE_AUX_DIG_MUSIC 101
#define STR_IWAVE_AUX_MIDI      102
#define STR_IWAVE_AUX_LINE_IN   103
#define STR_IWAVE_AUX_MIC_IN    104
#define STR_IWAVE_AUX_AUX1_IN   105
#define STR_IWAVE_AUX_AUX2_IN   106
#define STR_IWAVE_AUX_MONO_IN   107
#define STR_IWAVE_AUX_DAC_IN    108
#define STR_IWAVE_AUX_ADC_OUT   109
#define STR_IWAVE_AUX_LINE_OUT  110
#define STR_IWAVE_AUX_MONO_OUT  111
#define STR_IWAVE_AUX_LOOPBACK  112
#define STR_MIXER_ADC_OUT_SNAME 113
#define STR_MIXER_ADC_OUT_LNAME 114
#define STR_MIXER_LINE_OUT_SNAME        115
#define STR_MIXER_LINE_OUT_LNAME        116
#define STR_MIXER_MONO_OUT_SNAME        117
#define STR_MIXER_MONO_OUT_LNAME        118
#define STR_MIXER_ADC_IN_SNAME  119
#define STR_MIXER_ADC_IN_LNAME  120
#define STR_MIXER_LINE_IN_SNAME 121
#define STR_MIXER_LINE_IN_LNAME 122
#define STR_MIXER_DAC_IN_SNAME  123
#define STR_MIXER_DAC_IN_LNAME  124
#define STR_MIXER_MIC_IN_SNAME  125
#define STR_MIXER_MIC_IN_LNAME  126
#define STR_MIXER_SYNTH_IN_SNAME        127
#define STR_MIXER_SYNTH_IN_LNAME        128
#define STR_MIXER_AUX1_IN_SNAME 129
#define STR_MIXER_AUX1_IN_LNAME 130
#define STR_MIXER_AUX2_IN_SNAME 131
#define STR_MIXER_AUX2_IN_LNAME 132
#define STR_MIXER_MONO_IN_SNAME 133
#define STR_MIXER_MONO_IN_LNAME 134
#define STR_MIXER_DIG_AUDIO_IN_SNAME    135
#define STR_MIXER_DIG_AUDIO_IN_LNAME    136
#define STR_MIXER_DIG_MUSIC_IN_SNAME    137
#define STR_MIXER_DIG_MUSIC_IN_LNAME    138
#define STR_MIXER_MIDI_IN_SNAME 139
#define STR_MIXER_MIDI_IN_LNAME 140
#define STR_IWAVE_WAVEOUT       1
#define STR_IWAVE_WAVEIN        2
#define STR_IWAVE_MIDI_SYNTH    3
#define STR_IWAVE_MIDIOUT       4
#define STR_IWAVE_MIDIIN        5
#define STR_IWAVE_AUX           6
#define STR_IWAVE_MIXER         7

#ifndef WAVECAPS_SAMPLEACCURATE
/* PnP version of media device caps */
typedef struct {
    DWORD	cbSize;
    LPVOID	pCaps;
} MDEVICECAPSEX;
#endif

#endif /* this must be the last line in the file */
