!if "$(DEBUG)" == "YES"
DEF      = -DDEBUG
DEFT     = /dDEBUG
CLOPT   = -Zi -Od
MASMOPT = -Zi
TASMOPT = /zi
LINKOPT = /CO/LI
!else
DEF     =
DEFT    =
CLOPT   = -Ods
MASMOPT =
TASMOPT =
LINKOPT =
!endif

#               *Translator Definitions*
# LIBPATH = D:\MSVC\INC;%KERNEL%
LIBPATH = $(MCDIR)\INC;$(KERNEL)
# INCLUDEPATH = D:\MSVC\INC
INCLUDEPATH = $(MCDIR)\INC
CC = cl -c -nologo -AS -G2s -Zp1 -GA $(DEF) -I$(INCLUDEPATH) $(CLOPT)
LINK = link /GA/LI/MAP/NOPACKC/ALIGN:16 $(LINKOPT)

# CC = cl -R -2 -v -W -vi- -wpro -weas -wpre -L$(LIBPATH)
# -R generate Object Browser information
# -2 generate 286 instructions
# -v source debugging on
# -W creates Windows obj with all functions exportable
# -vi- will expand inline functions
# -wpro enable warning messages
# -weas "
# -wpre "

#               *Implicit Rules*
.c.obj:
  $(CC) $<

.cpp.obj:
  $(CC) $<

#               *List Macros*

all: iwloader.exe

dist: iwloader.exe
	cp iwloader.exe $(IWPROJ)\dist\windows

clean:
	rm -f *.obj
	rm -f *.exe
	rm -f *.map
	rm -f *.sym
	rm -f *.cod
	rm -f *.pdb
	rm -f *.lib
	rm -f *.lst
	rm -f *.bak

EXE_dependencies =  \
 iwloader.obj \
 $(IWPROJ)\windows\interwav.lib \
 iwloader.def

#               *Explicit Rules*
iwloader.exe: $(EXE_dependencies)
  $(LINK) @<<
 iwloader.obj,
 iwloader,
 ,
 ..\interwav.lib+
 libw.lib+
 slibcew.lib,
 iwloader.def,
<<


#               *Individual File Dependencies*
iwloader.obj: iwloader.c 
