/***************************************************************************
*   NAME:  IWPANEL.C $Revision: 1.10 $
**  COPYRIGHT:
**  "Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: iwpanel.c $
* Revision 1.10  1995/10/31 15:29:43  mks
* Removed copyright
* Revision 1.9  1995/07/06 19:07:07  sdsmith
* Additions for Save Settings
* Revision 1.8  1995/05/31 14:05:28  teckert
* Added multi-language support
* Revision 1.7  1995/05/24 16:07:07  teckert
* Put in work around for Windows restart bug.
* Revision 1.6  1995/05/07 19:51:00  teckert
* Corrected return values for config dialog
* Revision 1.5  1995/05/07 18:50:12  teckert
* Added system.ini buffer sizes
* Revision 1.4  1995/05/04 08:20:34  unknown
* Fixed save of init string of card init error
* Revision 1.3  1995/05/03 13:58:01  unknown
* Fixed Save Settings Checkbox in dialog
* Revision 1.2  1995/04/19 15:40:17  sdsmith
* Added support for saving mixer settings
* Revision 1.1  1995/03/07 14:58:39  teckert
* Initial revision
***************************************************************************/

#include "iwpanel.h"
#include <windows.h>
#include <mmsystem.h>
#include <string.h>
#include <iw.h>
#include "interwav.h"

extern HINSTANCE ghModule;
static BOOL SaveSettings;
static BOOL tempSettings;
BOOL CALLBACK _loadds PanelDialogProc(HWND,UINT,WPARAM,LPARAM);

char iw_ini_file[132];
char buf[8];
char restart_message[132];
char IW_SYSINISECTION[]  = "INTERWAV.DRV";

LONG ConfigurationPanel(HWND hParent)
{
    LONG lResult;
    FARPROC PanelProc;
    char far *lpszEnv;
    
    PanelProc = MakeProcInstance((FARPROC)PanelDialogProc,ghModule);
			  
    lpszEnv = GetDOSEnvironment();
    while (*lpszEnv != '\0') {
	if (_fstrncmp(lpszEnv, "INTERWAVE", lstrlen("INTERWAVE")) == 0) {
	    _fstrncpy((char far *)iw_ini_file,lpszEnv + lstrlen("INTERWAVE") + 1,132);
	    break;
	}
	lpszEnv += lstrlen(lpszEnv) + 1;
    }                
    GetPrivateProfileString((LPCSTR)"mixer settings",
			    (LPCSTR)"SaveOnWindowsExit",
			    (LPCSTR)"false",
			    (LPSTR)buf,
			    sizeof(buf),
			    (LPCSTR)iw_ini_file);
    if (lstrcmp(buf,"true") == 0) 
	SaveSettings = 1;
    else
    	SaveSettings = 0;
    tempSettings = SaveSettings;
    lResult = (LONG)DialogBox(ghModule,"IWSETUP",hParent,PanelProc);

    if (SaveSettings == 1)
	lstrcpy((LPSTR)buf,"true");
    else
	lstrcpy((LPSTR)buf,"false");
    WritePrivateProfileString((LPCSTR)"mixer settings",
			    (LPCSTR)"SaveOnWindowsExit",
			    (LPSTR)buf,
			    (LPCSTR)iw_ini_file);
			  
    FreeProcInstance(PanelProc);
    
    return lResult;
}

void PanelRestore(HWND hDlg)
{
    SetDlgItemInt(hDlg,IWS_PLAYBUF,8,1);
    SetDlgItemInt(hDlg,IWS_RECORDBUF,8,1);
    CheckDlgButton(hDlg, IWS_SAVESETTINGS, 0);
}

void LanguageInit(HWND hDlg)
{
    char version_string[80];
    
    if(iw_mls_getstring("windows.mls", 0, restart_message, 132)==IW_OK)
	SetWindowText(hDlg, restart_message);
    if(iw_mls_getstring("windows.mls", IDOK, restart_message, 132)==IW_OK)
	SetDlgItemText(hDlg, IDOK,restart_message);
    if(iw_mls_getstring("windows.mls", IDCANCEL, restart_message, 132)==IW_OK)
	SetDlgItemText(hDlg, IDCANCEL,restart_message);
    if(iw_mls_getstring("windows.mls", IWS_VERSION, version_string, 132)==IW_OK){
	wsprintf(restart_message,version_string,HIBYTE(DRIVER_VERSION),LOBYTE(DRIVER_VERSION));
	SetDlgItemText(hDlg, IWS_VERSION,restart_message);
    }
    if(iw_mls_getstring("windows.mls", IWS_TITLE, restart_message, 132)==IW_OK)
	SetDlgItemText(hDlg, IWS_TITLE,restart_message);
    //if(iw_mls_getstring("windows.mls", IWS_COPYRIGHT, restart_message, 132)==IW_OK)
//	SetDlgItemText(hDlg, IWS_COPYRIGHT,restart_message);
    if(iw_mls_getstring("windows.mls", IWS_RESTORE, restart_message, 132)==IW_OK)
	SetDlgItemText(hDlg, IWS_RESTORE,restart_message);
    if(iw_mls_getstring("windows.mls", IWS_SAVESETTINGS, restart_message, 132)==IW_OK)
	SetDlgItemText(hDlg, IWS_SAVESETTINGS,restart_message);
    if(iw_mls_getstring("windows.mls", BSIZE_GROUP_BOX, restart_message, 132)==IW_OK)
	SetDlgItemText(hDlg, BSIZE_GROUP_BOX,restart_message);
    if(iw_mls_getstring("windows.mls", PLAYSIZE_TXT, restart_message, 132)==IW_OK)
	SetDlgItemText(hDlg, PLAYSIZE_TXT,restart_message);
    if(iw_mls_getstring("windows.mls", RECSIZE_STR, restart_message, 132)==IW_OK)
	SetDlgItemText(hDlg, RECSIZE_STR,restart_message);
    if(iw_mls_getstring("windows.mls", 20, restart_message, 132)!=IW_OK)
	lstrcpy(restart_message,"Changes will take effect the next time windows is started");
}

BOOL CALLBACK _loadds PanelDialogProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{                       
    char bufsize[3];
    int nBufSize;
    BOOL fTrans;
    static BOOL fBufChanged;
    
    switch(msg){
	case WM_INITDIALOG: 
	    LanguageInit(hDlg);
	    fBufChanged = 0;
	    nBufSize = GetPrivateProfileInt(IW_SYSINISECTION,"PlayBufSize",8,"system.ini");
	    SetDlgItemInt(hDlg,IWS_PLAYBUF,nBufSize,0);
	    nBufSize = GetPrivateProfileInt(IW_SYSINISECTION,"RecordBufSize",8,"system.ini");
	    SetDlgItemInt(hDlg,IWS_RECORDBUF,nBufSize,0);
	    CheckDlgButton(hDlg, IWS_SAVESETTINGS, SaveSettings);
	    break;
	case WM_DESTROY:
	    break;
	case WM_COMMAND:
	    switch(wParam){
		case IDOK:
		    SaveSettings = tempSettings;
		    if(fBufChanged){                      
			nBufSize = GetDlgItemInt(hDlg,IWS_PLAYBUF,&fTrans,0);
			if(nBufSize>9){
				bufsize[0] = '0'+nBufSize/10;
				bufsize[1] = '0'+(nBufSize%10);
				bufsize[2] = 0;
			}else{
				bufsize[0] = '0'+(nBufSize%10);
				bufsize[1] = 0;
			}
			WritePrivateProfileString(IW_SYSINISECTION,"PlayBufSize",nBufSize==8?NULL:bufsize,"system.ini");
			nBufSize = GetDlgItemInt(hDlg,IWS_RECORDBUF,&fTrans,0);
			if(nBufSize>9){
				bufsize[0] = '0'+nBufSize/10;
				bufsize[1] = '0'+(nBufSize%10);
				bufsize[2] = 0;
			}else{
				bufsize[0] = '0'+(nBufSize%10);
				bufsize[1] = 0;
			}
			WritePrivateProfileString(IW_SYSINISECTION,"RecordBufSize",nBufSize==8?NULL:bufsize,"system.ini");
			MessageBox(hDlg,restart_message,"INTERWAV.DRV",MB_OK);
//                        EndDialog(hDlg,DRV_RESTART);
//                        return TRUE;
		    }
		    EndDialog(hDlg,DRV_OK);
		    return TRUE;
		case IDCANCEL:
		    EndDialog(hDlg,DRV_CANCEL);
		    return TRUE;
		case IWS_SAVESETTINGS:
		    tempSettings ^= 1;
		    CheckDlgButton(hDlg, wParam, tempSettings);
		    return TRUE;
		case IWS_PLAYBUF:
		case IWS_RECORDBUF:
		    if(HIWORD(lParam)==EN_KILLFOCUS){
			nBufSize = GetDlgItemInt(hDlg,wParam,&fTrans,0);
			if(nBufSize < 1)
				nBufSize = 1;
			if(nBufSize > 32)
				nBufSize = 32;
			SetDlgItemInt(hDlg,wParam,nBufSize,0);
			return TRUE;
		    }else if(HIWORD(lParam)==EN_CHANGE){
			fBufChanged = 1;
			return TRUE;
		    }
		    break;                              
		case IWS_RESTORE:
		    PanelRestore(hDlg);
		    fBufChanged = 0;
		    return TRUE;
	    }
	    break;
    }
    return FALSE;
}
