############################################################################
#   NAME:  INTERWAV.DEF $Revision: 1.13 $
##  COPYRIGHT:
##  "Copyright (c) 1994,1995 by e-Tek Labs"
##
##       "This software is furnished under a license and may be used,
##       copied, or disclosed only in accordance with the terms of such
##       license and with the inclusion of the above copyright notice.
##       This software or any other copies thereof may not be provided or
##       otherwise made available to any other person. No title to and
##       ownership of the software is hereby transfered."
############################################################################
# $Log: make.ksh $
# Revision 1.13  1995/12/21 14:40:57  wconway
# "dist" target now copies interwav.drv to win95 directory
# Revision 1.12  1995/09/12 11:47:52  wconway
# Revision 1.11  1995/09/12 11:44:04  wconway
# Added dist95 target to copy files to dist\win95
# Revision 1.10  1995/08/02 16:34:22  mleibow
# Revision 1.9  1995/07/11 00:06:25  mleibow
# Revision 1.8  1995/07/10 23:15:15  mleibow
# Revision 1.7  1995/07/10 12:40:23  mleibow
# Revision 1.6  1995/07/06 19:07:08  sdsmith
# Additions for Save Settings
# Revision 1.5  1995/06/12 14:22:08  wweigert
# Added step to create interwav.lib
# Revision 1.4  1995/06/08 11:20:46  wweigert
# Brought up to date with makefile
# Revision 1.3  1995/05/23 12:14:02  wweigert
# updated for new windows stuff
# Revision 1.2  1995/05/19 10:42:58  wweigert
# Revision 1.1  1995/05/17 10:32:16  wweigert
# Initial revision
# Revision 1.8  1995/04/19 18:45:23  teckert
# Added wpatch.c to project
# Revision 1.7  1995/04/19 18:39:54  teckert
# temporarily removed midisysx.c from project
# Revision 1.6  1995/04/19 15:07:11  teckert
# Added fix1-4 to fixed code segments to allow alternate method of page-
# locking code segments without moving them to lower memory addresses
# Revision 1.5  1995/04/11 14:57:00  sdsmith
# Revision 1.4  1995/03/30 16:42:46  teckert
# Removed auxdev.c from the build
# Revision 1.3  1995/03/07 14:49:46  teckert
# Add iwpanel.c to the build
# Revision 1.2  1995/03/01 17:46:39  teckert
# Added file header
# Revision 1.1  1995/02/23 15:14:59  sdsmith
# Initial revision
# To build a non debug version:
#       NMAKE
# To build a debug version:
#       NMAKE DEBUG=YES
############################################################################

#WARNING# the KERNEL environmental variable must point to the kernel directory
KERNELDIR = kernel
NAME = interwav

OBJ1 = interwav.obj initc.obj drvproc.obj digintr.obj iwutil.obj iwpanel.obj
#OBJ2 = midiout.obj midifix.obj midiin.obj
OBJ2 = midiout.obj midifix.obj midiin.obj midisysx.obj
OBJ3 = loadptch.obj wpatch.obj
OBJ4 = wavein.obj  waveout.obj wavefix.obj
OBJ5 = mxd.obj mix.obj auxdev.obj
OBJ6 = wsscanf.obj
OBJ7 = fix1.obj fix2.obj fix3.obj fix4.obj

OBJS = $(OBJ1) $(OBJ2) $(OBJ3) $(OBJ4) $(OBJ5) $(OBJ6) $(OBJ7)

LIB = $(LIB)
LIBS = mdllcew libw mmsystem oldnames $(KERNELDIR)\iw_osdm



!if "$(DEBUG)" == "YES"
KDEBUG = DEBUG=YES
DEF      = -DDEBUG
DEFT     = -dDEBUG
CLOPT   = -Zi -Od
MASMOPT = -Zi
TASMOPT = -zi
LINKOPT = /LI/MAP
!else
KDEBUG = DEBUG=NO
DEF     =
DEFT    =
CLOPT   = -Ods
MASMOPT =
TASMOPT =
LINKOPT =
!endif

# CC     = cl -c -nologo -W3 -Alnw -G2s -Zp1 -Fc -Oxws $(DEF) $(CLOPT)
!if "$(KERNEL)" == "..\\MXKERNEL"
CC      = cl -c -nologo -Alnw -G2s -Zp1 -GD $(DEF) -DMAXKERNEL $(CLOPT)
!else
CC      = cl -c -nologo -Alnw -G2s -Zp1 -GD $(DEF) $(CLOPT) -I$(KERNEL)
!endif

# ASM     = tasm -l -JMASM51 -JQUIRKS -t -d?QUIET $(DEFT) $(TASMOPT)
# ASM    = ml -nologo -Zm -c -Cx -D?QUIET -I. $(DEF) $(MASMOPT)
ASM    = ml -nologo -Zm -c -Cx -D? $(DEF) $(MASMOPT)

LINK    = link /NOPACKC/NOD/NOE/ALIGN:16$(LINKOPT)


.c.obj:
	$(CC) $*.c

.asm.obj:
	$(ASM) $*;

all: $(NAME).drv copy interwav.lib english\windows.mls

dist: english\windows.mls $(NAME).drv
	cp english\windows.mls $(IWPROJ)\dist\language\english
	cp $(NAME).drv $(IWPROJ)\dist\windows
	cp $(NAME).drv $(IWPROJ)\dist\win95

dist95: $(NAME).drv
	cp $(NAME).drv $(IWPROJ)\dist\win95
	
###################################
english\windows.mls: english\windows.txt
	$(TOOLS)\mlscomp\mlscomp english\windows.txt

###################################

# $(NAME).drv: $(OBJS) $(NAME).def $(NAME).res 
$(NAME).drv: $(KERNELDIR)\\iw_osdm.lib $(OBJS) $(NAME).def $(NAME).res
	$(LINK) @<<
	$(OBJ1)+
	$(OBJ2)+
	$(OBJ3)+
	$(OBJ4)+
	$(OBJ5)+
	$(OBJ6)+
	$(OBJ7)
	$(NAME).drv,
	$(NAME).map,
	$(LIBS),
	$(NAME).def
<<
	rc -K $(DEF) $(NAME).res $(NAME).drv
!if "$(DEBUG)" == "YES"
	msym $(NAME)
!endif

# !if "$(DEBUG)" == "YES"
#    -cvpack -p $(NAME).drv
#    mapsym -n $(NAME).map
# !endif

$(NAME).res: $(NAME).rc $(NAME).h 
	rc $(DEF) -r -fo $(NAME).res $(NAME).rc

########### segmentation ##########
#
#   INIT  is the init/exit time segment
#   _TEXT is the interrupt time fixed segment
#   WAVE  is the waveform support
#   MIDI  is the MIDI support
#   AUX   is the AUX support

SEG  = $(CC) -NT TSEG $*.c
# SEGA = $(ASM) -DSEGNAME=TSEG -Fo $*.obj -Ta $*.asm
SEGA = $(ASM) -DSEGNAME=TSEG -Fo$*.obj $*.asm

# libinit.obj    : ; $(SEGA:TSEG=INIT)
drvproc.obj     : ; $(SEG:TSEG=INIT)
initc.obj       : ; $(SEG:TSEG=INIT)
iwpanel.obj     : ; $(SEG:TSEG=INIT)
iwutil.obj      : ; $(SEG:TSEG=INIT)
midiout.obj     : ; $(SEG:TSEG=MIDI)
midiin.obj      : ; $(SEG:TSEG=MIDI)
midifix.obj     : ; $(SEG:TSEG=_TEXT)
midisysx.obj    : ; $(SEG:TSEG=_TEXT)
loadptch.obj    : ; $(SEG:TSEG=_TEXT)
wpatch.obj      : ; $(SEG:TSEG=MIDI)
waveout.obj     : ; $(SEG:TSEG=WAVE)
wavefix.obj     : ; $(SEG:TSEG=_TEXT)
wavein.obj      : ; $(SEG:TSEG=_TEXT)
interwav.obj    : ; $(SEGA:TSEG=_TEXT)
digintr.obj     : ; $(SEG:TSEG=_TEXT)
wsscanf.obj     : ; $(SEG:TSEG=_TEXT)
MXD.obj         : ; $(SEG:TSEG=_TEXT)
MIXER.obj       : ; $(SEG:TSEG=_TEXT)
fix1.obj        : ; $(SEG:TSEG=_TEXT)
fix2.obj        : ; $(SEG:TSEG=_TEXT2)
fix3.obj        : ; $(SEG:TSEG=_TEXT3)
fix4.obj        : ; $(SEG:TSEG=IWSEM_TEXT)


interwav.lib: interwav.drv
	implib interwav.lib interwav.def
	
$(KERNELDIR)\\iw_osdm.lib:
	cd $(KERNEL)
	nmake -f makmsdll.ksh $(KDEBUG) MODEL=M TARGETDIR=$(IWPROJ)\windows\kernel
	cd $(IWPROJ)\windows

############## copy ###############

copy:
	@echo ***** finished making $(NAME) *****

############## clean ##############

clean:
	rm -f *.drv
	rm -f *.obj
	rm -f *.map
	rm -f *.sym
	rm -f *.cod
	rm -f *.pdb
	rm -f *.lib
	rm -f $(NAME).res
	rm -f $(NAME).rws
	rm -f *.bak
	
cleankernel:
	rm -f kernel\\*.obj
	rm -f kernel\\*.lib

cleanall:
	rm -f *.drv
	rm -f *.obj
	rm -f *.map
	rm -f *.sym
	rm -f *.cod
	rm -f *.pdb
	rm -f *.lib
	rm -f *.crf
	rm -f $(NAME).res
	rm -f $(NAME).rws
	rm -f *.bak
	rm -f kernel\\*.obj
	rm -f kernel\\*.lib

###################################
# START Dependencies 

drvproc.obj: drvproc.c

iwpanel.obj: iwpanel.c iwpanel.h

initc.obj: initc.c

iwutil.obj: iwutil.c

wavefix.obj: wavefix.c wave.h

waveout.obj: waveout.c wave.h

wavein.obj: wavein.c wave.h

interwav.obj: interwav.asm

midiin.obj: midiin.c midi.h

midiout.obj: midiout.c midi.h

midifix.obj: midifix.c midi.h

midisysx.obj: midisysx.c midi.h

loadptch.obj: loadptch.c midi.h

wpatch.obj: wpatch.c

mxd.obj: mxd.c sndsys.h interwav.h

mix.obj: mix.c sndsys.h interwav.h

fix1.obj: fix1.c

fix2.obj: fix2.c

fix3.obj: fix3.c

fix4.obj: fix4.c

# END Dependencies
